/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.json.adapter.BaseJobAdapter;
import com.bmc.ctmconvert.generated.json.models.base.BaseJob;
import com.bmc.ctmconvert.generated.json.models.job_types.IntegrationFactoryMicroFocusJob;
import java.util.Set;

public class IntegrationFactoryMicroFocusJobAdapter
extends BaseJobAdapter<IntegrationFactoryMicroFocusJob.Type> {
    private final boolean isLinux;

    public static boolean isIntegrationFactoryMicroFocusJob(SchedEntity entity) {
        boolean isWindowsJob = "MFW022023".equals(entity.getAttr("APPL_TYPE"));
        boolean isLinuxJob = IntegrationFactoryMicroFocusJobAdapter.isLinux(entity);
        return isLinuxJob || isWindowsJob;
    }

    public static boolean isLinux(SchedEntity entity) {
        return "MFL022023".equals(entity.getAttr("APPL_TYPE"));
    }

    @Override
    public Set<String> getAllUsedVariablesInEntityProperties() {
        return Set.of();
    }

    public IntegrationFactoryMicroFocusJobAdapter(SchedEntity entity, SchedEntity parent) {
        super(entity, parent);
        this.isLinux = IntegrationFactoryMicroFocusJobAdapter.isLinux(entity);
    }

    @Override
    protected BaseJob buildBaseJob() {
        IntegrationFactoryMicroFocusJob integrationFactoryMicroFocusWindowsJob = new IntegrationFactoryMicroFocusJob();
        return integrationFactoryMicroFocusWindowsJob.withType(this.getType()).withConnectionProfile(this.getConnectionProfile()).withJCLFilename(this.getJclFileName()).withPds(this.getJclFilePath()).withEnableJCLVariables(this.getEnableJCLVariables()).withRestartOnRerun(this.getRestartOnReRun());
    }

    private IntegrationFactoryMicroFocusJob.RecaptureABENDCodes getRecaptureABENDCode() {
        return IntegrationFactoryMicroFocusJob.RecaptureABENDCodes.IGNORE;
    }

    private IntegrationFactoryMicroFocusJob.RestartOnRerun getRestartOnReRun() {
        String enable = this.schedEntity.getVariable("%%UCM-RESTART");
        if ("unchecked".equals(enable)) {
            return IntegrationFactoryMicroFocusJob.RestartOnRerun.UNCHECKED;
        }
        return IntegrationFactoryMicroFocusJob.RestartOnRerun.CHECKED;
    }

    private IntegrationFactoryMicroFocusJob.EnableJCLVariables getEnableJCLVariables() {
        String enable = this.schedEntity.getVariable("%%UCM-ACTIVADDVARS");
        if ("unchecked".equals(enable)) {
            return IntegrationFactoryMicroFocusJob.EnableJCLVariables.UNCHECKED;
        }
        return IntegrationFactoryMicroFocusJob.EnableJCLVariables.CHECKED;
    }

    private String getJclFilePath() {
        return this.schedEntity.getVariable("%%UCM-PDS");
    }

    private String getJclFileName() {
        return this.schedEntity.getVariable("%%UCM-JCL");
    }

    private String getConnectionProfile() {
        return this.schedEntity.getVariable("%%UCM-ACCOUNT");
    }

    @Override
    public IntegrationFactoryMicroFocusJob.Type getType() {
        if (this.isLinux) {
            return IntegrationFactoryMicroFocusJob.Type.JOB_MICRO_FOCUS_LINUX;
        }
        return IntegrationFactoryMicroFocusJob.Type.JOB_MICRO_FOCUS_WINDOWS;
    }
}

