/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter.json.adapter;

import com.bmc.ctmconvert.common.draftwriter.json.adapter.VariablesAdapter;
import com.bmc.ctmconvert.generated.json.models.job_types.DetectSpawnedJob;
import java.util.Optional;

public class DetectSpawnedJobAdapter {
    private final VariablesAdapter variablesAdapter;
    private final String defaultDetectJobName;

    public DetectSpawnedJobAdapter(VariablesAdapter variablesAdapter, String defaultDetectJobName) {
        this.variablesAdapter = variablesAdapter;
        this.defaultDetectJobName = defaultDetectJobName;
    }

    public DetectSpawnedJob getDetectSpawnedJob() {
        DetectSpawnedJob detectSpawnedJob = new DetectSpawnedJob().withJobName(this.getJobName());
        this.getDetectAndCreate().ifPresent(detectSpawnedJob::setDetectAndCreate);
        this.getStartSpawnedJob().ifPresent(detectSpawnedJob::setStartSpawnedJob);
        this.getEndInControl().ifPresent(detectSpawnedJob::setJobEndInControlMOnlyAftreChildJobsCompleteOnSap);
        this.getCompletionStatusOnChild().ifPresent(detectSpawnedJob::setJobCompletionStatusDependsOnChildJobsStatus);
        return detectSpawnedJob;
    }

    private Optional<Boolean> getCompletionStatusOnChild() {
        return this.variableToBoolean("%%SAPR3-JOB_STATUS_CHILD");
    }

    private Optional<Boolean> variableToBoolean(String variable) {
        String completionStatus = this.variablesAdapter.getVariableByName(variable).orElse("");
        if ("Y".equals(completionStatus)) {
            return Optional.of(true);
        }
        if ("N".equals(completionStatus)) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private Optional<Boolean> getEndInControl() {
        return this.variableToBoolean("%%SAPR3-JOB_WAIT_CHILD");
    }

    private Optional<Boolean> getStartSpawnedJob() {
        return this.variableToBoolean("%%SAPR3-DETECT_CHILD_RELEASE");
    }

    private String getJobName() {
        return this.variablesAdapter.getVariableByName("%%SAPR3-DETECT_CHILD_JOBNAME").orElse(this.defaultDetectJobName);
    }

    private Optional<DetectSpawnedJob.DetectAndCreate> getDetectAndCreate() {
        String completionStatus = this.variablesAdapter.getVariableByName("%%SAPR3-DETECT_OPTION").orElse("");
        if ("2".equals(completionStatus)) {
            return Optional.of(DetectSpawnedJob.DetectAndCreate.CURRENT_JOB_DEFINITION);
        }
        if ("3".equals(completionStatus)) {
            return Optional.of(DetectSpawnedJob.DetectAndCreate.SPECIFIC_JOB_DEFINITION);
        }
        return Optional.empty();
    }
}

