/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common.draftwriter;

import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.draftwriter.JobConsumer;
import com.bmc.ctmconvert.common.draftwriter.JobMessage;
import com.bmc.ctmconvert.common.draftwriter.MessageMappingInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MessagesAggregator
implements JobConsumer {
    private final HashMap<String, ArrayList<String>> messages;
    private IAttrHolder messageAttrHolder = null;
    private MessageMappingInterface messageMapper;
    private Integer messageCount;

    public MessagesAggregator(MessageMappingInterface msgMapping) {
        this.messageMapper = msgMapping;
        this.messages = new HashMap();
        this.messageCount = 0;
    }

    @Override
    public void update(SchedEntity job, int serial) {
        if (job.hasMessages()) {
            ArrayList<String> jobMessages = job.getMessages();
            if (!this.messages.containsKey(job.getJobName())) {
                this.messages.put(job.getJobName(), new ArrayList());
            }
            for (String msg : jobMessages) {
                this.appendToMessageMap(job.getJobName(), serial, msg, job);
            }
        }
    }

    public void addGeneralMessages(List<String> msgs) {
        if (!this.messages.containsKey("GeneralMessage")) {
            this.messages.put("GeneralMessage", new ArrayList());
        }
        for (String msg : msgs) {
            this.appendToMessageMap("GeneralMessage", 0, msg, null);
        }
    }

    public void setMessageAttrHolder(IAttrHolder messageAttrHolder) {
        this.messageAttrHolder = messageAttrHolder;
    }

    public void appendToMessageMap(String key, int serial, String message, SchedEntity job) {
        Object[] objectArray = new Object[2];
        this.messageCount = this.messageCount + 1;
        objectArray[0] = this.messageCount;
        objectArray[1] = serial;
        String messageUniqueID = String.format("%d-%d", objectArray);
        String newMessage = String.format("%s,%s", messageUniqueID, message);
        this.messages.get(key).add(newMessage);
        if (this.messageAttrHolder == null) {
            this.messageMapper.addMessage(new JobMessage(newMessage, "RESID,MSGID,MSGTYPE,MSGSTATUS,ACTIONABLE,JOBID,MSGVENDOR,RESNUMVAR,RESVAR1,RESVAR2,RESVAR3,RESVAR4,RESVAR5,RESVAR6,RESVAR7,RESVAR8,RESVAR9,RESVAR10,RESVAR11,RESVAR12"), job);
        } else {
            this.messageMapper.addMessage(new JobMessage(this.messageAttrHolder), job);
        }
    }

    @Override
    public void updateReporter(Reporter reporter) {
        reporter.writeResultsFile(this.messages);
    }
}

