/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.common.message_id.MissingMessageId;
import com.bmc.ctmconvert.common.reporter.ActionReporter;
import com.bmc.ctmconvert.common.reporter.CsvActionReporter;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Reporter {
    private static Reporter m_instance = null;
    private int m_entitiesTotal = 0;
    private int m_entitiesConvertedWithoutWarnings = 0;
    private int m_entitiesConvertedWithWarnings = 0;
    private int m_entitiesNotConverted = 0;
    private int m_smartTablesCreated = 0;
    private int m_subTablesCreated = 0;
    private int m_jobsCreated = 0;
    private static ActionReporter actionReporter = ActionReporter.NULL;

    public static void addGlobalAutoEditAction(List<String> messages, String autoEditName, String autoEditValue, String m_jobName) {
        String updatedAutoEditName = ThemeConfiguration.get().updateGlobalVariableName(autoEditName);
        Reporter.addWarningForUsingGlobalVariableInSaaS(messages, autoEditName, m_jobName, updatedAutoEditName);
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "GLOBALVAR");
        action.put("JOBID", m_jobName);
        action.put("ACTENTNAME", updatedAutoEditName);
        action.put("ACTDESC", autoEditValue);
        action.put("ACTSTATUS", "0");
        Reporter.addAction(action);
    }

    private static void addWarningForUsingGlobalVariableInSaaS(List<String> messages, String autoEditName, String m_jobName, String updatedAutoEditName) {
        if (SettingsBooleanKeys.isSaas() && messages != null && !GlobalFunctions.isPoolVariable(autoEditName)) {
            Reporter.addMessage(messages, "WRN20001", m_jobName, Params.instance().getVendorName(), m_jobName, autoEditName, updatedAutoEditName);
        }
    }

    public static void destroy() {
        m_instance = null;
    }

    public void setTotalEntities(int jobs_number) {
        this.m_entitiesTotal = jobs_number;
    }

    public void setTotalNotConvertedEntities(int jobs_number) {
        this.m_entitiesNotConverted = jobs_number;
    }

    public void setTotalConvertedWithWarningEntities(int jobs_number) {
        this.m_entitiesConvertedWithWarnings = jobs_number;
    }

    public void setTotalConvertedWithoutWarningEntities(int jobs_number) {
        this.m_entitiesConvertedWithoutWarnings = jobs_number;
    }

    public void setSmartTablesCreated(int tables_number) {
        this.m_smartTablesCreated = tables_number;
    }

    public void setSubTablesCreated(int tables_number) {
        this.m_subTablesCreated = tables_number;
    }

    public void setJobsCreated(int jobs_number) {
        this.m_jobsCreated = jobs_number;
    }

    public int getTotalEntities() {
        return this.m_entitiesTotal;
    }

    public int getTotalNotConvertedEntities() {
        return this.m_entitiesNotConverted;
    }

    public int getTotalConvertedWithWarningEntities() {
        return this.m_entitiesConvertedWithWarnings;
    }

    public int getTotalConvertedWithoutWarningEntities() {
        return this.m_entitiesConvertedWithoutWarnings;
    }

    public int getSmartTablesCreated() {
        return this.m_smartTablesCreated;
    }

    public int getSubTablesCreated() {
        return this.m_subTablesCreated;
    }

    public int getJobsCreated() {
        return this.m_jobsCreated;
    }

    public static Reporter instance() {
        if (m_instance == null) {
            m_instance = new Reporter();
        }
        return m_instance;
    }

    private static String getResultRow(String msgID, String msgType, String actionable, String jobID, int numVar, String ... stringsArr) {
        Object row = "";
        String msgStatus = "0";
        String numVarSTR = Integer.toString(numVar);
        Object vars = "";
        for (int i = 0; i < stringsArr.length; ++i) {
            vars = i + 1 == stringsArr.length ? (String)vars + stringsArr[i] : (String)vars + stringsArr[i] + ",";
        }
        row = msgID + "," + msgType + "," + msgStatus + "," + actionable + "," + jobID + ",," + numVarSTR + "," + (String)vars;
        return row;
    }

    public void writeResultsFile(HashMap<String, ArrayList<String>> warnings) {
        File resultFile = new File(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "Results.csv");
        if (resultFile.exists()) {
            resultFile.delete();
        }
        try {
            resultFile.createNewFile();
            BufferedWriter fileBW = FileUtils.createNewBufferedWriter(Paths.get(resultFile.getAbsolutePath(), new String[0]), StandardOpenOption.APPEND);
            String csvHeader = "RESID,MSGID,MSGTYPE,MSGSTATUS,ACTIONABLE,JOBID,MSGVENDOR,RESNUMVAR,RESVAR1,RESVAR2,RESVAR3,RESVAR4,RESVAR5,RESVAR6,RESVAR7,RESVAR8,RESVAR9,RESVAR10,RESVAR11,RESVAR12";
            fileBW.write(csvHeader);
            fileBW.write("\n");
            for (String key : warnings.keySet()) {
                ArrayList<String> tmpArr = warnings.get(key);
                for (String warn : tmpArr) {
                    fileBW.write(warn);
                    fileBW.write("\n");
                }
            }
            fileBW.close();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    public static void addMessage(List<String> messages, String msgID, String jobID, String ... stringsArr) {
        String _jobID = GlobalFunctions.AddQuotes(jobID);
        String[] tmpArr = new String[stringsArr.length];
        for (int i = 0; i < stringsArr.length; ++i) {
            if (stringsArr[i] == null) {
                stringsArr[i] = "NULL";
                ConversionLogger.getLogger().info("null value for argument " + i + " in message ID: " + msgID + " ,for job :" + jobID);
            }
            String str = stringsArr[i].replaceAll("\"", "");
            str = str.replaceAll("\r", "");
            str = str.replaceAll("\n", "");
            tmpArr[i] = GlobalFunctions.AddQuotes(str);
        }
        stringsArr = tmpArr;
        MessageId messageId = MessageIdTable.instance().getMessageIds().get(msgID);
        if (messageId == null) {
            messageId = new MissingMessageId(msgID);
        }
        String msgType = messageId.getMessageType(msgID);
        String actionable = messageId.getMessageActionable();
        int numVar = stringsArr.length;
        messages.add(Reporter.getResultRow(msgID, msgType, actionable, _jobID, numVar, stringsArr));
        if (actionable.equalsIgnoreCase("Y")) {
            String messageText = messageId.getMessageText(stringsArr);
            HashMap<String, String> jobAction = new HashMap<String, String>();
            jobAction.put("ACTENTTYPE", "JOB");
            jobAction.put("JOBID", jobID);
            jobAction.put("ACTENTNAME", jobID);
            jobAction.put("ACTENTQTY", "");
            jobAction.put("ACTSTATUS", "0");
            jobAction.put("ACTDESC", messageText.toString());
            Reporter.addAction(jobAction);
        }
    }

    public static void initActionReport() {
        actionReporter.initActionsReport();
    }

    public static void addAction(Map<String, String> action) {
        Reporter.instance().performAddAction(action);
    }

    public static void addActionDbAccount(String jobName, String accountName, String params) {
        HashMap<String, String> action = new HashMap<String, String>();
        action.put("ACTENTTYPE", "DATABASEACC");
        action.put("JOBID", jobName);
        action.put("ACTENTNAME", accountName);
        action.put("ACTSTATUS", "0");
        action.put("ACTPARAMETERS", params);
        Reporter.instance().performAddAction(action);
    }

    public void performAddAction(Map<String, String> action) {
        actionReporter.addAction(action);
    }

    public void initReporter() {
        actionReporter = new CsvActionReporter();
    }

    public void freeCSVWriter() {
        actionReporter.reset();
    }

    public static void addNodeGroupAction(String nodeGroupName, Set<String> nodes, String jobIdForReport) {
        String defaultActionDescription = "";
        Reporter.addNodeGroupAction(nodeGroupName, nodes, jobIdForReport, "");
    }

    public static void addNodeGroupAction(String nodeGroupName, Set<String> nodes, String jobIdForReport, String actionDescription) {
        HashMap<String, String> nodeGroupAction = new HashMap<String, String>();
        nodeGroupAction.put("ACTENTTYPE", "NODEGRP");
        nodeGroupAction.put("JOBID", jobIdForReport);
        nodeGroupAction.put("ACTENTNAME", nodeGroupName);
        nodeGroupAction.put("ACTSTATUS", "0");
        nodeGroupAction.put("ACTNODES", String.join((CharSequence)";", nodes));
        nodeGroupAction.put("ACTDESC", actionDescription);
        Reporter.addAction(nodeGroupAction);
    }

    public static void setInstanceForTesting(Reporter reporter) {
        m_instance = reporter;
    }

    public static class ReporterExecption
    extends RuntimeException {
        private static final long serialVersionUID = -1964672769075278334L;

        public ReporterExecption(String errorMeassge) {
            super(errorMeassge);
        }
    }
}

