/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.common;

import com.bmc.ctmconvert.S3Downloader;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.VersionUpToDateDialog;
import com.bmc.ctmconvert.base.WhatsNewDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;

public class CompareVersionToS3 {
    private String remoteFile;
    private String downloadPath;
    private File downloadFile;
    private final boolean automatic;
    private String newVersionLinkAsHtml;

    public CompareVersionToS3(boolean automatic) {
        this.automatic = automatic;
    }

    public void compareToLatestVersion(String remoteFile, String downloadPath) {
        this.remoteFile = remoteFile;
        this.downloadPath = downloadPath;
        this.downloadFile = new File(downloadPath);
        if (this.retrieveFile()) {
            this.compareVersions();
        }
    }

    private double getVersionAsDouble(String str) {
        String verNum = str.replaceAll(".*(\\d)\\.(\\d)\\.((\\d{2})\\.?(\\d{3})?)", "$1$2$3");
        return Double.parseDouble(verNum);
    }

    private void compareVersions() {
        boolean startPrint = false;
        String allData = "";
        if (!this.downloadFile.exists()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new DataInputStream(new FileInputStream(this.downloadPath))));){
            String strLine;
            double localVersionArr = this.getVersionAsDouble(CompareVersionToS3.getVersionNumber());
            this.newVersionLinkAsHtml = "<br>You can download the latest version from:</br><a href=" + ThemeConfiguration.get().getDownloadPackagePath() + ">  " + ThemeConfiguration.get().getDownloadPackagePath() + "</a>";
            while ((strLine = br.readLine()) != null) {
                if (strLine.startsWith("version=")) {
                    double ver = this.getVersionAsDouble(strLine);
                    strLine = strLine.replaceFirst("version=", "");
                    boolean bl = startPrint = localVersionArr < ver;
                }
                if (!startPrint) continue;
                allData = this.writeHtmlLine(strLine, allData);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
            return;
        }
        boolean needUpdate = startPrint && !allData.isEmpty();
        String messageData = needUpdate ? allData : TextManager.instance().get("NO_UPDATE_HAS_FOUND_BODY");
        String title = needUpdate ? TextManager.instance().get("COMPARE_TO_LAST_VERSION_TITEL") : TextManager.instance().get("NO_UPDATE_HAS_FOUND_TITEL");
        String checkBoxMessage = TextManager.instance().get("COMPARE_TO_LAST_VERSION_CHECKBOX");
        boolean check = SettingsTable.instance().getProperty(SettingsBooleanKeys.COMPARE_TO_LAST_VERSION_THROUGH_FTP);
        if (needUpdate) {
            WhatsNewDialog whatsNewDialog = new WhatsNewDialog(title, messageData, this.newVersionLinkAsHtml, BaseMessageDialog.TYPE.CONFIRM_CHECKBOX, checkBoxMessage, check);
            whatsNewDialog.show();
            boolean yesOrNot = BaseMessageDialog.isCheckBoxCheked();
            SettingsTable.instance().setProperty(SettingsBooleanKeys.COMPARE_TO_LAST_VERSION_THROUGH_FTP, yesOrNot);
        } else if (!this.automatic) {
            VersionUpToDateDialog upToDate = new VersionUpToDateDialog(title, messageData, BaseMessageDialog.TYPE.CONFIRM_CHECKBOX, checkBoxMessage, check);
            upToDate.show();
            boolean yesOrNot = BaseMessageDialog.isCheckBoxCheked();
            SettingsTable.instance().setProperty(SettingsBooleanKeys.COMPARE_TO_LAST_VERSION_THROUGH_FTP, yesOrNot);
        }
    }

    private String writeHtmlLine(String strLine, String allData) {
        if (strLine.contains("PACFD") || strLine.contains("DRCFD")) {
            allData = (String)allData + "<h2>" + strLine + "</h2>";
        } else if (strLine.toLowerCase().contains("what's new")) {
            allData = (String)allData + "<b>" + strLine + "</b>";
        } else if (strLine.toLowerCase().contains("corrected problems")) {
            allData = (String)allData + "<br><b>" + strLine + "</b>";
        } else if (!(strLine.contains("https://control-m-conversion.s3.eu-central-1.amazonaws.com") || strLine.contains("ftp://ftp.bmc.com/pub/") || strLine.contains("You can download the latest version from:"))) {
            allData = (String)allData + "<br>" + strLine + "</br>";
        }
        return allData;
    }

    private boolean retrieveFile() {
        boolean success = false;
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.downloadFile));){
            S3Downloader s3Downloader = new S3Downloader();
            success = s3Downloader.download(this.remoteFile, outputStream);
            if (success) {
                ConversionLogger.getLogger().info(() -> String.format("File: %s has been downloaded successfully", this.downloadFile.getName()));
            } else {
                ConversionLogger.getLogger().info(() -> String.format("File: %s has failed to be download", this.downloadFile.getName()));
                if (!this.automatic) {
                    BaseMessageDialog.showMessageDialog("Check for new version", String.format(TextManager.instance().get("FAILED_TO_RETRIEVE_THE_FILE"), "\n", "\n"), BaseMessageDialog.TYPE.ERROR_MESSAGE);
                }
            }
        }
        catch (Exception ex) {
            if (!this.automatic) {
                BaseMessageDialog.showMessageDialog("Check for new version", String.format(TextManager.instance().get("FAILED_TO_RETRIEVE_THE_FILE"), "\n", "\n"), BaseMessageDialog.TYPE.ERROR_MESSAGE);
            }
            ExceptionHandler.writeToExceptionFile(ex);
            ConversionLogger.getLogger().info("Error: " + ex.getMessage());
        }
        return success;
    }

    public static String getVersionNumber() {
        String fileName = GlobalFunctions.isFileExist(Globs.VERSION_TEXT_FILE) ? Globs.VERSION_TEXT_FILE : "..\\data\\version.txt";
        try {
            List<String> strings = Files.readAllLines(Paths.get(fileName, new String[0]));
            return strings.stream().findFirst().map(firstLIne -> firstLIne.substring("version".length() + 1).trim()).orElse("");
        }
        catch (IOException e) {
            return "";
        }
    }
}

