/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.list;

import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.list.BaseItem;
import com.bmc.ctmconvert.base.list.BaseList;
import com.bmc.ctmconvert.base.list.BaseListItem;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class BaseDetailedList
extends BaseList {
    public static final String DELETE_ITEM_ENABLED = "DELETE_ITEM_ENABLED";
    public static final String DETAILS_TITLES = "DETAILS_TITLES";
    private JPanel detailsContainer;
    private JTextPane details;
    private Action deleteAction;

    public BaseDetailedList(List<Properties> data) {
        this.data = data;
    }

    public BaseDetailedList(List<Properties> data, BaseFieldValidator validator) {
        super(data, validator);
    }

    public BaseDetailedList(List<Properties> data, Properties settings, BaseFieldValidator validator) {
        super(data, settings, validator);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.details = new JTextPane();
        this.details.setEditable(false);
        this.details.setBackground(FlowGlobals.fieldDefaultBackground);
        SimpleAttributeSet set = new SimpleAttributeSet();
        StyleConstants.setLineSpacing(set, 0.4f);
        this.details.setParagraphAttributes(set, false);
        this.detailsContainer = new JPanel();
        this.detailsContainer.setBorder(BorderFactory.createEmptyBorder(4, 12, 4, 2));
        this.detailsContainer.setLayout(new BorderLayout());
        this.detailsContainer.add(this.details);
        this.setDetailsEnabled(true);
    }

    @Override
    protected void addItem(String groupBy, BaseItem item) {
        super.addItem(groupBy, item);
        if (item instanceof BaseListItem) {
            final BaseListItem currItem = (BaseListItem)item;
            this.setDeleteAction(currItem);
            ((BaseListItem)item).setDeleteEnabled(this.settings.getProperty(DELETE_ITEM_ENABLED, "YES").equals("YES"));
            this.mainContainer.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (BaseDetailedList.this.enabled && !e.isConsumed() && e.getKeyCode() == 127) {
                        BaseDetailedList.this.performDeleteAction(new ActionEvent(e.getSource(), e.getID(), currItem.getData().getProperty("NAME")), currItem);
                        e.consume();
                    }
                }
            });
        }
    }

    @Override
    protected BaseItem createItem(Properties prop) {
        return new BaseListItem(prop, (Map)this.settings.get(DETAILS_TITLES));
    }

    public void setDetailsEnabled(boolean detailsEnabled) {
        if (detailsEnabled) {
            this.mainContainer.setLayout(new GridLayout(0, 2));
            this.mainContainer.add(this.detailsContainer);
        } else {
            this.mainContainer.removeAll();
            this.mainContainer.setLayout(new BorderLayout());
            this.mainContainer.add(this.listScrollPane.getComponent());
        }
        this.mainContainer.validate();
        this.mainContainer.repaint();
    }

    @Override
    protected void setMouseListner(final BaseItem item) {
        super.setMouseListner(item);
        item.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                if (BaseDetailedList.this.enabled && item instanceof BaseListItem) {
                    BaseDetailedList.this.details.setText("");
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (BaseDetailedList.this.enabled && item instanceof BaseListItem) {
                    BaseDetailedList.this.details.setText(((BaseListItem)item).getDetails());
                }
            }
        });
    }

    public void setDeleteAction(Action deleteAction) {
        this.deleteAction = deleteAction;
    }

    protected void setDeleteAction(final BaseListItem item) {
        item.addDeleteAction(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseDetailedList.this.performDeleteAction(e, item);
            }
        });
    }

    private void performDeleteAction(ActionEvent e, BaseListItem item) {
        if (BaseMessageDialog.showConfirmDialog("Delete", "Are you sure?")) {
            if (this.selected != null && this.selected.equals(item)) {
                this.selected = null;
            }
            this.data.remove(item.getData());
            this.itemsList.remove(item);
            this.listContainer.remove(item.getComponent());
            this.mainContainer.validate();
            this.mainContainer.repaint();
            if (this.deleteAction != null) {
                this.deleteAction.actionPerformed(new ActionEvent(e.getSource(), e.getID(), item.getData().getProperty("NAME")));
            }
        }
    }
}

