/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base.dataImport;

import com.bmc.ctmconvert.base.BaseBrowseTextField;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.dataImport.ListHandler;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.dataimport.ImportEntryList;
import com.bmc.ctmconvert.dataimport.ImporterType;
import com.bmc.ctmconvert.dataimport.ListEntry;
import com.bmc.ctmconvert.dataimport.TextInputEntry;
import com.bmc.ctmconvert.dataimport.autofiledetect.DataForImportDetector;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EntriesContentPanel
extends BaseContentPanel {
    private final List<BaseField> components = new ArrayList<BaseField>();
    private BaseBrowseTextField detectDirectory;
    private BaseSection section;
    private BaseButton findFilesButton;

    public EntriesContentPanel(ImportEntryList entries) {
        this(entries, null);
    }

    public EntriesContentPanel(ImportEntryList entries, DataForImportDetector dataForImportDetector) {
        super(new BaseTitlePanel(), new BaseFooterPanel(""));
        this.initialize(entries, dataForImportDetector);
    }

    @Override
    public boolean isValid() {
        return this.section.isValid();
    }

    private void initialize(ImportEntryList entries, DataForImportDetector dataForImportDetector) {
        this.setBorder(null);
        this.section = new BaseSection(TextManager.instance().get("SECTION_IMPORT_DATA"));
        for (ImportEntry entry : entries) {
            this.appendFieldToSection(entry, 0);
        }
        if (dataForImportDetector != null) {
            BaseSection detectSection = new BaseSection(this, TextManager.instance().get("AUTO_DETECT_SECTION_TITLE")){

                @Override
                public boolean isValid() {
                    return true;
                }
            };
            this.findFilesButton = new BaseButton(TextManager.instance().get("AUTO_DETECT_BUTTON"));
            this.findFilesButton.setMnemonic(70);
            this.findFilesButton.addActionListener(evt -> this.detectData(entries, dataForImportDetector));
            this.findFilesButton.setEnabled(false);
            this.detectDirectory = this.makeDirectorySelector(TextManager.instance().get("AUTO_DETECT_DIRECTORY_TITLE"));
            detectSection.addField(new BaseField((BaseComponent)this.detectDirectory, TextManager.instance().get("AUTO_DETECT_DIRECTORY_TITLE"), false, TextManager.instance().get("AUTO_DETECT_DIRECTORY_DESCRIPTION")));
            detectSection.addField(new BaseField((BaseComponent)new BaseComponentWrapper(this.findFilesButton), TextManager.instance().get("AUTO_DETECT_BUTTON_TITLE")));
            this.addSection(detectSection);
        }
        this.addSection(this.section);
        this.buildContentPanel();
        this.section.setValid(this.section.isValid());
    }

    private BaseBrowseTextField makeDirectorySelector(String title) {
        BaseBrowseTextField field = new BaseBrowseTextField(new String[]{"Directory"}, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY));
        field.getComponent().setName(title);
        field.addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setButtonEnabled();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setButtonEnabled();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setButtonEnabled();
            }

            private void setButtonEnabled() {
                EntriesContentPanel.this.findFilesButton.setEnabled(EntriesContentPanel.this.detectDirectory.isValid() && !EntriesContentPanel.this.detectDirectory.getText().isEmpty());
            }
        });
        return field;
    }

    private void appendFieldToSection(final ImportEntry entry, int padding) {
        BaseField field;
        BaseFieldValidator.VALIDATOR_TYPE validatorType;
        ImporterType entryType = entry.getType();
        BaseFieldValidator.VALIDATOR_TYPE vALIDATOR_TYPE = validatorType = entry.isMandatory() ? BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH : BaseFieldValidator.VALIDATOR_TYPE.FILE_PATH_OR_EMPTY;
        if (entryType.equals((Object)ImporterType.Directory)) {
            validatorType = entry.isMandatory() ? BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH : BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY;
        } else if (entryType.equals((Object)ImporterType.TextInput)) {
            BaseFieldValidator.VALIDATOR_TYPE vALIDATOR_TYPE2 = validatorType = entry.isMandatory() ? BaseFieldValidator.VALIDATOR_TYPE.NOT_EMPTY : BaseFieldValidator.VALIDATOR_TYPE.DIRECTORY_PATH_OR_EMPTY;
        }
        if (entryType.equals((Object)ImporterType.List)) {
            field = new ListHandler(this.section).getField((ListEntry)entry, padding);
        } else if (entryType.equals((Object)ImporterType.TextInput)) {
            field = this.handleTextInputEntry(entry, padding, validatorType);
        } else if (entryType.equals((Object)ImporterType.SubSectionTitle)) {
            field = this.handleSubSectionTitleEntry(entry, padding);
        } else {
            final BaseBrowseTextField textField = new BaseBrowseTextField(entry.getExtensionFilter(), new BaseFieldValidator(validatorType));
            textField.getComponent().setName(entry.getID());
            textField.setText(entry.getSourceFullName());
            textField.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    entry.setSourceFullName(textField.getText().trim());
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            field = new BaseField(textField, entry.getTitle(), entry.isMandatory(), padding, entry.getDescription());
        }
        this.components.add(field);
        this.section.addField(field);
    }

    private BaseField handleSubSectionTitleEntry(ImportEntry entry, int padding) {
        BaseField field = new BaseField(entry.getTitle(), padding);
        field.setValid(true);
        for (ImportEntry child : entry.getImportEntryChildren()) {
            this.appendFieldToSection(child, 17);
        }
        return field;
    }

    private BaseField handleTextInputEntry(final ImportEntry entry, int padding, BaseFieldValidator.VALIDATOR_TYPE validatorType) {
        final BaseTextField baseTextField = new BaseTextField(new BaseFieldValidator(validatorType));
        ((TextInputEntry)entry).setInputTextValue(baseTextField.getText().trim());
        baseTextField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ((TextInputEntry)entry).setInputTextValue(baseTextField.getText().trim());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        return new BaseField(baseTextField, entry.getTitle(), entry.isMandatory(), padding, entry.getDescription());
    }

    private void detectData(ImportEntryList entries, DataForImportDetector dataForImportDetector) {
        this.setBusyWait(true);
        for (ImportEntry entry : entries) {
            entry.setSourceFullName("");
            entry.setSourceFullNames(Collections.emptyList());
        }
        boolean success = dataForImportDetector.detectData(entries, this.detectDirectory.getText());
        boolean isMultiFiles = StreamSupport.stream(entries.spliterator(), false).anyMatch(e -> e.getSourceFullNames().size() > 1);
        block1: for (BaseField component : this.components) {
            for (ImportEntry entry : entries) {
                if (!entry.getTitle().equals(component.getTitle())) continue;
                BaseBrowseTextField field = (BaseBrowseTextField)component.getBaseComponent();
                if (entry.getSourceFullNames().isEmpty()) {
                    field.setText("");
                } else if (entry.getSourceFullNames().size() == 1) {
                    field.setText(entry.getSourceFullNames().get(0));
                } else if (entry.getSourceFullNames().size() > 1) {
                    String dirList = entry.getSourceFullNames().stream().map(s -> Path.of(s, new String[0]).getParent()).filter(Objects::nonNull).map(Path::getFileName).distinct().map(name -> String.valueOf(name) + "/").collect(Collectors.joining(", "));
                    field.setText(entry.getSourceFullNames().size() + " files in " + (dirList.isEmpty() ? "/" : dirList));
                }
                if (isMultiFiles) {
                    field.setEnabled(false);
                    field.setValid(true);
                    field.setValidityLook(true);
                    continue block1;
                }
                field.setEnabled(true);
                continue block1;
            }
        }
        this.setBusyWait(false);
        if (!ProcessAlertsManager.instance().getMessages().isEmpty()) {
            BaseMessageDialog.showMessageDialog(TextManager.instance().get("AUTO_DETECT_MESSAGE_DIALOG_TITLE"), TextManager.instance().get("AUTO_DETECT_MESSAGE_DIALOG_TEXT"), success ? BaseMessageDialog.TYPE.INFORMATION_MESSAGE : BaseMessageDialog.TYPE.ERROR_MESSAGE, ProcessAlertsManager.instance().getMessages(), true);
            ProcessAlertsManager.instance().init();
        }
    }

    public Component getFirstComponent() {
        if (this.components.isEmpty()) {
            return null;
        }
        return this.components.get(0).getBaseComponent().getComponent();
    }

    public void setBusyWait(boolean wait) {
        this.getComponent().setCursor(Cursor.getPredefinedCursor(wait ? 3 : 0));
    }
}

