/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;

public class RoundedCornerButton
extends JButton {
    Shape shape;

    public RoundedCornerButton(String label) {
        super(label);
        this.setContentAreaFilled(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.getModel().isArmed()) {
            g.setColor(ThemeConfiguration.get().getWelcomePageTheme().continueActiveColor);
        } else {
            g.setColor(this.getBackground());
        }
        int arcSize = this.getSize().height / 2 + 1;
        g.fillRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, arcSize, arcSize);
        super.paintComponent(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
        int arcRadius = this.getSize().height / 2 + 1;
        g.setColor(this.getForeground());
        g.drawRoundRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, arcRadius, arcRadius);
    }

    @Override
    public boolean contains(int x, int y) {
        if (this.shape == null || !this.shape.getBounds().equals(this.getBounds())) {
            this.shape = new Rectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        return this.shape.contains(x, y);
    }
}

