/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;

public class BaseTextContainer
extends BaseComponent {
    private JTextArea jTextArea;
    private JScrollPane jScrollPane;
    boolean setAutoResize = true;
    private Dimension size;

    public BaseTextContainer(String text) {
        this.jTextArea = new JTextArea(text);
        this.initialize();
    }

    public BaseTextContainer(Dimension size) {
        this.size = size;
        this.jTextArea = new JTextArea();
        this.initialize();
    }

    private void initialize() {
        this.jTextArea.setBorder(null);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setWrapStyleWord(true);
        this.jTextArea.setBackground(FlowGlobals.fieldDefaultBackground);
        this.jTextArea.setEditable(false);
        this.jTextArea.setCursor(Cursor.getPredefinedCursor(2));
        this.jTextArea.setFont(FlowGlobals.FONT_STYLE_REGULAR);
        if (this.size != null) {
            this.jScrollPane = new JScrollPane(this.jTextArea);
            this.jScrollPane.setBorder(null);
            this.jScrollPane.setPreferredSize(this.size);
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setBackground(FlowGlobals.fieldDefaultBackground);
        } else {
            this.jTextArea.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (BaseTextContainer.this.setAutoResize) {
                        BaseTextContainer.this.setAutoResize = false;
                        BaseTextContainer.this.jTextArea.getParent().getParent().addComponentListener(new ComponentAdapter(){

                            @Override
                            public void componentResized(ComponentEvent e) {
                                Dimension size = new Dimension(((Component)e.getSource()).getWidth() - 60, 10);
                                if (size.width > 532) {
                                    BaseTextContainer.this.jTextArea.setSize(size);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    public void setText(String t) {
        this.jTextArea.setText(t);
        this.jTextArea.setLineWrap(true);
        this.jTextArea.setCaretPosition(0);
    }

    public void setBorder(Border border) {
        if (this.size != null) {
            this.jScrollPane.setBorder(border);
        } else {
            this.jTextArea.setBorder(border);
        }
    }

    public void setLineWrap(boolean wrap) {
        this.jTextArea.setLineWrap(wrap);
    }

    public void setEditable(boolean b) {
        this.jTextArea.setEditable(b);
    }

    public void setAutoResize(boolean autoResize) {
        this.setAutoResize = autoResize;
    }

    @Override
    public Component getComponent() {
        return this.size != null ? this.jScrollPane : this.jTextArea;
    }
}

