/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.TextManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class BaseFrame
extends BaseComponent {
    private JFrame jFrame;
    private JPanel jPanel;
    private JToolBar toolbar;
    private JFrame mainRelativeTo;
    private boolean enableEscape;

    public BaseFrame() {
        this.enableEscape = true;
        this.jFrame = new JFrame();
        this.initialize();
    }

    public BaseFrame(String title, boolean mainFrame) {
        this.jFrame = new JFrame(title);
        if (mainFrame) {
            this.mainRelativeTo = this.jFrame;
        }
        this.initialize();
    }

    private void initialize() {
        this.jFrame.setSize(1050, 750);
        this.jFrame.setLocationRelativeTo(null);
        this.jFrame.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(FlowGlobals.BMC_ICON_PATH)));
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BorderLayout());
        this.jPanel.setBackground(Color.WHITE);
        this.jFrame.setContentPane(this.jPanel);
        this.jFrame.setBackground(Color.WHITE);
        this.jFrame.setDefaultCloseOperation(0);
        this.jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                BaseFrame.this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
            }
        });
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(e -> {
            if (this.jFrame.isActive() && e.getID() == 401) {
                if (e.getKeyCode() == 112) {
                    this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"));
                } else if (this.enableEscape && e.getKeyCode() == 27) {
                    this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"));
                } else {
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    public void setJMenuBar(JMenuBar menubar) {
        this.jFrame.setJMenuBar(menubar);
    }

    public void setJToolBar(JToolBar toolbar) {
        if (this.toolbar != null) {
            this.jPanel.remove(this.toolbar);
        }
        this.toolbar = toolbar;
        this.jPanel.add((Component)toolbar, "North");
        this.jPanel.validate();
        this.jPanel.repaint();
    }

    public void setContent(BaseComponent pane) {
        this.jPanel.removeAll();
        this.jPanel.add(pane.getComponent(), "Center");
        if (this.toolbar != null) {
            this.jPanel.add((Component)this.toolbar, "North");
        }
        this.jFrame.validate();
        this.jFrame.repaint();
    }

    public void setVisible(boolean b) {
        if (this.mainRelativeTo != null && b) {
            int paddingFromMain = 30;
            Point point = this.jFrame.getLocation();
            Point mainPoint = this.mainRelativeTo.getLocation();
            if (mainPoint.x > point.x - paddingFromMain && mainPoint.x < point.x + paddingFromMain) {
                point.x = mainPoint.x + paddingFromMain;
            }
            if (mainPoint.y > point.y - paddingFromMain && mainPoint.y < point.y + paddingFromMain) {
                point.y = mainPoint.y + paddingFromMain;
            }
            this.jFrame.setLocation(point);
        }
        this.jFrame.setVisible(b);
    }

    public void setSize(Dimension d) {
        this.jFrame.setSize(d);
        this.jFrame.setLocationRelativeTo(null);
    }

    public void setTitle(String title) {
        this.jFrame.setTitle(title);
    }

    public void dispose() {
        this.jFrame.dispose();
    }

    @Override
    public Component getComponent() {
        return this.jFrame;
    }
}

