/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.base;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.ConversionEvent;
import com.bmc.ctmconvert.base.DescriptionListener;
import com.bmc.ctmconvert.common.FlowGlobals;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class BaseFooterPanel
extends BaseComponent
implements DescriptionListener {
    private JPanel mainJPanel;
    private JPanel messagePanel;
    private JPanel buttonsPanel;
    private JTextArea textArea;
    private String message;
    private Component messageComponent;
    private List<Component> componentList;
    private List<Component> fromEndComponentList;
    private boolean messageOnTop = true;

    public BaseFooterPanel(String message) {
        this.message = message;
        this.initialize();
    }

    public BaseFooterPanel(ArrayList<Component> comp) {
        if (comp != null) {
            this.componentList = comp;
        }
        this.initialize();
    }

    public BaseFooterPanel(String message, ArrayList<Component> comp) {
        if (comp != null) {
            this.componentList = comp;
        }
        this.message = message;
        this.initialize();
    }

    public BaseFooterPanel(String message, List<Component> leftComp, List<Component> rightComp) {
        if (leftComp != null) {
            this.componentList = leftComp;
        }
        if (rightComp != null) {
            this.fromEndComponentList = rightComp;
        }
        this.message = message;
        this.initialize();
    }

    public BaseFooterPanel(Component messageComponent, List<Component> leftComp, List<Component> rightComp, boolean messageOnTop) {
        if (leftComp != null) {
            this.componentList = leftComp;
        }
        if (rightComp != null) {
            this.fromEndComponentList = rightComp;
        }
        this.messageOnTop = messageOnTop;
        this.messageComponent = messageComponent;
        this.initialize();
    }

    private void initialize() {
        this.mainJPanel = new JPanel();
        this.mainJPanel.setBackground(Color.WHITE);
        this.mainJPanel.setLayout(new BoxLayout(this.mainJPanel, 1));
        if (this.messageOnTop && (this.message != null || this.messageComponent != null)) {
            this.setMessagePanel();
        }
        if (this.componentList != null && !this.componentList.isEmpty() || this.fromEndComponentList != null && !this.fromEndComponentList.isEmpty()) {
            this.setButtonsPanel();
        }
        if (!(this.messageOnTop || this.message == null && this.messageComponent == null)) {
            this.setMessagePanel();
        }
    }

    public void setMessagePanel() {
        this.messagePanel = this.getPanel(this.messageOnTop);
        this.messagePanel.setLayout(new BorderLayout());
        if (this.message != null) {
            this.textArea = new JTextArea(this.message);
            this.textArea.setForeground(FlowGlobals.ConversionBlue);
            this.textArea.setBackground(FlowGlobals.ConversionGray);
            this.textArea.setEditable(false);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.messagePanel.add(this.textArea);
        } else {
            this.messagePanel.add(this.messageComponent);
        }
        this.mainJPanel.add(this.messagePanel);
    }

    private void setButtonsPanel() {
        this.buttonsPanel = this.getPanel(!this.messageOnTop);
        if (this.componentList != null) {
            for (Component butt : this.componentList) {
                this.buttonsPanel.add(butt);
            }
        }
        this.buttonsPanel.add(Box.createHorizontalGlue());
        if (this.fromEndComponentList != null) {
            for (Component butt : this.fromEndComponentList) {
                this.buttonsPanel.add(butt);
            }
        }
        this.mainJPanel.add(this.buttonsPanel);
    }

    private JPanel getPanel(boolean top) {
        JPanel toRet = new JPanel();
        toRet.setLayout(new BoxLayout(toRet, 0));
        toRet.setBackground(FlowGlobals.ConversionGray);
        if (top) {
            toRet.setBorder(BorderFactory.createEmptyBorder(15, 20, 10, 18));
        } else {
            toRet.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, FlowGlobals.ConversionPanelsBorder), BorderFactory.createMatteBorder(1, 0, 0, 0, FlowGlobals.ConversionWhite)), BorderFactory.createEmptyBorder(10, 20, 10, 18)));
        }
        return toRet;
    }

    public void setMessage(String message) {
        if (this.message != null) {
            this.message = message;
            this.textArea.setText(message);
        }
    }

    @Override
    public Component getComponent() {
        return this.mainJPanel;
    }

    @Override
    public void descriptionActionPerformed(ConversionEvent e) {
        if (!e.getValue()) {
            this.setMessage("");
        } else {
            this.setMessage(e.getActionCommand());
        }
    }
}

