/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.api;

import com.bmc.ctmconvert.api.AirflowParametersAPI;
import com.bmc.ctmconvert.api.DatabasesParametersAPI;
import com.bmc.ctmconvert.api.FileTransferParametersAPI;
import com.bmc.ctmconvert.api.FileWatcherParametersAPI;
import com.bmc.ctmconvert.api.InformaticaParametersAPI;
import com.bmc.ctmconvert.api.Os2200ParametersAPI;
import com.bmc.ctmconvert.api.OsParametersAPI;
import com.bmc.ctmconvert.api.SapBWParametersAPI;
import com.bmc.ctmconvert.api.SapR3ParametersAPI;
import com.bmc.ctmconvert.scriptelement.CtmBaseEntity;
import com.bmc.ctmconvert.scriptelement.CtmFolderBaseApi;
import com.bmc.ctmconvert.scriptelement.CtmJob;

public class GeneralAPI {
    private final CtmBaseEntity entity;

    public GeneralAPI(CtmBaseEntity entity) {
        this.entity = entity;
    }

    public String getName() {
        return this.entity.getName();
    }

    public void setName(String name) {
        this.entity.setName(name);
    }

    public OsParametersAPI osParameters() {
        return new OsParametersAPI(this.entity);
    }

    public DatabasesParametersAPI databasesParameters() {
        return new DatabasesParametersAPI(this.entity);
    }

    public void setDescription(String description) {
        this.entity.setDescription(description);
    }

    public String getDescription() {
        return this.entity.getDescription();
    }

    public String getApplication() {
        return this.entity.getAttribute("APPLICATION");
    }

    public void setApplication(String application) {
        this.entity.setApplication(application);
    }

    public String getSubApplication() {
        return this.entity.getAttribute("GROUP");
    }

    public void setSubApplication(String subApplication) {
        this.entity.setSubApplication(subApplication);
    }

    public String getHost() {
        return this.entity.getAttribute("NODEID");
    }

    public void setHost(String hosname) {
        if (!(this.entity instanceof CtmJob)) {
            throw new RuntimeException("The script contains an API call on a folder, but the call is applicable to job only.: setHost()");
        }
        ((CtmJob)this.entity).setHost(hosname);
    }

    public void setRunAs(String runas) {
        this.entity.setRunAs(runas);
    }

    public void setControlMServer(String ctmServer) {
        if (!(this.entity instanceof CtmFolderBaseApi)) {
            throw new RuntimeException("The script contains an API call on a job, but the call is applicable to folder only.: setControlMServer()");
        }
        CtmFolderBaseApi ctmFolder = (CtmFolderBaseApi)this.entity;
        ctmFolder.setControlMServer(ctmServer);
    }

    public void setOrderMethod(String orderMethod) {
        if (!(this.entity instanceof CtmFolderBaseApi)) {
            throw new RuntimeException("The script contains an API call on a job, but the call is applicable to folder only.: setOrderMethod()");
        }
        CtmFolderBaseApi ctmFolder = (CtmFolderBaseApi)this.entity;
        ctmFolder.setOrderMethod(orderMethod);
    }

    public void addLocalVariable(String name, String value) {
        this.entity.setVariable(this.fullLocalVariableName(name), value);
    }

    private String fullLocalVariableName(String name) {
        return "%%" + name;
    }

    public void addGlobalVariable(String name, String value) {
        this.entity.setVariable(this.fullGlobalVariableName(name), value);
    }

    public void addSMARTFolderVariable(String name, String value) {
        this.entity.setVariable(this.fullSmartFolderVariableName(name), value);
    }

    private String fullSmartFolderVariableName(String name) {
        return "%%\\\\" + name;
    }

    public void addNamedPoolVariable(String poolName, String variableName, String value) {
        this.entity.setVariable(this.fullNamedPoolVariableName(poolName, variableName), value);
    }

    private String fullNamedPoolVariableName(String poolName, String variableName) {
        return "%%\\\\" + poolName + "\\" + variableName;
    }

    public void removeLocalVariable(String variableName) {
        this.entity.removeVariable(this.fullLocalVariableName(variableName));
    }

    public void removeGlobalVariable(String variableName) {
        this.entity.removeVariable(this.fullGlobalVariableName(variableName));
    }

    public void removeSMARTFolderVariable(String variableName) {
        this.entity.removeVariable(this.fullSmartFolderVariableName(variableName));
    }

    public void removeNamedPoolVariable(String poolName, String variableName) {
        this.entity.removeVariable(this.fullNamedPoolVariableName(poolName, variableName));
    }

    public String getLocalVariableValue(String name) {
        return this.entity.getVariableByName(this.fullLocalVariableName(name));
    }

    public String getGlobalVariableValue(String name) {
        return this.entity.getVariableByName(this.fullGlobalVariableName(name));
    }

    public String getSMARTFolderVariableValue(String name) {
        return this.entity.getVariableByName(this.fullSmartFolderVariableName(name));
    }

    public String getNamedPoolVariableValue(String poolName, String variableName) {
        return this.entity.getVariableByName(this.fullNamedPoolVariableName(poolName, variableName));
    }

    public void enableRunAsDummy() {
        if (this.isDummyJob(this.entity)) {
            return;
        }
        if ("OS".equals(this.entity.getAttribute("APPL_TYPE"))) {
            this.entity.setVariable("%%$BMCWAIORIGTYPE", this.entity.getAttribute("TASKTYPE"));
        }
        if (!(this.entity instanceof CtmJob)) {
            throw new RuntimeException("The script contains an API call on a folder, but the call is applicable to job only.: enableRunAsDummy()");
        }
        ((CtmJob)this.entity).setTaskType("Dummy");
    }

    public void disableRunAsDummy() {
        if (this.entity.general().hasLocalVariable("%%$BMCWAIORIGTYPE".substring(2)) && this.entity instanceof CtmJob) {
            ((CtmJob)this.entity).setTaskType(this.entity.general().getLocalVariableValue("%%$BMCWAIORIGTYPE".substring(2)));
        } else if (!"OS".equals(this.entity.getAttribute("APPL_TYPE")) && this.entity instanceof CtmJob) {
            ((CtmJob)this.entity).setTaskType("Job");
        } else if (!(this.entity instanceof CtmJob)) {
            throw new RuntimeException("The script contains an API call on a folder, but the call is applicable to job only.: disableRunAsDummy()");
        }
        this.entity.removeVariable("%%$BMCWAIORIGTYPE");
    }

    private boolean isDummyJob(CtmBaseEntity entity) {
        return "Dummy".equals(entity.getAttribute("TASKTYPE"));
    }

    public boolean isDummyJob() {
        return this.isDummyJob(this.entity);
    }

    public boolean hasLocalVariable(String variableName) {
        return this.hasVariable(this.fullLocalVariableName(variableName));
    }

    public boolean hasGlobalVariable(String variableName) {
        return this.hasVariable(this.fullGlobalVariableName(variableName));
    }

    private String fullGlobalVariableName(String variableName) {
        return "%%\\" + variableName;
    }

    public boolean hasSMARTFolderVariable(String name) {
        return this.hasVariable(this.fullSmartFolderVariableName(name));
    }

    public boolean hasNamedPoolVariable(String poolName, String variableName) {
        return this.hasVariable(this.fullNamedPoolVariableName(poolName, variableName));
    }

    private boolean hasVariable(String varname) {
        return this.entity.getVariables().stream().anyMatch(variable -> variable.getName().equalsIgnoreCase(varname));
    }

    public InformaticaParametersAPI informaticaParameters() {
        return new InformaticaParametersAPI(this.entity);
    }

    public FileTransferParametersAPI fileTransferParameters() {
        return new FileTransferParametersAPI(this.entity);
    }

    public FileWatcherParametersAPI fileWatcherParameters() {
        return new FileWatcherParametersAPI(this.entity);
    }

    public SapR3ParametersAPI sapR3Parameters() {
        return new SapR3ParametersAPI(this.entity);
    }

    public SapBWParametersAPI sapBWParameters() {
        return new SapBWParametersAPI(this.entity);
    }

    public AirflowParametersAPI airflowParameters() {
        return new AirflowParametersAPI(this.entity);
    }

    public Os2200ParametersAPI os2200Parameters() {
        return new Os2200ParametersAPI(this.entity);
    }
}

