/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.BaseFieldValidator;
import com.bmc.ctmconvert.base.BaseImagePanel;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.ValidityListener;
import com.bmc.ctmconvert.base.list.BaseDetailedList;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.flowpanels.DataImportResult;
import com.bmc.ctmconvert.gui.flowpanels.FlowPanel;
import com.bmc.ctmconvert.gui.flowpanels.NewProjectDialog;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ProjectsPanel
extends FlowPanel {
    private static ProjectsPanel instance;
    private final BaseButton newProjectButton;
    private final BaseNavigationPanel navigationPanel;
    private final BaseDetailedList myProjectsList;
    private final BaseDetailedList demoProjectsList;
    private final BaseTabbedPane projectsTabs;
    private final MouseListener listsListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent e) {
            ProjectsPanel.this.navigationPanel.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
        }
    };
    private BaseDialog newProject;

    public static ProjectsPanel instance() {
        if (instance == null) {
            instance = new ProjectsPanel();
        } else {
            instance.updateData();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private ProjectsPanel() {
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel("Projects"));
        this.baseContentPanel.setScrollable(false);
        this.setImagePanel(new BaseImagePanel(((Object)((Object)this)).getClass().getResource(FlowGlobals.SIDE_IMAGE_2_PATH)));
        this.navigationPanel = new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.QUIT});
        this.setNavigationPanel(this.navigationPanel);
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(30, 10, 10, 10));
        JPanel buttonPane = new JPanel(new FlowLayout());
        this.newProjectButton = ButtonFactory.createButton((ButtonFactory.ButtonType)ButtonFactory.ButtonType.NEW_PROJECT, e -> this.viewNewProjectDialog());
        buttonPane.add((Component)this.newProjectButton);
        content.add((Component)buttonPane, "East");
        JPanel tabsPanel = new JPanel(new BorderLayout());
        tabsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 30));
        this.projectsTabs = new BaseTabbedPane();
        ArrayList<Properties> myProjectsProperties = new ArrayList<Properties>();
        ArrayList<Properties> demoProjectsProperties = new ArrayList<Properties>();
        List projects = ConversionEntitiesService.getProjectsDetailsList();
        for (Properties prop : projects) {
            if (ConversionEntitiesService.isDemoProject((String)prop.getProperty("NAME"))) {
                demoProjectsProperties.add(prop);
                continue;
            }
            myProjectsProperties.add(prop);
        }
        LinkedHashMap<String, String> detailsTitles = new LinkedHashMap<String, String>();
        detailsTitles.put("VENDOR_FULL_NAME", TextManager.instance().get("LIST_DETAILS_TITLE_VENDOR"));
        detailsTitles.put("DATE", TextManager.instance().get("LIST_DETAILS_TITLE_DATE_CREATED"));
        detailsTitles.put("DESCRIPTION", TextManager.instance().get("LIST_DETAILS_TITLE_DESCRIPTION"));
        Properties settings = new Properties();
        settings.setProperty("SORT_BY", "NAME");
        settings.put("DETAILS_TITLES", detailsTitles);
        this.myProjectsList = new BaseDetailedList(myProjectsProperties, settings, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.VENDORS_LIST));
        this.myProjectsList.setBorder(null);
        this.myProjectsList.disableValidityLook(true);
        this.myProjectsList.addMouseListener(this.listsListener);
        this.myProjectsList.setDeleteAction((Action)new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String projectName = e.getActionCommand();
                GlobalFunctions.deleteDir((File)new File(ConversionEntitiesService.getProjectDirectory((String)projectName)));
                DataImportResult.destroy(projectName);
                ConversionEntitiesService.unregisterProject((String)projectName);
            }
        });
        this.projectsTabs.addTab("Existing Projects", this.myProjectsList.getComponent());
        Properties demoSettings = new Properties();
        demoSettings.setProperty("SORT_BY", "NAME");
        demoSettings.setProperty("DELETE_ITEM_ENABLED", "N");
        demoSettings.put("DETAILS_TITLES", detailsTitles);
        this.demoProjectsList = new BaseDetailedList(demoProjectsProperties, demoSettings, new BaseFieldValidator(BaseFieldValidator.VALIDATOR_TYPE.VENDORS_LIST));
        this.demoProjectsList.setBorder(null);
        this.demoProjectsList.disableValidityLook(true);
        this.demoProjectsList.addMouseListener(this.listsListener);
        this.projectsTabs.addTab("Demo Projects", this.demoProjectsList.getComponent());
        tabsPanel.add(this.projectsTabs.getComponent());
        content.add((Component)tabsPanel, "Center");
        this.baseContentPanel.setContentPanel((Component)content);
        this.baseContentPanel.addValidityListener((ValidityListener)this);
        this.setContentPanel(this.baseContentPanel);
        if (myProjectsProperties.isEmpty()) {
            this.projectsTabs.setSelectedIndex(1);
        }
    }

    private void viewNewProjectDialog() {
        this.newProject = new BaseDialog((Component)this.newProjectButton, TextManager.instance().get("MAIN_NAVIGATION_CREATE_NEW"));
        final NewProjectDialog content = new NewProjectDialog();
        this.newProject.setContent((BaseComponent)content);
        this.newProject.addNavegationListener((NavegationListener)content);
        content.addNavegationListener(e -> {
            if (e.getActionCommand().equals("Create")) {
                ConversionEntitiesService.setCurrentProjectName((String)content.getName());
                Properties projectData = new Properties();
                projectData.setProperty("NAME", content.getName());
                projectData.setProperty("DESCRIPTION", content.getDescription());
                projectData.setProperty("VENDOR", content.getVendor());
                projectData.setProperty("VENDOR_FULL_NAME", content.getVendorFullName());
                projectData.setProperty("DATE", GlobalFunctions.getCurrentDateByFormat((String)"dd-MM-yyyy HH:mm"));
                projectData.setProperty("WRITABLE", "Y");
                projectData.setProperty("IMPORT_COMPLETE", "N");
                ConversionEntitiesService.registerNewProject((Properties)projectData);
                GlobalFunctions.createDatasourceDirectory((Properties)projectData);
                ConversionEntitiesService.saveCurrentProjectDetails();
                Params.instance().setIsZOS(VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).isZOS());
                this.fireNavegationEvent(TextManager.instance().get("MAIN_NAVIGATION_NEXT_STR"));
                this.newProject.dispose();
            } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
                this.newProject.dispose();
            } else {
                this.fireNavegationEvent(e.getActionCommand());
            }
        });
        this.newProject.addWindowListener((WindowListener)new WindowAdapter(this){

            @Override
            public void windowOpened(WindowEvent e) {
                content.setFocusComponent();
            }
        });
        this.newProject.setVisible(true);
    }

    @Override
    public boolean performNextOperation() {
        if (Params.instance().getProjectProperties() == null) {
            Properties selected = (this.projectsTabs.getSelectedIndex() == 0 ? this.myProjectsList : this.demoProjectsList).getSelectedItemProperties();
            ConversionEntitiesService.setCurrentProjectName((String)selected.getProperty("NAME"));
            if (Params.instance().isValidationProject()) {
                ConversionEntitiesService.setCurrentConversionName((String)selected.getProperty("NAME"));
            }
            Params.instance().setIsZOS(VendorDataManager.instance().getVendorData(Params.instance().getVendorName()).isZOS());
        }
        return Params.instance().getProjectProperties() != null;
    }

    @Override
    public boolean performPrevOperation() {
        return true;
    }

    @Override
    public boolean updateData() {
        ConversionEntitiesService.setCurrentProjectName((String)"");
        ArrayList<Properties> data = new ArrayList<Properties>();
        for (Properties prop : ConversionEntitiesService.getProjectsDetailsList()) {
            if (!prop.getProperty("WRITABLE").equals("Y")) continue;
            data.add(prop);
        }
        this.myProjectsList.setData(data);
        this.myProjectsList.addMouseListener(this.listsListener);
        this.myProjectsList.setSelectedIndex(null);
        this.demoProjectsList.setSelectedIndex(null);
        return true;
    }

    @Override
    public FlowGlobals.FlowPanels getPanelType() {
        return FlowGlobals.FlowPanels.PROJECTS;
    }

    @Override
    public String getHelpTitle() {
        return this.newProject != null && this.newProject.getComponent().isVisible() ? "NEW_PROJECT_DIALOG" : "PROJECTS_PANEL";
    }
}

