/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.GenerateScripts;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.base.BaseFilteredTree;
import com.bmc.ctmconvert.base.BaseFooterPanel;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.base.BaseNavigationPanel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseReportRenderer;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.BaseTitlePanel;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.base.DescriptionListener;
import com.bmc.ctmconvert.base.NavegationListener;
import com.bmc.ctmconvert.base.SpinnerCellEditor;
import com.bmc.ctmconvert.base.table.BaseExtendedTable;
import com.bmc.ctmconvert.base.table.BaseFilterableTable;
import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.common.DescriptionManager;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.gui.flow.ConversionReportManager;
import com.bmc.ctmconvert.gui.flow.FlowManager;
import com.bmc.ctmconvert.gui.report.FullReportPanel;
import com.bmc.ctmconvert.gui.report.TopPanelModel;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;

public class PostConversion
extends BaseDialog {
    public static final int MAX_RESOURCE_QUANTITY_COLUMN = 3;
    private BaseTableModel QRModel;
    private BaseTableModel GVModel;
    private BaseTableModel UDModel;
    private final Map<Object, Object> mapGenerateScriptQR = new HashMap<Object, Object>();
    private final Map<Object, Object> mapGenerateScriptGV = new HashMap<Object, Object>();
    private final Map<Object, Object> mapGenerateScriptUD = new HashMap<Object, Object>();
    private Map<String, String> mapGenerateScriptAFT = new HashMap<String, String>();
    private Map<String, String> mapGenerateScriptDB = new HashMap<String, String>();
    private Map<String, Set<String>> mapGenerateScriptNG = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
    private BaseTabbedPane postConversionTabs;
    protected BaseContentPanel baseContentPanel;
    protected BasePanel basePanel;
    private JTable QRtable;
    private boolean changed;

    public PostConversion() {
        super(TextManager.instance().get("POST_CONVERSION_ACTIONS"));
        super.setDefaultCloseOperation(0);
        this.changed = false;
        this.baseContentPanel = new BaseContentPanel(new BaseTitlePanel(TextManager.instance().get("POST_CONVERSION_ACTIONS")), new BaseFooterPanel(""));
        this.basePanel = new BasePanel();
        this.basePanel.setNavigationPanel(new BaseNavigationPanel(new ButtonFactory.ButtonType[]{ButtonFactory.ButtonType.GENERATE, ButtonFactory.ButtonType.CLOSE}));
        this.addNavegationListener((NavegationListener)this.basePanel);
        this.basePanel.addNavegationListener(e -> {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CANCEL_STR")) || actionCommand.equals(TextManager.instance().get("MAIN_NAVIGATION_CLOSE_STR"))) {
                boolean dispose = true;
                if (this.changed) {
                    dispose = BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("POST_CONVERSION_ACTIONS"), (String)String.format(TextManager.instance().get("CLOSING_MESSAGE_YES_OR_NO_BODY"), "\n"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.CONFIRM_MESSAGE);
                }
                if (dispose) {
                    this.dispose();
                }
            } else if (actionCommand.equals(TextManager.instance().get("BUTTON_TEXT_GENERATE_SCRIPT"))) {
                String name = this.postConversionTabs.getComponent(this.postConversionTabs.getSelectedIndex()).getName();
                Path postConversionPath = Paths.get(ConversionEntitiesService.getCurrentConversionPostDirectory(), new String[0]);
                boolean generated = false;
                if (name != null && name.equalsIgnoreCase("QR")) {
                    generated = GenerateScripts.generateQRScript(this.getModelData("QR"));
                } else if (name != null && name.equalsIgnoreCase("GLOBALVAR")) {
                    generated = GenerateScripts.generateGVScript(this.getModelData("GLOBALVAR"));
                } else if (name != null && name.equalsIgnoreCase("User Daily")) {
                    generated = GenerateScripts.generateUDScript(this.getModelData("User Daily"));
                } else if (name != null && name.equalsIgnoreCase("NODEGRP")) {
                    generated = GenerateScripts.generateNGScript(this.mapGenerateScriptNG, (Path)postConversionPath);
                } else if (name != null && name.equalsIgnoreCase("AFTACC")) {
                    generated = GenerateScripts.generateCPAFTAccountScript(this.mapGenerateScriptAFT, this.mapGenerateScriptNG);
                } else if (name != null && name.equalsIgnoreCase("DATABASEACC")) {
                    generated = GenerateScripts.generateCPDataBaseScript(this.mapGenerateScriptDB, this.mapGenerateScriptNG);
                }
                if (generated) {
                    String conversionDirectoryPath = ConversionEntitiesService.getCurrentConversionPostDirectory();
                    BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("POST_CONVERSION_ACTIONS"), (String)(String.format(TextManager.instance().get("SUCCESS_GENERATE_MESSAGE_BODY"), "\n") + "\n" + conversionDirectoryPath), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.INFORMATION_MESSAGE);
                } else {
                    BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("POST_CONVERSION_ACTIONS"), (String)String.format(TextManager.instance().get("FAIL_GENERATE_MESSAGE_BODY"), "\n"), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.ERROR_MESSAGE);
                }
            } else if (e.getActionCommand().equals(TextManager.instance().get("MAIN_NAVIGATION_HELP_STR"))) {
                DescriptionManager.instance().showDescriptionDialog("POST_CONVERSION_SCRIPTS");
            } else {
                FlowManager.instance().navegationActionPerformed(e);
            }
        });
        JPanel content = new JPanel(new BorderLayout());
        content.setBackground(FlowGlobals.ConversionWhite);
        content.setPreferredSize(new Dimension(700, 500));
        this.postConversionTabs = new BaseTabbedPane(BaseTabbedPane.TOP);
        this.postConversionTabs.addDescriptionListener((DescriptionListener)this.baseContentPanel.getBaseFooterPanel());
        String conversionDirectoryPath = ConversionEntitiesService.getCurrentConversionPostDirectory();
        String QR_instructions = String.format(TextManager.instance().get("GENERATE_QR_SCRIPT"), "\n", conversionDirectoryPath);
        this.postConversionTabs.addTab(TextManager.instance().get("QUANTITATIVE_RESOURCES"), QR_instructions, this.getTab("QR"));
        String GV_instructions = String.format(TextManager.instance().get("GENERATE_GV_SCRIPT"), "\n", conversionDirectoryPath);
        this.postConversionTabs.addTab(TextManager.instance().get("GLOBAL_VARIABLES"), GV_instructions, this.getTab("GLOBALVAR"));
        String UD_instructions = String.format(TextManager.instance().get("GENERATE_UD_SCRIPT"), "\n", conversionDirectoryPath);
        this.postConversionTabs.addTab("User Daily", UD_instructions, this.getTab("User Daily"));
        String AFT_instructions = String.format(TextManager.instance().get("GENERATE_AFT_SCRIPT"), conversionDirectoryPath, conversionDirectoryPath + Globs.POST_CONVERSION_AFT_DIR_NAME, "AFT_ACCOUNTS_Script_Windows.bat", "AFT_ACCOUNTS_Script_Unix.sh");
        this.postConversionTabs.addTab(TextManager.instance().get("AFT_ACCOUNTS"), AFT_instructions, this.getTab("AFTACC"));
        String DB_instructions = String.format(TextManager.instance().get("GENERATE_DB_SCRIPT"), conversionDirectoryPath, conversionDirectoryPath + Globs.POST_CONVERSION_DATABASE_DIR_NAME, "DATABASE_CONNECTION_PROFILE_Script_Windows.bat", "DATABASE_CONNECTION_PROFILE_Script_Unix.sh");
        this.postConversionTabs.addTab(TextManager.instance().get("DATABASE_CONNECTION_PROFILE"), DB_instructions, this.getTab("DATABASEACC"));
        String NG_instructions = String.format(TextManager.instance().get("GENERATE_NG_SCRIPT"), "\n", conversionDirectoryPath);
        this.postConversionTabs.addTab(TextManager.instance().get("NODE_GROUPS"), NG_instructions, this.getNGTab());
        content.add(this.postConversionTabs.getComponent(), "Center");
        this.baseContentPanel.setContentPanel((Component)content);
        this.basePanel.setContentPanel(this.baseContentPanel);
        this.setContent((BaseComponent)this.basePanel);
    }

    private Component createDBTable() {
        int DBrowLength = 3;
        String[] columnNames = this.getTableTitles("DATABASEACC", DBrowLength);
        Object[][] data = this.getDBTableDataContent(DBrowLength);
        if (data == null || data.length == 0) {
            return null;
        }
        BaseTableModel DBModel = new BaseTableModel(data, columnNames);
        DBModel.addTableModelListener(e -> {
            this.changed = true;
        });
        return this.makeFilteredTable(this.getJTable(DBModel, DBrowLength - 1));
    }

    private Object[][] getDBTableDataContent(int dBrowLength) {
        FullReportPanel conversionR = ConversionReportManager.instance().getConversionReport();
        TopPanelModel dtm = conversionR.getTopPanelModel("DATABASEACC");
        if (dtm == null) {
            return null;
        }
        this.mapGenerateScriptDB = this.getParamMap(dtm);
        int nRow = ((DefaultTableModel)dtm).getRowCount() - 1;
        Object[][] tableData = new String[nRow][dBrowLength];
        for (int i = 0; i < nRow; ++i) {
            tableData[i][0] = ((DefaultTableModel)dtm).getValueAt(i, 0);
            tableData[i][1] = ((DefaultTableModel)dtm).getValueAt(i, 1);
            tableData[i][2] = ((DefaultTableModel)dtm).getValueAt(i, 2);
        }
        return tableData;
    }

    private Map<Object, Object> getModelData(String type) {
        if (type.equalsIgnoreCase("QR")) {
            this.mapGenerateScriptQR.clear();
            for (int i = 0; i < this.QRModel.getRowCount(); ++i) {
                this.mapGenerateScriptQR.put(this.QRModel.getValueAt(i, 1), this.QRModel.getValueAt(i, 3));
            }
            return this.mapGenerateScriptQR;
        }
        if (type.equalsIgnoreCase("GLOBALVAR")) {
            this.mapGenerateScriptGV.clear();
            for (int i = 0; i < this.GVModel.getRowCount(); ++i) {
                Object variableValue = this.GVModel.getValueAt(i, 2);
                if (variableValue == null || ((String)variableValue).equalsIgnoreCase("")) continue;
                Object variableName = this.GVModel.getValueAt(i, 1);
                this.mapGenerateScriptGV.put(variableName, variableValue);
            }
            return this.mapGenerateScriptGV;
        }
        if (type.equalsIgnoreCase("User Daily")) {
            this.mapGenerateScriptUD.clear();
            for (int i = 0; i < this.UDModel.getRowCount(); ++i) {
                Object variableValue = this.UDModel.getValueAt(i, 2);
                if (variableValue == null || ((String)variableValue).equalsIgnoreCase("")) continue;
                Object variableName = this.UDModel.getValueAt(i, 1);
                this.mapGenerateScriptUD.put(variableName, variableValue);
            }
            return this.mapGenerateScriptUD;
        }
        return null;
    }

    private String[] getTableTitles(String type, int rowLength) {
        String[] titleRow = new String[rowLength];
        titleRow[0] = "Number";
        if (type.equalsIgnoreCase("QR")) {
            titleRow[1] = Globs.ACTENTTYPE_QR_DESC + " " + TextManager.instance().get("CONVERSION_REPORT_COLUMN_NAME");
            titleRow[2] = TextManager.instance().get("CONVERSION_REPORT_COLUMN_COUNT");
            titleRow[3] = TextManager.instance().get("CONVERSION_REPORT_COLUMN_MAX_QUANTITY");
            titleRow[4] = TextManager.instance().get("CONVERSION_REPORT_COLUMN_TOTAL_QUANTITY");
        } else if (type.equalsIgnoreCase("GLOBALVAR")) {
            titleRow[1] = Globs.ACTENTTYPE_GLOBAL_AUTOEDIT_DESC + " name";
            titleRow[2] = "Value";
        } else if (type.equalsIgnoreCase("User Daily")) {
            titleRow[1] = "User Daily Input cards for MF name";
            titleRow[2] = "Number of included folders";
        } else if (type.equalsIgnoreCase("AFTACC")) {
            titleRow[0] = "Seq";
            titleRow[1] = "MFT Account name";
            titleRow[2] = "Affected Entities";
        } else if (type.equalsIgnoreCase("DATABASEACC")) {
            titleRow[0] = "Seq";
            titleRow[1] = "Database Connection Profile name";
            titleRow[2] = "Affected Entities";
        }
        return titleRow;
    }

    private Object[][] getGVTableDataContent(int col) {
        FullReportPanel conversionR = ConversionReportManager.instance().getConversionReport();
        TopPanelModel dtm = conversionR.getTopPanelModel("GLOBALVAR");
        if (dtm == null) {
            return new Object[0][];
        }
        int nRow = ((DefaultTableModel)dtm).getRowCount() - 1;
        Object[][] tableData = new String[nRow][col];
        for (int i = 0; i < nRow; ++i) {
            tableData[i][0] = ((DefaultTableModel)dtm).getValueAt(i, 0);
            tableData[i][1] = ((DefaultTableModel)dtm).getValueAt(i, 1);
            tableData[i][2] = ((DefaultTableModel)dtm).getValueAt(i, 3);
        }
        return tableData;
    }

    private Object[][] getUDTableDataContent(int col) {
        FullReportPanel conversionR = ConversionReportManager.instance().getConversionReport();
        TopPanelModel dtm = conversionR.getTopPanelModel("User Daily");
        if (dtm == null) {
            return new Object[0][];
        }
        int nRow = ((DefaultTableModel)dtm).getRowCount() - 1;
        Object[][] tableData = new String[nRow][col];
        for (int i = 0; i < nRow; ++i) {
            tableData[i][0] = ((DefaultTableModel)dtm).getValueAt(i, 0);
            tableData[i][1] = ((DefaultTableModel)dtm).getValueAt(i, 1);
            tableData[i][2] = ((DefaultTableModel)dtm).getValueAt(i, 2);
        }
        return tableData;
    }

    private Map<String, String> getParamMap(DefaultTableModel dtm) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        int nRow = dtm.getRowCount() - 1;
        int nCol = dtm.getColumnCount();
        for (int i = 0; i < nRow; ++i) {
            String keyName = (String)dtm.getValueAt(i, 1);
            String params = (String)dtm.getValueAt(i, nCol - 1);
            paramMap.put(keyName, params);
        }
        return paramMap;
    }

    private Object[][] getQRTableDataContent(int col) {
        FullReportPanel conversionR = ConversionReportManager.instance().getConversionReport();
        TopPanelModel dtm = conversionR.getTopPanelModel("QR");
        if (dtm == null) {
            return new Object[0][];
        }
        int nRow = ((DefaultTableModel)dtm).getRowCount() - 1;
        Object[][] tableData = new Object[nRow][col];
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < col; ++j) {
                String value = (String)((DefaultTableModel)dtm).getValueAt(i, j);
                tableData[i][j] = j == 3 ? Integer.valueOf(value == null || value.isEmpty() ? "1" : value) : (value == null ? "" : value);
            }
        }
        return tableData;
    }

    private void buildNodeGroupData() {
        String conversionPath = ConversionEntitiesService.getCurrentConversionDirectory();
        String actionsReportPath = conversionPath + Globs.DIRSEP + "Actions.csv";
        TreeMap<String, Set<String>> nodeGroups = new TreeMap<String, Set<String>>(String.CASE_INSENSITIVE_ORDER);
        try (CsvReader actionsReport = new CsvReader(actionsReportPath);){
            actionsReport.readHeaders();
            while (actionsReport.readRecord()) {
                String actionType = actionsReport.get("ACTENTTYPE");
                if (!actionType.equalsIgnoreCase("NODEGRP")) continue;
                String nodeGroupName = actionsReport.get("ACTENTNAME");
                String[] nodesArray = actionsReport.get("ACTNODES").split(";");
                TreeSet<String> nodes = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                nodes.addAll(Arrays.asList(nodesArray));
                nodeGroups.putIfAbsent(nodeGroupName, nodes);
            }
        }
        catch (IOException e) {
            ConversionLogger.getLogger().info(e.getMessage());
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
        this.mapGenerateScriptNG = nodeGroups;
    }

    private JTable getJTable(BaseTableModel model, final int columnNumber) {
        return new JTable((TableModel)model){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == columnNumber;
            }

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int Index_row, int Index_col) {
                Component component = super.prepareRenderer(renderer, Index_row, Index_col);
                if (PostConversion.this.QRtable.isEnabled()) {
                    component.setForeground(FlowGlobals.ConversionBlack);
                } else {
                    component.setForeground(FlowGlobals.ConversionDisableColor);
                }
                if (this.isCellSelected(Index_row, Index_col) && PostConversion.this.QRtable.isEnabled()) {
                    component.setBackground(new Color(8832748));
                    component.setForeground(FlowGlobals.ConversionWhite);
                } else if (Index_row % 2 == 0) {
                    component.setBackground(new Color(0xEBEBEB));
                } else {
                    component.setBackground(FlowGlobals.ConversionWhite);
                }
                return component;
            }
        };
    }

    private Component createQRTable() {
        int QRrowLength = 5;
        String[] columnNames = this.getTableTitles("QR", QRrowLength);
        Object[][] data = this.getQRTableDataContent(QRrowLength);
        this.QRModel = new BaseTableModel(data, columnNames);
        this.QRModel.addTableModelListener(e -> {
            this.changed = true;
            this.baseContentPanel.setValid(this.QRModel.getRowCount() > 1);
        });
        this.QRtable = this.getJTable(this.QRModel, QRrowLength - 1);
        if (data == null || data.length == 0) {
            return null;
        }
        TableColumn col = this.QRtable.getColumnModel().getColumn(3);
        col.setCellEditor((TableCellEditor)new SpinnerCellEditor(1, 1, 9999, 1));
        return this.makeFilteredTable(this.QRtable);
    }

    private Component createGVTable() {
        int GVrowLength = 3;
        String[] columnNames = this.getTableTitles("GLOBALVAR", GVrowLength);
        Object[][] data = this.getGVTableDataContent(GVrowLength);
        this.GVModel = new BaseTableModel(data, columnNames);
        this.GVModel.addTableModelListener(e -> {
            this.changed = true;
        });
        if (data == null || data.length == 0) {
            return null;
        }
        return this.makeFilteredTable(this.getJTable(this.GVModel, GVrowLength - 1));
    }

    private Component createUDTable() {
        int UDrowLength = 3;
        String[] columnNames = this.getTableTitles("User Daily", UDrowLength);
        Object[][] data = this.getUDTableDataContent(UDrowLength);
        this.UDModel = new BaseTableModel(data, columnNames);
        this.UDModel.addTableModelListener(e -> {
            this.changed = true;
        });
        if (data == null || data.length == 0) {
            return null;
        }
        return this.makeFilteredTable(this.getJTable(this.UDModel, UDrowLength - 1));
    }

    private DefaultMutableTreeNode buildNodeGroupTree() {
        this.buildNodeGroupData();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(TextManager.instance().get("NODE_GROUPS"));
        for (String key : this.mapGenerateScriptNG.keySet()) {
            DefaultMutableTreeNode nodeLevel1 = new DefaultMutableTreeNode(key);
            for (String value : this.mapGenerateScriptNG.get(key)) {
                DefaultMutableTreeNode nodeLevel2 = new DefaultMutableTreeNode(value);
                nodeLevel1.add(nodeLevel2);
            }
            root.add(nodeLevel1);
        }
        return root;
    }

    private Component getTab(String type) {
        Component table;
        switch (type) {
            case "QR": {
                Component component = this.createQRTable();
                break;
            }
            case "GLOBALVAR": {
                Component component = this.createGVTable();
                break;
            }
            case "User Daily": {
                Component component = this.createUDTable();
                break;
            }
            case "AFTACC": {
                Component component = this.createAFTTable();
                break;
            }
            case "DATABASEACC": {
                Component component = this.createDBTable();
                break;
            }
            default: {
                Component component = table = null;
            }
        }
        if (table == null) {
            return null;
        }
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.setName(type);
        content.add(table, "Center");
        return content;
    }

    private Component getNGTab() {
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        content.setName("NODEGRP");
        BaseFilteredTree mainTree = new BaseFilteredTree(this.buildNodeGroupTree());
        mainTree.setCellRenderer((BaseReportRenderer)new NodeGroupRenderer());
        content.add(mainTree.getComponent(), "Center");
        return content;
    }

    private Component createAFTTable() {
        int AFTrowLength = 3;
        String[] columnNames = this.getTableTitles("AFTACC", AFTrowLength);
        Object[][] data = this.getAFTTableDataContent(AFTrowLength);
        BaseTableModel aftModel = new BaseTableModel(data, columnNames);
        aftModel.addTableModelListener(e -> {
            this.changed = true;
        });
        if (data == null || data.length == 0) {
            return null;
        }
        return this.makeFilteredTable(this.getJTable(aftModel, AFTrowLength - 1));
    }

    private Component makeFilteredTable(JTable table) {
        BaseFilterableTable baseFilterableTable = new BaseFilterableTable(table);
        baseFilterableTable.setColumnWidth(0, 100);
        return new BaseExtendedTable(baseFilterableTable, null, null).getComponent();
    }

    private Object[][] getAFTTableDataContent(int col) {
        FullReportPanel conversionR = ConversionReportManager.instance().getConversionReport();
        TopPanelModel dtm = conversionR.getTopPanelModel("AFTACC");
        if (dtm == null) {
            return null;
        }
        this.mapGenerateScriptAFT = this.getParamMap(dtm);
        int nRow = ((DefaultTableModel)dtm).getRowCount() - 1;
        Object[][] tableData = new String[nRow][col];
        for (int i = 0; i < nRow; ++i) {
            tableData[i][0] = ((DefaultTableModel)dtm).getValueAt(i, 0);
            tableData[i][1] = ((DefaultTableModel)dtm).getValueAt(i, 1);
            tableData[i][2] = ((DefaultTableModel)dtm).getValueAt(i, 2);
        }
        return tableData;
    }

    static class NodeGroupRenderer
    extends BaseReportRenderer {
        private static final long serialVersionUID = 1L;

        NodeGroupRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (!leaf || ((DefaultMutableTreeNode)value).getLevel() == 0) {
                this.setIcon(new ImageIcon(PostConversion.class.getResource("/img/icon_nodegrp.png")));
            }
            return this;
        }
    }
}

