/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flowpanels;

import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseDialog;
import com.bmc.ctmconvert.common.CompareVersionToS3;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutWindow {
    private static AboutWindow instance;
    private final ThemeConfiguration theme = ThemeConfiguration.get();
    private BaseDialog about = new BaseDialog();

    public static AboutWindow instance() {
        if (instance == null) {
            instance = new AboutWindow();
        } else {
            AboutWindow.instance.about.setVisible(true);
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private AboutWindow() {
        this.about.setSize(new Dimension(500, 335));
        this.about.addNavegationListener(e -> this.about.dispose());
        JPanel container = new JPanel();
        container.setLayout(new BoxLayout(container, 1));
        JPanel imageContainer = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics page) {
                super.paintComponent(page);
                Image img = new ImageIcon(this.getClass().getResource(FlowGlobals.ABOUT_BACKGROUND_ICON_URL)).getImage();
                page.drawImage(img, 0, 0, null);
            }
        };
        imageContainer.setLayout(new BoxLayout(imageContainer, 1));
        imageContainer.add(Box.createRigidArea(new Dimension(0, 120)));
        imageContainer.add(this.getLabelPanel("BMC " + this.theme.getControlmName() + " Conversion Tool", FlowGlobals.FONT_STYLE_ABOUT));
        imageContainer.add(Box.createRigidArea(new Dimension(0, 16)));
        imageContainer.add(this.getLabelPanel("Version " + CompareVersionToS3.getVersionNumber(), FlowGlobals.FONT_STYLE_ABOUT_VERSION));
        this.about.setContent((BaseComponent)new BaseComponentWrapper((Component)imageContainer));
        this.about.setVisible(true);
    }

    private JPanel getLabelPanel(String text, Font font) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.setOpaque(false);
        JLabel textLabel = new JLabel(text);
        textLabel.setFont(font);
        textLabel.setForeground(FlowGlobals.ConversionTitleText);
        panel.add(Box.createRigidArea(new Dimension(23, 0)));
        panel.add(textLabel);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }
}

