/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.gui.flow;

import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.ExternalCommand;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.gui.validation.ValidationProperties;
import com.bmc.ctmconvert.io.FileUtils;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Scanner;

public class ValidationExecuter {
    private ValidationProperties validationProperties;
    private String m_conversionPath;
    private String m_forecastResultFile;
    private String m_forecastOutputFile;
    private String m_forecastWarningsFile;
    private boolean m_isZOS;
    private List<String> errorLines = new ArrayList<String>();
    private static Integer m_currentIndention = 0;
    private Integer m_ForecastErrorCount = 0;
    private Integer m_ForecastWarningCount = 0;

    public ValidationExecuter(ValidationProperties properties) {
        this.validationProperties = properties;
        this.m_conversionPath = ConversionEntitiesService.getCurrentConversionDirectory();
        this.m_forecastResultFile = this.m_conversionPath + Globs.DIRSEP + "CTMForecastResult.csv";
        this.m_forecastOutputFile = this.m_conversionPath + Globs.DIRSEP + "CTMForecastOutput.txt";
        this.m_forecastWarningsFile = this.m_conversionPath + Globs.DIRSEP + "CTMForecastWarnings.xml";
        this.m_isZOS = false;
        if (Params.instance().isZOS()) {
            this.m_isZOS = true;
        }
    }

    public ValidationProperties runFullValidation() {
        boolean exceptionOccurred = false;
        try {
            this.runDraftForecast();
        }
        catch (FileNotFoundException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TITLE_VALIDATION_REPORT"), (String)e.getMessage(), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
            exceptionOccurred = true;
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TITLE_VALIDATION_REPORT"), (String)"File cannot be imported because it is not in the correct format", (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
            exceptionOccurred = true;
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TITLE_VALIDATION_REPORT"), (String)e.getMessage(), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
            exceptionOccurred = true;
        }
        if (!exceptionOccurred) {
            this.saveValidationProperties();
            return this.validationProperties;
        }
        return null;
    }

    private void saveValidationProperties() {
        this.validationProperties.setCtmForecast(this.m_forecastResultFile);
        this.validationProperties.setForecastOutputFile(this.m_forecastOutputFile);
        this.validationProperties.setForecastWarningsFile(this.m_forecastWarningsFile);
        this.validationProperties.saveValidationProperties();
    }

    private void runDraftForecast() throws Exception {
        File warningFile;
        String calendarsFile = this.validationProperties.getCalendarFile();
        if (!GlobalFunctions.isFileExist((String)(Globs.XML_FORECAST_COMMAND_PATH + "runRplanValidator.bat"))) {
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("TITLE_VALIDATION_REPORT"), (String)(TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_THE_FILE") + " runRplanValidator.bat " + TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_WAS_NOT_FOUND")), (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
            return;
        }
        File forecastOutFile = new File(this.m_forecastResultFile);
        if (forecastOutFile.exists()) {
            forecastOutFile.delete();
        }
        if ((warningFile = new File(this.m_forecastWarningsFile)).exists()) {
            warningFile.delete();
        }
        File dir = new File(this.m_conversionPath);
        File[] fileList = dir.listFiles();
        for (int i = 0; i < fileList.length; ++i) {
            String currFileName = fileList[i].getName();
            if (!fileList[i].isFile() || !currFileName.startsWith("draft") && !currFileName.startsWith("draftMF")) continue;
            this.runForecast(fileList[i].getAbsolutePath(), calendarsFile);
        }
        if (this.getForecastWarningCount() > 0) {
            String TempM = String.format(TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_WARNINGS_WAS_FOUND"), "\n", "\n");
            String messageBoxValidationFailed = this.getForecastWarningCount().toString() + " " + TempM;
            BaseMessageDialog.showMessageDialog((String)TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_VALIDATION_WARNINGS"), (String)messageBoxValidationFailed, (BaseMessageDialog.TYPE)BaseMessageDialog.TYPE.WARNING_MESSAGE);
        }
    }

    private void runForecast(String draftFileName, String calendarsFile) throws Exception {
        String forecatInputFile = this.buildForecastInputFile(draftFileName, calendarsFile);
        ExternalCommand extCmd = new ExternalCommand.Builder(new String[]{Globs.XML_FORECAST_COMMAND_RELATIVE_PATH + "runRplanValidator.bat", forecatInputFile}).workingDirectory(Globs.HOME_DIR).redirectOutputToFile(this.m_forecastOutputFile).redirectErrToOut(true).isScript(true).waitFor(true).build();
        extCmd.start();
        this.checkErrorsAndWarnings(this.m_forecastOutputFile);
        if (this.getForecastErrorCount() > 0) {
            Object messageBoxValidationFailed = TextManager.instance().get("VALIDATION_PANEL_FORECAST_FAILED_MESSAGE");
            messageBoxValidationFailed = (String)messageBoxValidationFailed + "\n" + this.getForecastErrorCount().toString() + " " + TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_ERRORS_WERE_FOUND");
            if (!this.errorLines.isEmpty()) {
                messageBoxValidationFailed = (String)messageBoxValidationFailed + " " + TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_LAST") + " " + Integer.toString(this.errorLines.size()) + " " + TextManager.instance().get("VALIDATION_EXEUTER_MSG_DIALOG_LINES_FROM_OUTPUT_BELOW");
                while (!this.errorLines.isEmpty()) {
                    String errorLine = this.errorLines.remove(0);
                    if (errorLine == null) continue;
                    messageBoxValidationFailed = (String)messageBoxValidationFailed + "\n   " + errorLine;
                }
            }
            throw new Exception((String)messageBoxValidationFailed);
        }
    }

    private String buildForecastInputFile(String fileName, String calendarsFile) throws Exception {
        File forecastInFile;
        String jobName;
        String inputFileName = "CTMForecast.xml";
        String forecatInputFile = this.m_conversionPath + inputFileName;
        Integer currYear = Calendar.getInstance().get(1);
        String dataCenterName = this.validationProperties.getCtmName();
        String dataCenterType = Params.instance().isZOS() ? "MVS" : "MPM";
        String dataCenterVer = "700";
        String display = "JOBNAME";
        String firstDayOfWeek = this.validationProperties.getFirstDayOfWeek();
        String appyCalendar = "false";
        File forecastOutFile = new File(calendarsFile);
        if (forecastOutFile.exists()) {
            appyCalendar = "true";
        }
        String filterTable = "*";
        String filterJob = "*";
        String filterMemlib = "*";
        String filterAppl = "*";
        String tableName = this.validationProperties.getFilterTableName();
        if (tableName != null && !tableName.equals(ValidationProperties.valueDefaultAll) && !tableName.equals("")) {
            filterTable = tableName;
        }
        if ((jobName = this.validationProperties.getFilterJobName()) != null && !jobName.equals(ValidationProperties.valueDefaultAll) && !jobName.equals("")) {
            filterJob = jobName;
        }
        String memLib = this.validationProperties.getFilterMemlib();
        if (this.m_isZOS) {
            display = "MEMNAME";
            if (memLib != null && !memLib.equals(ValidationProperties.valueDefaultAll) && !memLib.equals("")) {
                filterMemlib = memLib;
            }
        }
        if ((forecastInFile = new File(forecatInputFile)).exists()) {
            forecastInFile.delete();
        }
        BufferedWriter forecastBW = new BufferedWriter(new FileWriter(forecastInFile, true));
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenElement("CTMRPLN") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenElement("DATA_FILE") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenCloseElement("JOB_DEF_FILE", fileName) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("CALENDAR_DEF_FILE", calendarsFile) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("OUTPUT_DEF_FILE", this.m_forecastResultFile) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("OUTPUT_FORMAT", "CSV") + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("WARNING_FILE", this.m_forecastWarningsFile) + "\n");
        if (FileUtils.getDraftCharset().equals(StandardCharsets.UTF_8)) {
            forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("I18N", "CJK") + "\n");
        }
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("DATA_FILE") + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenElement("PARAMS") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenCloseElement("DISPLAY", display) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("CALENDAR_APPLY", appyCalendar) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("DATE", currYear.toString()) + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("PARAMS") + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenElement("DATA_CENTERS") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenElement("DATA_CENTER") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenCloseElement("NAME", dataCenterName) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("TYPE", dataCenterType) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("VERSION", dataCenterVer) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("FIRST_DAY_OF_WEEK", firstDayOfWeek) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenElement("FILTERS") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenElement("FILTER") + "\n");
        forecastBW.write(this.xmlIndent(1) + this.xmlOpenCloseElement("TABLE", filterTable) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("JOBNAME", filterJob) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("MEMLIB", filterMemlib) + "\n");
        forecastBW.write(this.xmlIndent(0) + this.xmlOpenCloseElement("APPLICATION", filterAppl) + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("FILTER") + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("FILTERS") + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("DATA_CENTER") + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("DATA_CENTERS") + "\n");
        forecastBW.write(this.xmlIndent(-1) + this.xmlCloseElement("CTMRPLN") + "\n");
        forecastBW.close();
        return forecatInputFile.replace(Globs.HOME_DIR + Globs.DIRSEP, "");
    }

    private String xmlIndent(Integer delta) {
        String indentValue = "";
        m_currentIndention = m_currentIndention + delta;
        Integer i = 0;
        while (i < m_currentIndention) {
            indentValue = indentValue.concat("\t");
            Integer n = i;
            i = i + 1;
        }
        return indentValue;
    }

    private String xmlOpenElement(String element) {
        return "<" + element + ">";
    }

    private String xmlCloseElement(String element) {
        return "</" + element + ">";
    }

    private String xmlOpenCloseElement(String element, String value) {
        return this.xmlOpenElement(element) + value + this.xmlCloseElement(element);
    }

    private void setForecastErrorCount(Integer count) {
        this.m_ForecastErrorCount = count;
    }

    private Integer getForecastErrorCount() {
        return this.m_ForecastErrorCount;
    }

    private void setForecastWarningCount(Integer count) {
        this.m_ForecastWarningCount = count;
    }

    private Integer getForecastWarningCount() {
        return this.m_ForecastWarningCount;
    }

    private void checkErrorsAndWarnings(String outputFile) {
        File file = new File(outputFile);
        int errorCount = 0;
        int warningCount = 0;
        Scanner scanner = null;
        this.errorLines.clear();
        try {
            scanner = new Scanner(file);
        }
        catch (FileNotFoundException e) {
            this.errorLines.add("File " + outputFile + " can not be opened");
            this.setForecastErrorCount(1);
            return;
        }
        while (scanner.hasNextLine()) {
            String[] summaryLine;
            String line = scanner.nextLine();
            this.errorLines.add(line);
            if (this.errorLines.size() > 5) {
                this.errorLines.remove(0);
            }
            if (line.matches("a total of: (.*) error(.*) were found") && GlobalFunctions.isNumber((String)(summaryLine = line.split(" "))[3]) && Integer.parseInt(summaryLine[3]) != 0) {
                errorCount = Integer.parseInt(summaryLine[3]);
                break;
            }
            if (!line.matches("a total of: (.*) warning(.*) were found") || !GlobalFunctions.isNumber((String)(summaryLine = line.split(" "))[3]) || Integer.parseInt(summaryLine[3]) == 0) continue;
            warningCount = Integer.parseInt(summaryLine[3]);
        }
        scanner.close();
        this.setForecastErrorCount(this.getForecastErrorCount() + errorCount);
        this.setForecastWarningCount(this.getForecastWarningCount() + warningCount);
    }
}

