/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.conversion_updater;

import com.bmc.ctmconvert.S3Downloader;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.conversion_updater.UpdaterGlobals;
import com.bmc.ctmconvert.services.FilesManager;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.JProgressBar;
import javax.swing.SwingWorker;

public class DownloadUpdateWorker
extends SwingWorker<Boolean, String> {
    private Exception downloadException = null;
    private final JProgressBar progressBar;
    private final FilesManager filesManager;

    public DownloadUpdateWorker(JProgressBar progressBar) {
        this.progressBar = progressBar;
        this.filesManager = new FilesManager();
    }

    @Override
    protected Boolean doInBackground() {
        boolean downloadStats;
        S3Downloader s3Downloader = new S3Downloader();
        Path zipFileDest = Paths.get(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION, new String[0]);
        try (OutputStream zipFileOutStream = Files.newOutputStream(zipFileDest, new OpenOption[0]);){
            downloadStats = s3Downloader.downloadWithProgressPar("https://control-m-conversion.s3.eu-central-1.amazonaws.com/Control-M_Conversions_for_DS/AutomaticUpdate/update.zip", zipFileOutStream, this.progressBar);
            if (!downloadStats) {
                this.downloadException = new IOException("Failed to download package");
            }
        }
        catch (Exception e) {
            this.downloadException = e;
            downloadStats = false;
        }
        return downloadStats;
    }

    @Override
    protected void done() {
        if (this.downloadException != null) {
            Path updateZipPath = Paths.get(UpdaterGlobals.UPDATE_PACKAGE_LOCAL_LOCATION, new String[0]);
            if (Files.exists(updateZipPath, new LinkOption[0])) {
                try {
                    this.filesManager.deleteDirectory(updateZipPath);
                }
                catch (IOException e) {
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
            ExceptionHandler.writeToExceptionFile(this.downloadException);
            BaseMessageDialog.showMessageDialog("Download Failed", this.downloadException.getMessage(), BaseMessageDialog.TYPE.ERROR_MESSAGE);
        }
    }
}

