/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.vendors;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.Index;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.TextColumnType;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2DataTypeProvider;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.H2FunctionProvider;
import org.jetbrains.exposed.sql.vendors.H2Kt;
import org.jetbrains.exposed.sql.vendors.VendorDialect;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J3\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00170\u00152\u0012\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0019\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0014\u0010\u001b\u001a\u00020\u00042\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u001dH\u0016J\r\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001eJ2\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00172\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0016R\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006&"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect;", "Lorg/jetbrains/exposed/sql/vendors/VendorDialect;", "()V", "isMySQLMode", "", "Ljava/lang/Boolean;", "name", "", "getName", "()Ljava/lang/String;", "supportsMultipleGeneratedKeys", "getSupportsMultipleGeneratedKeys", "()Z", "supportsOnlyIdentifiersInGeneratedKeys", "getSupportsOnlyIdentifiersInGeneratedKeys", "createDatabase", "createIndex", "index", "Lorg/jetbrains/exposed/sql/Index;", "dropDatabase", "existingIndices", "", "Lorg/jetbrains/exposed/sql/Table;", "", "tables", "", "([Lorg/jetbrains/exposed/sql/Table;)Ljava/util/Map;", "isAllowedAsColumnDefault", "e", "Lorg/jetbrains/exposed/sql/Expression;", "isMySQLMode$exposed_core", "modifyColumn", "column", "Lorg/jetbrains/exposed/sql/Column;", "nullabilityChanged", "autoIncrementChanged", "defaultChanged", "Companion", "exposed-core"})
public class H2Dialect
extends VendorDialect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Boolean isMySQLMode;
    private final boolean supportsMultipleGeneratedKeys;
    @NotNull
    public static final String dialectName = "h2";

    public H2Dialect() {
        super(dialectName, H2DataTypeProvider.INSTANCE, H2FunctionProvider.INSTANCE);
    }

    public final boolean isMySQLMode$exposed_core() {
        boolean bl;
        Boolean bl2 = this.isMySQLMode;
        if (bl2 == null) {
            Transaction transaction2 = TransactionManager.Companion.currentOrNull();
            if (transaction2 == null) {
                bl = false;
            } else {
                Transaction transaction3 = transaction2;
                boolean bl3 = false;
                boolean bl4 = false;
                Transaction tr = transaction3;
                boolean bl5 = false;
                Boolean bl6 = (Boolean)Transaction.exec$default(tr, "SELECT VALUE FROM INFORMATION_SCHEMA.SETTINGS WHERE NAME = 'MODE'", null, null, (Function1)new Function1<ResultSet, Boolean>(this){
                    final /* synthetic */ H2Dialect this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final boolean invoke(@NotNull ResultSet rs) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                        rs.next();
                        String string = rs.getString("VALUE");
                        if (string == null) {
                            bl = false;
                        } else {
                            boolean bl2;
                            boolean bl3;
                            boolean bl4 = bl3 = StringsKt.equals((String)string, (String)"MySQL", (boolean)true);
                            H2Dialect h2Dialect = this.this$0;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            boolean it = bl4;
                            boolean bl7 = false;
                            H2Dialect.access$setMySQLMode$p(h2Dialect, it);
                            bl = bl2 = bl4;
                        }
                        return bl;
                    }
                }, 6, null);
                bl = bl6 == null ? false : bl6;
            }
        } else {
            bl = bl2;
        }
        return bl;
    }

    @Override
    @NotNull
    public String getName() {
        Transaction transaction2 = TransactionManager.Companion.currentOrNull();
        Boolean bl = transaction2 == null ? null : Boolean.valueOf(H2Kt.access$isMySQLMode(transaction2));
        return Intrinsics.areEqual((Object)bl, (Object)true) ? "h2 (Mysql Mode)" : dialectName;
    }

    @Override
    public boolean getSupportsMultipleGeneratedKeys() {
        return this.supportsMultipleGeneratedKeys;
    }

    @Override
    public boolean getSupportsOnlyIdentifiersInGeneratedKeys() {
        return !H2Kt.access$isMySQLMode(TransactionManager.Companion.current());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Table, List<Index>> existingIndices(Table ... tables) {
        Object object;
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tables, (String)"tables");
        Map<Table, List<Index>> $this$mapValues$iv = super.existingIndices(Arrays.copyOf(tables, tables.length));
        boolean $i$f$mapValues = false;
        Map<Table, List<Index>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$filterNotTo$iv$iv;
            void entry;
            void it$iv$iv;
            object = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Object k = it$iv$iv.getKey();
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = k;
            Map map3 = map2;
            boolean bl2 = false;
            Iterable $this$filterNot$iv = (Iterable)entry.getValue();
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Index it = (Index)element$iv$iv;
                boolean bl3 = false;
                if (StringsKt.startsWith$default((String)it.getIndexName(), (String)"PRIMARY_KEY_", (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv2;
            map3.put(k2, list);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        Map map4 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry$iv : map4.entrySet()) {
            List it = (List)entry$iv.getValue();
            boolean bl4 = false;
            object = it;
            boolean bl5 = false;
            boolean bl6 = !object.isEmpty();
            if (!bl6) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return result$iv;
    }

    @Override
    public boolean isAllowedAsColumnDefault(@NotNull Expression<?> e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        return true;
    }

    @Override
    @NotNull
    public String createIndex(@NotNull Index index) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)index, (String)"index");
            Iterable $this$any$iv = index.getColumns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Column it = (Column)element$iv;
                    boolean bl2 = false;
                    if (!(it.getColumnType() instanceof TextColumnType)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            SQLLogKt.getExposedLogger().warn("Index on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.2.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        if (index.getIndexType() != null) {
            SQLLogKt.getExposedLogger().warn("Index of type " + index.getIndexType() + " on " + index.getTable().getTableName() + " for " + CollectionsKt.joinToString$default((Iterable)index.getColumns(), null, null, null, (int)0, null, (Function1)createIndex.3.INSTANCE, (int)31, null) + " can't be created in H2");
            return "";
        }
        return super.createIndex(index);
    }

    @Override
    @NotNull
    public String createDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"CREATE SCHEMA IF NOT EXISTS ", (Object)DefaultKt.inProperCase(name));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> modifyColumn(@NotNull Column<?> column, boolean nullabilityChanged, boolean autoIncrementChanged, boolean defaultChanged) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Iterable $this$map$iv = super.modifyColumn(column, nullabilityChanged, autoIncrementChanged, defaultChanged);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = StringsKt.replace$default((String)it, (String)"MODIFY COLUMN", (String)"ALTER COLUMN", (boolean)false, (int)4, null);
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public String dropDatabase(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return Intrinsics.stringPlus((String)"DROP SCHEMA IF EXISTS ", (Object)DefaultKt.inProperCase(name));
    }

    public static final /* synthetic */ void access$setMySQLMode$p(H2Dialect $this, Boolean bl) {
        $this.isMySQLMode = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/exposed/sql/vendors/H2Dialect$Companion;", "", "()V", "dialectName", "", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

