/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Column;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.EntityIDColumnType;
import org.jetbrains.exposed.sql.ResultRow;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.statements.BatchDataInconsistentException;
import org.jetbrains.exposed.sql.statements.InsertStatement;
import org.jetbrains.exposed.sql.statements.api.PreparedStatementApi;
import org.jetbrains.exposed.sql.transactions.TransactionManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\b&\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u001fH\u0002J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\r\u0010&\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b'J*\u0010(\u001a\u00020\u001e\"\u0004\b\u0000\u0010)2\f\u0010*\u001a\b\u0012\u0004\u0012\u0002H)0\f2\u0006\u0010+\u001a\u0002H)H\u0096\u0002\u00a2\u0006\u0002\u0010,J\r\u0010-\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b.J4\u0010/\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f002\u0018\u00101\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f00H\u0014J\u0010\u00102\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\fH\u0002R\u0018\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R<\u0010\r\u001a\"\u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\u0002\u0018\u00010\u00028TX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013RH\u0010\u0014\u001a6\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00160\u0015j\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0016`\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001b\u00a8\u00063\u00b2\u0006\u0014\u00104\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u0002X\u008a\u0084\u0002"}, d2={"Lorg/jetbrains/exposed/sql/statements/BaseBatchInsertStatement;", "Lorg/jetbrains/exposed/sql/statements/InsertStatement;", "", "Lorg/jetbrains/exposed/sql/ResultRow;", "table", "Lorg/jetbrains/exposed/sql/Table;", "ignore", "", "shouldReturnGeneratedValues", "(Lorg/jetbrains/exposed/sql/Table;ZZ)V", "allColumnsInDataSet", "", "Lorg/jetbrains/exposed/sql/Column;", "arguments", "Lkotlin/Pair;", "", "getArguments", "()Ljava/util/List;", "setArguments", "(Ljava/util/List;)V", "data", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "getData$exposed_core", "()Ljava/util/ArrayList;", "isAlwaysBatch", "()Z", "getShouldReturnGeneratedValues", "addBatch", "", "", "prepared", "Lorg/jetbrains/exposed/sql/statements/api/PreparedStatementApi;", "transaction", "Lorg/jetbrains/exposed/sql/Transaction;", "sql", "", "removeLastBatch", "removeLastBatch$exposed_core", "set", "S", "column", "value", "(Lorg/jetbrains/exposed/sql/Column;Ljava/lang/Object;)V", "validateLastBatch", "validateLastBatch$exposed_core", "valuesAndDefaults", "", "values", "isDefaultable", "exposed-core", "nullableColumns"})
public abstract class BaseBatchInsertStatement
extends InsertStatement<List<? extends ResultRow>> {
    private final boolean shouldReturnGeneratedValues;
    private final boolean isAlwaysBatch;
    @NotNull
    private final ArrayList<Map<Column<?>, Object>> data;
    @NotNull
    private final Set<Column<?>> allColumnsInDataSet;
    @Nullable
    private List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> arguments;

    public BaseBatchInsertStatement(@NotNull Table table, boolean ignore, boolean shouldReturnGeneratedValues) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        super(table, ignore);
        this.shouldReturnGeneratedValues = shouldReturnGeneratedValues;
        this.isAlwaysBatch = true;
        this.data = new ArrayList();
        boolean bl = false;
        this.allColumnsInDataSet = new LinkedHashSet();
    }

    public /* synthetic */ BaseBatchInsertStatement(Table table, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(table, bl, bl2);
    }

    protected final boolean getShouldReturnGeneratedValues() {
        return this.shouldReturnGeneratedValues;
    }

    @Override
    public boolean isAlwaysBatch() {
        return this.isAlwaysBatch;
    }

    @NotNull
    public final ArrayList<Map<Column<?>, Object>> getData$exposed_core() {
        return this.data;
    }

    private final boolean isDefaultable(Column<?> $this$isDefaultable) {
        return $this$isDefaultable.getColumnType().getNullable() || $this$isDefaultable.getDefaultValueFun() != null;
    }

    @Override
    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (this.data.size() > 1) {
            Map<Column<?>, Object> map = this.data.get(this.data.size() - 2);
            Intrinsics.checkNotNullExpressionValue(map, (String)"data[data.size - 2]");
            boolean bl = false;
            Map<Column<?>, Object> map2 = map;
            boolean bl2 = false;
            if (!map2.containsKey(column) && !this.isDefaultable(column)) {
                throw new BatchDataInconsistentException("Can't set " + value + " for " + TransactionManager.Companion.current().fullIdentity(column) + " because previous insertion can't be defaulted for that column.");
            }
        }
        super.set(column, value);
    }

    public final void addBatch() {
        Collection collection = this.data;
        boolean bl = false;
        if (!collection.isEmpty()) {
            this.validateLastBatch$exposed_core();
            this.data.set(this.data.size() - 1, new LinkedHashMap(this.getValues()));
            this.allColumnsInDataSet.addAll((Collection)this.getValues().keySet());
            this.getValues().clear();
            this.setHasBathedValues(true);
        }
        this.data.add(this.getValues());
        this.setArguments(null);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeLastBatch$exposed_core() {
        void $this$flatMapTo$iv;
        this.data.remove(this.data.size() - 1);
        this.allColumnsInDataSet.clear();
        Iterable iterable = this.data;
        Collection destination$iv = this.allColumnsInDataSet;
        boolean $i$f$flatMapTo = false;
        for (Object element$iv : $this$flatMapTo$iv) {
            Map it = (Map)element$iv;
            boolean bl = false;
            Iterable list$iv = it.keySet();
            CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
        }
        this.getValues().clear();
        this.getValues().putAll((Map)CollectionsKt.last((List)this.data));
        this.setArguments(null);
        this.setHasBathedValues(this.data.size() > 0);
    }

    /*
     * WARNING - void declaration
     */
    public void validateLastBatch$exposed_core() {
        void $this$filterTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        void $this$filterNotTo$iv$iv;
        Transaction tr = TransactionManager.Companion.current();
        Iterable $this$filterNot$iv = SetsKt.minus(this.allColumnsInDataSet, (Iterable)this.getValues().keySet());
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (this.isDefaultable(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List cantBeDefaulted = (List)destination$iv$iv;
        $this$filterNot$iv = cantBeDefaulted;
        $i$f$filterNot = false;
        if (!$this$filterNot$iv.isEmpty()) {
            String columnList2 = CollectionsKt.joinToString$default((Iterable)cantBeDefaulted, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(tr){
                final /* synthetic */ Transaction $tr;
                {
                    this.$tr = $tr;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Column<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$tr.fullIdentity(it);
                }
            }, (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList2 + " don't have client default values. DB defaults don't support in batch inserts");
        }
        Iterable $this$flatMap$iv = this.getTargets();
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Table it = (Table)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getColumns();
            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        Iterable $this$filter$iv = CollectionsKt.minus((Iterable)((List)destination$iv$iv2), (Iterable)this.getValues().keySet());
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Column it = (Column)element$iv$iv;
            boolean bl = false;
            if (!(!this.isDefaultable(it) && !ColumnTypeKt.isAutoInc(it.getColumnType()) && it.getDbDefaultValue$exposed_core() == null && !(it.getColumnType() instanceof EntityIDColumnType))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List requiredInTargets = (List)destination$iv$iv2;
        if (CollectionsKt.any((Iterable)requiredInTargets)) {
            String columnList3 = CollectionsKt.joinToString$default((Iterable)requiredInTargets, null, null, null, (int)0, null, (Function1)new Function1<Column<?>, CharSequence>(tr){
                final /* synthetic */ Transaction $tr;
                {
                    this.$tr = $tr;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull Column<?> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return this.$tr.fullIdentity(it);
                }
            }, (int)31, null);
            throw new BatchDataInconsistentException("Can't add a new batch because columns: " + columnList3 + " don't have default values. DB defaults don't support in batch inserts");
        }
    }

    private final Set<Column<?>> allColumnsInDataSet() {
        Set set;
        Map map = (Map)CollectionsKt.lastOrNull((List)this.data);
        Set set2 = set = map == null ? null : map.keySet();
        if (set == null) {
            throw new BatchDataInconsistentException(Intrinsics.stringPlus((String)"No data provided for inserting into ", (Object)this.getTable().getTableName()));
        }
        return SetsKt.plus(this.allColumnsInDataSet, (Iterable)set);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected List<List<Pair<Column<?>, Object>>> getArguments() {
        List list;
        List list2 = this.arguments;
        if (list2 == null) {
            void $this$mapTo$iv$iv;
            BaseBatchInsertStatement baseBatchInsertStatement = this;
            boolean bl = false;
            boolean bl2 = false;
            BaseBatchInsertStatement $this$_get_arguments__u24lambda_u2d9 = baseBatchInsertStatement;
            boolean bl3 = false;
            Lazy nullableColumns$delegate = LazyKt.lazy((Function0)new Function0<List<? extends Column<?>>>($this$_get_arguments__u24lambda_u2d9){
                final /* synthetic */ BaseBatchInsertStatement $this_run;
                {
                    this.$this_run = $receiver;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<Column<?>> invoke() {
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = BaseBatchInsertStatement.access$allColumnsInDataSet(this.$this_run);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        Column it = (Column)element$iv$iv;
                        boolean bl = false;
                        if (!it.getColumnType().getNullable()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (List)destination$iv$iv;
                }
            });
            Iterable $this$map$iv = $this$_get_arguments__u24lambda_u2d9.getData$exposed_core();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void single;
                Map map = (Map)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Map valuesAndDefaults = TypeIntrinsics.asMutableMap(super.valuesAndDefaults((Map<Column<?>, ? extends Object>)single));
                Iterable $this$associateWith$iv = CollectionsKt.minus((Iterable)BaseBatchInsertStatement._get_arguments_$lambda-9$lambda-4(nullableColumns$delegate), (Iterable)valuesAndDefaults.keySet());
                boolean $i$f$associateWith = false;
                LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
                Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
                boolean $i$f$associateWithTo = false;
                for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                    Column column = (Column)element$iv$iv;
                    Object t = element$iv$iv;
                    Map map2 = result$iv;
                    boolean bl5 = false;
                    Object v = null;
                    map2.put(t, v);
                }
                Map nullableMap = result$iv;
                valuesAndDefaults.putAll(nullableMap);
                Iterable $this$sortedBy$iv = MapsKt.toList((Map)valuesAndDefaults);
                boolean $i$f$sortedBy = false;
                boolean bl6 = false;
                List list3 = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Pair it = (Pair)a;
                        boolean bl2 = false;
                        Comparable comparable = (Column)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Column column = (Column)it.getFirst();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)column);
                    }
                });
                collection.add(list3);
            }
            List list4 = (List)destination$iv$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            List $this$_get_arguments__u24lambda_u2d9_u24lambda_u2d8 = list4;
            boolean bl9 = false;
            this.arguments = $this$_get_arguments__u24lambda_u2d9_u24lambda_u2d8;
            list = list4;
        } else {
            list = list2;
        }
        return list;
    }

    @Override
    protected void setArguments(@Nullable List<? extends List<? extends Pair<? extends Column<?>, ? extends Object>>> list) {
        this.arguments = list;
    }

    @Override
    @NotNull
    protected Map<Column<?>, Object> valuesAndDefaults(@NotNull Map<Column<?>, ? extends Object> values2) {
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        List<List<Pair<Column<?>, Object>>> list = this.getArguments();
        Intrinsics.checkNotNull(list);
        return MapsKt.toMap((Iterable)((Iterable)CollectionsKt.first(list)));
    }

    @Override
    @NotNull
    public PreparedStatementApi prepared(@NotNull Transaction transaction2, @NotNull String sql2) {
        Intrinsics.checkNotNullParameter((Object)transaction2, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)sql2, (String)"sql");
        return !this.shouldReturnGeneratedValues ? transaction2.getConnection().prepareStatement(sql2, false) : super.prepared(transaction2, sql2);
    }

    private static final List<Column<?>> _get_arguments_$lambda-9$lambda-4(Lazy<? extends List<? extends Column<?>>> nullableColumns$delegate) {
        Lazy<? extends List<? extends Column<?>>> lazy = nullableColumns$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (List)lazy.getValue();
    }

    public static final /* synthetic */ Set access$allColumnsInDataSet(BaseBatchInsertStatement $this) {
        return $this.allColumnsInDataSet();
    }
}

