/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.ResultSet;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/exposed/sql/BasicBinaryColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "readObject", "rs", "Ljava/sql/ResultSet;", "index", "", "sqlType", "valueFromDB", "exposed-core"})
public class BasicBinaryColumnType
extends ColumnType {
    public BasicBinaryColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().binaryType();
    }

    @Override
    @Nullable
    public Object readObject(@NotNull ResultSet rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        return rs.getBytes(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Object valueFromDB(@NotNull Object value) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object2 = value;
        if (object2 instanceof Blob) {
            Closeable closeable = ((Blob)value).getBinaryStream();
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Object it = (InputStream)closeable;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                it = ByteStreamsKt.readBytes((InputStream)it);
                object = it;
            }
            catch (Throwable it) {
                throwable = it;
                throw it;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else if (object2 instanceof InputStream) {
            Closeable closeable = (Closeable)value;
            boolean bl = false;
            boolean bl4 = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl5 = false;
                byte[] byArray = ByteStreamsKt.readBytes((InputStream)it);
                object = byArray;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            object = value;
        }
        return object;
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])value;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            boolean bl2 = false;
            string = new String(byArray, charset);
        } else {
            string = value.toString();
        }
        return string;
    }
}

