/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.SiteStandardCondition;
import io.swagger.client.model.SiteStandardRestriction;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SiteStandardFieldRule {
    @SerializedName(value="fieldName")
    private String fieldName = null;
    @SerializedName(value="jobType")
    private String jobType = null;
    @SerializedName(value="conditions")
    private List<SiteStandardCondition> conditions = null;
    @SerializedName(value="attributeConditions")
    private List<SiteStandardCondition> attributeConditions = null;
    @SerializedName(value="onStatement")
    private OnStatementEnum onStatement = null;
    @SerializedName(value="doAction")
    private DoActionEnum doAction = null;
    @SerializedName(value="restriction")
    private SiteStandardRestriction restriction = null;
    @SerializedName(value="subFields")
    private List<SiteStandardFieldRule> subFields = null;
    @SerializedName(value="mustHave")
    private Boolean mustHave = null;

    public SiteStandardFieldRule fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the field this rule applies to")
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public SiteStandardFieldRule jobType(String jobType) {
        this.jobType = jobType;
        return this;
    }

    @ApiModelProperty(value="The job type this rule applies for. Empty job type means it applies to all job types")
    public String getJobType() {
        return this.jobType;
    }

    public void setJobType(String jobType) {
        this.jobType = jobType;
    }

    public SiteStandardFieldRule conditions(List<SiteStandardCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public SiteStandardFieldRule addConditionsItem(SiteStandardCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<SiteStandardCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Job fields conditions to limit when this rule applies")
    public List<SiteStandardCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<SiteStandardCondition> conditions) {
        this.conditions = conditions;
    }

    public SiteStandardFieldRule attributeConditions(List<SiteStandardCondition> attributeConditions) {
        this.attributeConditions = attributeConditions;
        return this;
    }

    public SiteStandardFieldRule addAttributeConditionsItem(SiteStandardCondition attributeConditionsItem) {
        if (this.attributeConditions == null) {
            this.attributeConditions = new ArrayList<SiteStandardCondition>();
        }
        this.attributeConditions.add(attributeConditionsItem);
        return this;
    }

    @ApiModelProperty(value="Multi-instance fields conditions to limit on what items this multi-instance rule applies. Should not be used in Must Have rules")
    public List<SiteStandardCondition> getAttributeConditions() {
        return this.attributeConditions;
    }

    public void setAttributeConditions(List<SiteStandardCondition> attributeConditions) {
        this.attributeConditions = attributeConditions;
    }

    public SiteStandardFieldRule onStatement(OnStatementEnum onStatement) {
        this.onStatement = onStatement;
        return this;
    }

    @ApiModelProperty(value="For on-do steps, specify the type of on statement this rule applies to. Omit this field for \"any on\"")
    public OnStatementEnum getOnStatement() {
        return this.onStatement;
    }

    public void setOnStatement(OnStatementEnum onStatement) {
        this.onStatement = onStatement;
    }

    public SiteStandardFieldRule doAction(DoActionEnum doAction) {
        this.doAction = doAction;
        return this;
    }

    @ApiModelProperty(value="For on-do steps, specify the type of do action this rule applies to. Omit this field for \"any do\"")
    public DoActionEnum getDoAction() {
        return this.doAction;
    }

    public void setDoAction(DoActionEnum doAction) {
        this.doAction = doAction;
    }

    public SiteStandardFieldRule restriction(SiteStandardRestriction restriction) {
        this.restriction = restriction;
        return this;
    }

    @ApiModelProperty(value="")
    public SiteStandardRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(SiteStandardRestriction restriction) {
        this.restriction = restriction;
    }

    public SiteStandardFieldRule subFields(List<SiteStandardFieldRule> subFields) {
        this.subFields = subFields;
        return this;
    }

    public SiteStandardFieldRule addSubFieldsItem(SiteStandardFieldRule subFieldsItem) {
        if (this.subFields == null) {
            this.subFields = new ArrayList<SiteStandardFieldRule>();
        }
        this.subFields.add(subFieldsItem);
        return this;
    }

    @ApiModelProperty(value="Used for list fields to indicate restrictions for items in the list. When mustHave is true, it means the list must contain at least one item with sub-fields that match these restrictions.")
    public List<SiteStandardFieldRule> getSubFields() {
        return this.subFields;
    }

    public void setSubFields(List<SiteStandardFieldRule> subFields) {
        this.subFields = subFields;
    }

    public SiteStandardFieldRule mustHave(Boolean mustHave) {
        this.mustHave = mustHave;
        return this;
    }

    @ApiModelProperty(value="Specifies if this is a must-have rule. Relevant only for list fields. true indicates that the field must contain at least one item that matches this rule's restriction false (or missing) indicates that when the field has items, all of them must match the rule's restriction")
    public Boolean isMustHave() {
        return this.mustHave;
    }

    public void setMustHave(Boolean mustHave) {
        this.mustHave = mustHave;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SiteStandardFieldRule siteStandardFieldRule = (SiteStandardFieldRule)o;
        return Objects.equals(this.fieldName, siteStandardFieldRule.fieldName) && Objects.equals(this.jobType, siteStandardFieldRule.jobType) && Objects.equals(this.conditions, siteStandardFieldRule.conditions) && Objects.equals(this.attributeConditions, siteStandardFieldRule.attributeConditions) && Objects.equals((Object)this.onStatement, (Object)siteStandardFieldRule.onStatement) && Objects.equals((Object)this.doAction, (Object)siteStandardFieldRule.doAction) && Objects.equals(this.restriction, siteStandardFieldRule.restriction) && Objects.equals(this.subFields, siteStandardFieldRule.subFields) && Objects.equals(this.mustHave, siteStandardFieldRule.mustHave);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.jobType, this.conditions, this.attributeConditions, this.onStatement, this.doAction, this.restriction, this.subFields, this.mustHave});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SiteStandardFieldRule {\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    jobType: ").append(this.toIndentedString(this.jobType)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    attributeConditions: ").append(this.toIndentedString(this.attributeConditions)).append("\n");
        sb.append("    onStatement: ").append(this.toIndentedString((Object)this.onStatement)).append("\n");
        sb.append("    doAction: ").append(this.toIndentedString((Object)this.doAction)).append("\n");
        sb.append("    restriction: ").append(this.toIndentedString(this.restriction)).append("\n");
        sb.append("    subFields: ").append(this.toIndentedString(this.subFields)).append("\n");
        sb.append("    mustHave: ").append(this.toIndentedString(this.mustHave)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OnStatementEnum {
        ENDEDNOTOK("EndedNotOK"),
        ENDED("Ended"),
        ENDEDOK("EndedOK"),
        COMPLETIONSTATUS("CompletionStatus"),
        EXECUTIONSCOUNT("ExecutionsCount"),
        RERUNSCOUNT("RerunsCount"),
        OUTPUTNOTFOUND("OutputNotFound"),
        NOTSUBMITTED("NotSubmitted"),
        ANYPROGRAMSTEP("AnyProgramStep"),
        EVERYPROGRAMSTEP("EveryProgramStep"),
        SPECIFICSTEPNAME("SpecificStepName"),
        SPECIFICRANGENAME("SpecificRangeName"),
        JOBRC("JOBRC"),
        OUTPUTPATTERN("OutputPattern"),
        FAILURESCOUNT("FailuresCount"),
        SPECIFICSTATEMENT("SpecificStatement");

        private String value;

        private OnStatementEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OnStatementEnum fromValue(String text) {
            for (OnStatementEnum b : OnStatementEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OnStatementEnum> {
            @Override
            public void write(JsonWriter jsonWriter, OnStatementEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public OnStatementEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OnStatementEnum.fromValue(String.valueOf(value));
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DoActionEnum {
        NOTIFY("Notify"),
        MAIL("Mail"),
        REMEDY("Remedy"),
        SETTOOK("SetToOK"),
        SETTONOTOK("SetToNotOK"),
        RERUNJOB("RerunJob"),
        STOPCYCLICRUN("StopCyclicRun"),
        SETVAR("SetVar"),
        ORDERJOB("OrderJob"),
        SYSOUT("SysOut"),
        CONDITION("Condition"),
        CTBRULE("CtbRule"),
        RESTART("Restart");

        private String value;

        private DoActionEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DoActionEnum fromValue(String text) {
            for (DoActionEnum b : DoActionEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DoActionEnum> {
            @Override
            public void write(JsonWriter jsonWriter, DoActionEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            @Override
            public DoActionEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DoActionEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

