/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class SSHKeyData {
    @SerializedName(value="keyName")
    private String keyName = null;
    @SerializedName(value="passPhrase")
    private String passPhrase = null;
    @SerializedName(value="format")
    private String format = "OpenSSH";
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="bits")
    private Integer bits = null;
    @SerializedName(value="async")
    private Boolean async = null;

    public SSHKeyData keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    @ApiModelProperty(value="The name for the key . REQUIRED.")
    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public SSHKeyData passPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
        return this;
    }

    @ApiModelProperty(value="The password for the key file . REQUIRED.")
    public String getPassPhrase() {
        return this.passPhrase;
    }

    public void setPassPhrase(String passPhrase) {
        this.passPhrase = passPhrase;
    }

    public SSHKeyData format(String format) {
        this.format = format;
        return this;
    }

    @ApiModelProperty(value="the format of the SSH key to generate. [OpenSSH/SSH2]")
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public SSHKeyData type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the SSH key to generate.  - For ctm versions under v22: [RSA (Default), DSA] - For ctm versions v22 and above: [RSA, ECDSA (Default)] ")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SSHKeyData bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    @ApiModelProperty(value="Generated keys defined with larger bits provides enhanced security.  For ctm versions under v22:   [512/768/1024 (Default)/2048/3072]  For ctm versions v22 and above:   - For RSA: 3072, 4096 (Default)   - For ECDSA: 256 (Default), 384, 521 ")
    public Integer getBits() {
        return this.bits;
    }

    public void setBits(Integer bits) {
        this.bits = bits;
    }

    public SSHKeyData async(Boolean async) {
        this.async = async;
        return this;
    }

    @ApiModelProperty(value="True to add SSH key asynchronously wit0h pollingId. HIDDEN")
    public Boolean isAsync() {
        return this.async;
    }

    public void setAsync(Boolean async) {
        this.async = async;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSHKeyData ssHKeyData = (SSHKeyData)o;
        return Objects.equals(this.keyName, ssHKeyData.keyName) && Objects.equals(this.passPhrase, ssHKeyData.passPhrase) && Objects.equals(this.format, ssHKeyData.format) && Objects.equals(this.type, ssHKeyData.type) && Objects.equals(this.bits, ssHKeyData.bits) && Objects.equals(this.async, ssHKeyData.async);
    }

    public int hashCode() {
        return Objects.hash(this.keyName, this.passPhrase, this.format, this.type, this.bits, this.async);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SSHKeyData {\n");
        sb.append("    keyName: ").append(this.toIndentedString(this.keyName)).append("\n");
        sb.append("    passPhrase: ").append(this.toIndentedString(this.passPhrase)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    bits: ").append(this.toIndentedString(this.bits)).append("\n");
        sb.append("    async: ").append(this.toIndentedString(this.async)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

