/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="File Transfer Server general parameters")
public class FtsGeneralSettings {
    @SerializedName(value="homeDirectory")
    private String homeDirectory = null;
    @SerializedName(value="multipleLoginAllowed")
    private Boolean multipleLoginAllowed = null;
    @SerializedName(value="maxOpenSessions")
    private Integer maxOpenSessions = null;
    @SerializedName(value="maxLoginFailures")
    private Integer maxLoginFailures = null;
    @SerializedName(value="delayAfterLoginFailure")
    private Integer delayAfterLoginFailure = null;
    @SerializedName(value="throttlingActivated")
    private Boolean throttlingActivated = null;
    @SerializedName(value="maxSimultaneousUploads")
    private Integer maxSimultaneousUploads = null;
    @SerializedName(value="maxSimultaneousDownloads")
    private Integer maxSimultaneousDownloads = null;
    @SerializedName(value="serverEnabled")
    private Boolean serverEnabled = null;
    @SerializedName(value="accessLogEnabled")
    private Boolean accessLogEnabled = null;

    public FtsGeneralSettings homeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        return this;
    }

    @ApiModelProperty(value="Root path where transferred files are stored. If you want to use a different directory for each logged in user, you must add /${userName} to the path.")
    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }

    public FtsGeneralSettings multipleLoginAllowed(Boolean multipleLoginAllowed) {
        this.multipleLoginAllowed = multipleLoginAllowed;
        return this;
    }

    @ApiModelProperty(value="Allow multiple open sessions")
    public Boolean isMultipleLoginAllowed() {
        return this.multipleLoginAllowed;
    }

    public void setMultipleLoginAllowed(Boolean multipleLoginAllowed) {
        this.multipleLoginAllowed = multipleLoginAllowed;
    }

    public FtsGeneralSettings maxOpenSessions(Integer maxOpenSessions) {
        this.maxOpenSessions = maxOpenSessions;
        return this;
    }

    @ApiModelProperty(value="Maximum concurrent open sessions")
    public Integer getMaxOpenSessions() {
        return this.maxOpenSessions;
    }

    public void setMaxOpenSessions(Integer maxOpenSessions) {
        this.maxOpenSessions = maxOpenSessions;
    }

    public FtsGeneralSettings maxLoginFailures(Integer maxLoginFailures) {
        this.maxLoginFailures = maxLoginFailures;
        return this;
    }

    @ApiModelProperty(value="Number of retries before the server closes the connection")
    public Integer getMaxLoginFailures() {
        return this.maxLoginFailures;
    }

    public void setMaxLoginFailures(Integer maxLoginFailures) {
        this.maxLoginFailures = maxLoginFailures;
    }

    public FtsGeneralSettings delayAfterLoginFailure(Integer delayAfterLoginFailure) {
        this.delayAfterLoginFailure = delayAfterLoginFailure;
        return this;
    }

    @ApiModelProperty(value="Time of waiting before letting the user to do another login in seconds")
    public Integer getDelayAfterLoginFailure() {
        return this.delayAfterLoginFailure;
    }

    public void setDelayAfterLoginFailure(Integer delayAfterLoginFailure) {
        this.delayAfterLoginFailure = delayAfterLoginFailure;
    }

    public FtsGeneralSettings throttlingActivated(Boolean throttlingActivated) {
        this.throttlingActivated = throttlingActivated;
        return this;
    }

    @ApiModelProperty(value="Allow bandwidth throttling")
    public Boolean isThrottlingActivated() {
        return this.throttlingActivated;
    }

    public void setThrottlingActivated(Boolean throttlingActivated) {
        this.throttlingActivated = throttlingActivated;
    }

    public FtsGeneralSettings maxSimultaneousUploads(Integer maxSimultaneousUploads) {
        this.maxSimultaneousUploads = maxSimultaneousUploads;
        return this;
    }

    @ApiModelProperty(value="Maximum simultaneos uploads")
    public Integer getMaxSimultaneousUploads() {
        return this.maxSimultaneousUploads;
    }

    public void setMaxSimultaneousUploads(Integer maxSimultaneousUploads) {
        this.maxSimultaneousUploads = maxSimultaneousUploads;
    }

    public FtsGeneralSettings maxSimultaneousDownloads(Integer maxSimultaneousDownloads) {
        this.maxSimultaneousDownloads = maxSimultaneousDownloads;
        return this;
    }

    @ApiModelProperty(value="Maximum simultaneos downloads")
    public Integer getMaxSimultaneousDownloads() {
        return this.maxSimultaneousDownloads;
    }

    public void setMaxSimultaneousDownloads(Integer maxSimultaneousDownloads) {
        this.maxSimultaneousDownloads = maxSimultaneousDownloads;
    }

    public FtsGeneralSettings serverEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
        return this;
    }

    @ApiModelProperty(value="Enable/Disable the File Transfer Server")
    public Boolean isServerEnabled() {
        return this.serverEnabled;
    }

    public void setServerEnabled(Boolean serverEnabled) {
        this.serverEnabled = serverEnabled;
    }

    public FtsGeneralSettings accessLogEnabled(Boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
        return this;
    }

    @ApiModelProperty(value="Is FTS Access Log enabled - true/false")
    public Boolean isAccessLogEnabled() {
        return this.accessLogEnabled;
    }

    public void setAccessLogEnabled(Boolean accessLogEnabled) {
        this.accessLogEnabled = accessLogEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FtsGeneralSettings ftsGeneralSettings = (FtsGeneralSettings)o;
        return Objects.equals(this.homeDirectory, ftsGeneralSettings.homeDirectory) && Objects.equals(this.multipleLoginAllowed, ftsGeneralSettings.multipleLoginAllowed) && Objects.equals(this.maxOpenSessions, ftsGeneralSettings.maxOpenSessions) && Objects.equals(this.maxLoginFailures, ftsGeneralSettings.maxLoginFailures) && Objects.equals(this.delayAfterLoginFailure, ftsGeneralSettings.delayAfterLoginFailure) && Objects.equals(this.throttlingActivated, ftsGeneralSettings.throttlingActivated) && Objects.equals(this.maxSimultaneousUploads, ftsGeneralSettings.maxSimultaneousUploads) && Objects.equals(this.maxSimultaneousDownloads, ftsGeneralSettings.maxSimultaneousDownloads) && Objects.equals(this.serverEnabled, ftsGeneralSettings.serverEnabled) && Objects.equals(this.accessLogEnabled, ftsGeneralSettings.accessLogEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.homeDirectory, this.multipleLoginAllowed, this.maxOpenSessions, this.maxLoginFailures, this.delayAfterLoginFailure, this.throttlingActivated, this.maxSimultaneousUploads, this.maxSimultaneousDownloads, this.serverEnabled, this.accessLogEnabled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FtsGeneralSettings {\n");
        sb.append("    homeDirectory: ").append(this.toIndentedString(this.homeDirectory)).append("\n");
        sb.append("    multipleLoginAllowed: ").append(this.toIndentedString(this.multipleLoginAllowed)).append("\n");
        sb.append("    maxOpenSessions: ").append(this.toIndentedString(this.maxOpenSessions)).append("\n");
        sb.append("    maxLoginFailures: ").append(this.toIndentedString(this.maxLoginFailures)).append("\n");
        sb.append("    delayAfterLoginFailure: ").append(this.toIndentedString(this.delayAfterLoginFailure)).append("\n");
        sb.append("    throttlingActivated: ").append(this.toIndentedString(this.throttlingActivated)).append("\n");
        sb.append("    maxSimultaneousUploads: ").append(this.toIndentedString(this.maxSimultaneousUploads)).append("\n");
        sb.append("    maxSimultaneousDownloads: ").append(this.toIndentedString(this.maxSimultaneousDownloads)).append("\n");
        sb.append("    serverEnabled: ").append(this.toIndentedString(this.serverEnabled)).append("\n");
        sb.append("    accessLogEnabled: ").append(this.toIndentedString(this.accessLogEnabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

