/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class AddAgentParams {
    @SerializedName(value="host")
    private String host = null;
    @SerializedName(value="port")
    private Integer port = null;
    @SerializedName(value="tag")
    private String tag = null;
    @SerializedName(value="sslState")
    private String sslState = null;
    @SerializedName(value="persistentConnection")
    private Boolean persistentConnection = null;
    @SerializedName(value="timeout")
    private Integer timeout = 60;
    @SerializedName(value="suppressPing")
    private Boolean suppressPing = false;
    @SerializedName(value="agentType")
    private String agentType = null;

    public AddAgentParams host(String host) {
        this.host = host;
        return this;
    }

    @ApiModelProperty(required=true, value="The hostname or alias of the agent machine.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public AddAgentParams port(Integer port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="The agent's listening port.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public AddAgentParams tag(String tag) {
        this.tag = tag;
        return this;
    }

    @ApiModelProperty(value="The agent's tag.")
    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public AddAgentParams sslState(String sslState) {
        this.sslState = sslState;
        return this;
    }

    @ApiModelProperty(value="The agent's ssl State. HIDDEN.")
    public String getSslState() {
        return this.sslState;
    }

    public void setSslState(String sslState) {
        this.sslState = sslState;
    }

    public AddAgentParams persistentConnection(Boolean persistentConnection) {
        this.persistentConnection = persistentConnection;
        return this;
    }

    @ApiModelProperty(value="Is the connection persistent or create each time it is needed. HIDDEN.")
    public Boolean isPersistentConnection() {
        return this.persistentConnection;
    }

    public void setPersistentConnection(Boolean persistentConnection) {
        this.persistentConnection = persistentConnection;
    }

    public AddAgentParams timeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @ApiModelProperty(value="maximum time in seconds to wait (default 60). HIDDEN")
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public AddAgentParams suppressPing(Boolean suppressPing) {
        this.suppressPing = suppressPing;
        return this;
    }

    @ApiModelProperty(value="Suppress ping action to added agent (default false). HIDDEN.")
    public Boolean isSuppressPing() {
        return this.suppressPing;
    }

    public void setSuppressPing(Boolean suppressPing) {
        this.suppressPing = suppressPing;
    }

    public AddAgentParams agentType(String agentType) {
        this.agentType = agentType;
        return this;
    }

    @ApiModelProperty(value="The agent's type.")
    public String getAgentType() {
        return this.agentType;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddAgentParams addAgentParams = (AddAgentParams)o;
        return Objects.equals(this.host, addAgentParams.host) && Objects.equals(this.port, addAgentParams.port) && Objects.equals(this.tag, addAgentParams.tag) && Objects.equals(this.sslState, addAgentParams.sslState) && Objects.equals(this.persistentConnection, addAgentParams.persistentConnection) && Objects.equals(this.timeout, addAgentParams.timeout) && Objects.equals(this.suppressPing, addAgentParams.suppressPing) && Objects.equals(this.agentType, addAgentParams.agentType);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port, this.tag, this.sslState, this.persistentConnection, this.timeout, this.suppressPing, this.agentType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddAgentParams {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    sslState: ").append(this.toIndentedString(this.sslState)).append("\n");
        sb.append("    persistentConnection: ").append(this.toIndentedString(this.persistentConnection)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    suppressPing: ").append(this.toIndentedString(this.suppressPing)).append("\n");
        sb.append("    agentType: ").append(this.toIndentedString(this.agentType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

