/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.os;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.os.OsGlobals;
import java.util.HashMap;
import java.util.Map;

public class OsDataImportMethodGetter {
    private final String assessmentType = "Assessment";
    private final String progressBarType = "ProgressBar";
    private Map<String, String> methodAndTypeToTitleMap = new HashMap<String, String>();

    public OsDataImportMethodGetter() {
        this.methodAndTypeToTitleMap.put("Assessment" + OsGlobals.DataImportMethod.FromDiscovery.getName(), "The following %s retrieved from BMC Discovery:\n\n");
        this.methodAndTypeToTitleMap.put("Assessment" + OsGlobals.DataImportMethod.Automatic.getName(), "The following %s retrieved from the Control-M Agents used for discovery:\n\n");
        this.methodAndTypeToTitleMap.put("Assessment" + OsGlobals.DataImportMethod.Manually.getName(), "The following %s loaded manually:\n\n");
        this.methodAndTypeToTitleMap.put("ProgressBar" + OsGlobals.DataImportMethod.FromDiscovery.getName(), "Importing %s definitions from BMC Discovery");
        this.methodAndTypeToTitleMap.put("ProgressBar" + OsGlobals.DataImportMethod.Automatic.getName(), "Importing %s definitions using Control-M");
        this.methodAndTypeToTitleMap.put("ProgressBar" + OsGlobals.DataImportMethod.Manually.getName(), "Importing manual files from %s");
    }

    public String getDataImportMethodTitle(String osVendorName) {
        return this.getDataImportTitle(osVendorName, "Assessment");
    }

    public String getDataImportProgressBarTitle(String osVendorName) {
        return this.getDataImportTitle(osVendorName, "ProgressBar");
    }

    private String getDataImportTitle(String osVendorName, String type) {
        String dataImportTitle = this.setDefaultTitle(osVendorName, type);
        String dataImportMethod = Params.instance().getDataImportMethod();
        if (dataImportMethod != "") {
            dataImportTitle = String.format(this.methodAndTypeToTitleMap.get(type + dataImportMethod), osVendorName);
        }
        return dataImportTitle;
    }

    private String setDefaultTitle(String osVendorName, String type) {
        String titlePattern = type.equals("Assessment") ? "" : "Importing manual files from %s";
        return String.format(titlePattern, osVendorName);
    }
}

