/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.os;

import com.bmc.ctmconvert.bmcdiscovery.DiscoveryDefinitionsGetter;
import com.bmc.ctmconvert.bmcdiscovery.DiscoveryExceptionInterpreter;
import com.bmc.ctmconvert.bmcdiscovery.DiscoveryIntegrationException;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryDefinitionsParser;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryFilesWriter;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.os.DISCOVERY_OS_TYPE;
import java.util.Map;
import org.json.JSONArray;

public class DiscoveryCollectionHandler {
    protected String destinationDirectory;

    public DiscoveryCollectionHandler(String destinationDirectory) {
        this.destinationDirectory = destinationDirectory;
    }

    public FlowGlobals.COMPLETION_MODE handleDiscoveryCollection(String hostname, String username, String password, DISCOVERY_OS_TYPE type, OSDiscoveryDefinitionsParser discoveryDefParser, OSDiscoveryFilesWriter osFilesWriter) throws DiscoveryIntegrationException {
        try {
            DiscoveryDefinitionsGetter definitionsDiscovery = new DiscoveryDefinitionsGetter(hostname, username, password, type);
            JSONArray cronDefinitions = definitionsDiscovery.getOSTypeDefinitions();
            discoveryDefParser.parse(cronDefinitions);
            Map parsedCronDefinitions = discoveryDefParser.getParsedDefinitions();
            osFilesWriter.writeOSfiles(parsedCronDefinitions);
            return FlowGlobals.COMPLETION_MODE.SUCCESS;
        }
        catch (Throwable e) {
            ExceptionHandler.writeToExceptionFile(new Exception(e));
            DiscoveryExceptionInterpreter interpreter = new DiscoveryExceptionInterpreter();
            String message = interpreter.interpretException(e);
            throw new DiscoveryIntegrationException(message);
        }
    }
}

