/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.discovery;

import com.bmc.ctmconvert.base.table.BaseTableModel;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.discovery.DiscoveryJob;
import com.bmc.ctmconvert.discovery.DiscoveryMonitor;
import com.bmc.ctmconvert.discovery.DiscoveryResults;
import java.util.HashMap;

public class DiscoverySubmitter {
    private String mainScriptPath;
    public static final String unixScriptName = "captureScriptUNIX.txt";
    public static final String windowsScriptName = "captureScriptWindows.txt";
    private DiscoveryMonitor fileListMonitor;
    private boolean isUnixServer;

    public DiscoverySubmitter(String mainScriptPath, String platform) {
        this.mainScriptPath = mainScriptPath;
        this.isUnixServer = platform.trim().toUpperCase().equals("UNIX");
    }

    public DiscoveryResults submitAgentListJob() {
        return this.submitAgentListJob(null);
    }

    public DiscoveryResults submitAgentListJob(DiscoveryResults discoveryResults) {
        String remoteDirSep;
        if (discoveryResults == null) {
            discoveryResults = new DiscoveryResults(DiscoveryResults.ResultsType.AGENTS_LIST);
        }
        DiscoveryMonitor discoMonitor = new DiscoveryMonitor(discoveryResults, DiscoveryJob.getAgentExepath());
        String serverHost = DiscoveryJob.getPrimaryServer();
        Object remoteFullPath = this.mainScriptPath;
        String string = remoteDirSep = this.isUnixServer ? "/" : "\\";
        if (!((String)remoteFullPath).isEmpty() && !((String)remoteFullPath).endsWith(remoteDirSep)) {
            remoteFullPath = (String)remoteFullPath + remoteDirSep;
        }
        remoteFullPath = (String)remoteFullPath + (this.isUnixServer ? unixScriptName : windowsScriptName);
        DiscoveryJob agListJob = new DiscoveryJob((String)remoteFullPath, "\"Get Agents\"", "", serverHost, true, "get_agent_list_from_server");
        agListJob.setMonitored(false);
        agListJob.setAutoedit("PARM1", "GET_AGENTS");
        discoMonitor.registerJob(agListJob);
        discoMonitor.addValidityListener(discoveryResults);
        discoveryResults.setBusyLoading(true);
        new Thread(discoMonitor).start();
        return discoveryResults;
    }

    public DiscoveryResults submitRetrieveDataJob(BaseTableModel agentsModel) {
        return this.submitRetrieveDataJob(agentsModel, null);
    }

    public DiscoveryResults submitRetrieveDataJob(BaseTableModel agentsModel, DiscoveryResults discoveryResults) {
        if (discoveryResults == null) {
            discoveryResults = new DiscoveryResults(DiscoveryResults.ResultsType.CAPTURE_FILES);
        }
        this.fileListMonitor = new DiscoveryMonitor(discoveryResults, DiscoveryJob.getAgentExepath());
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("PARM1", "GET_JOB_DEFS");
        if (agentsModel != null) {
            for (int i = 0; i < agentsModel.getRowCount(); ++i) {
                String remoteDirSep;
                if (!((Boolean)agentsModel.getValueAt(i, 1)).booleanValue()) continue;
                String owner = (String)agentsModel.getValueAt(i, 5);
                owner = owner.equals("ALL") && Params.instance().getVendorName().equals("CRON") ? "root" : owner;
                String description = String.format("\"Retrieve %s definitions\"", Params.instance().getVendorName().equals("MS") ? "MS Task Scheduler" : "Cron");
                Object remoteFullPath = this.mainScriptPath;
                String string = remoteDirSep = this.isUnixServer ? "/" : "\\";
                if (!((String)remoteFullPath).isEmpty() && !((String)remoteFullPath).endsWith(remoteDirSep)) {
                    remoteFullPath = (String)remoteFullPath + remoteDirSep;
                }
                remoteFullPath = (String)remoteFullPath + (Params.instance().getVendorName().equals("CRON") ? unixScriptName : windowsScriptName);
                String jobName = Params.instance().getVendorName().equals("CRON") ? String.format("get_%s_at_%s", owner, (String)agentsModel.getValueAt(i, 3)) : String.format("get_task_definition_at_%s", (String)agentsModel.getValueAt(i, 3));
                DiscoveryJob tmpJob = new DiscoveryJob((String)remoteFullPath, description, owner, (String)agentsModel.getValueAt(i, 3), true, jobName);
                tmpJob.setAutoedit(vars);
                this.fileListMonitor.registerJob(tmpJob);
            }
        }
        this.fileListMonitor.addValidityListener(discoveryResults);
        new Thread(this.fileListMonitor).start();
        return discoveryResults;
    }

    public void stopMonitoring() {
        this.fileListMonitor.stopMonitoring();
    }
}

