/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.bmcdiscovery;

import com.bmc.ctmconvert.bmcdiscovery.SSLSocketFactoryImpl;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.os.DISCOVERY_OS_TYPE;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class DiscoveryDefinitionsGetter {
    private String token;
    private String token_type;
    private String host;
    private String user;
    private String password;
    private String type;

    public DiscoveryDefinitionsGetter(String host, String user, String password, DISCOVERY_OS_TYPE type) throws Throwable {
        this.host = host;
        this.user = user;
        this.password = password;
        this.type = type.toString();
        this.connect();
    }

    private void connect() throws Throwable {
        this.createToken();
    }

    public JSONArray getOSTypeDefinitions() throws Throwable {
        String query = String.format("   Search Host \r\n   where hostname matches \"%s\"\ttraverse InferredElement:Inference:Primary:HostInfo \r\n\ttraverse DiscoveryResult:DiscoveryAccessResult:DiscoveryAccess:DiscoveryAccess \r\n\ttraverse DiscoveryAccess:DiscoveryAccessResult:DiscoveryResult:DiscoveredCommandResult \r\n\twhere \r\n\t\tcmd matches \"%s\" \r\n\tand \r\n\t\tmethod_success matches \"(?i)run\\s?command\" \r\n\tshow \r\n\t\t#DiscoveryResult:DiscoveryAccessResult:DiscoveryAccess:DiscoveryAccess.#Associate:Inference:InferredElement:Host.name,\r\n\t\tresult", ".*", this.type);
        JSONArray queryResponse = this.sendQueryToDiscovery(query);
        return queryResponse;
    }

    private JSONArray sendQueryToDiscovery(String query) throws Throwable {
        query = URLEncoder.encode(query, "UTF-8");
        String queryUrl = "https://" + this.host + "/api/v1.0/data/search?format=object&query=" + query + "&limit=0";
        URL url = new URL(queryUrl);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
        this.setConnectionDefaultProperities(httpsConnection);
        String basicAuth = this.token_type + " " + this.token;
        httpsConnection.addRequestProperty("Authorization", basicAuth);
        httpsConnection.addRequestProperty("Accept", "application/json");
        httpsConnection.setRequestMethod("GET");
        String responseString = this.retriveServerResponse(httpsConnection);
        return new JSONArray(responseString);
    }

    private String retriveServerResponse(HttpsURLConnection httpsConnection) throws Throwable {
        String inputLine;
        InputStream responseInputStream = null;
        int responseCode = httpsConnection.getResponseCode();
        if (responseCode >= 400) {
            ExceptionHandler.writeToExceptionFile("DiscoveryConnection Error code:" + responseCode);
            throw new Exception(Integer.toString(responseCode));
        }
        responseInputStream = httpsConnection.getInputStream();
        BufferedReader responseReader = new BufferedReader(new InputStreamReader(responseInputStream, StandardCharsets.UTF_8));
        StringBuilder responseStringBuffer = new StringBuilder();
        while ((inputLine = responseReader.readLine()) != null) {
            responseStringBuffer.append(inputLine).append('\n');
        }
        responseReader.close();
        String responseString = responseStringBuffer.toString();
        return responseString;
    }

    private void createToken() throws Throwable {
        StringBuilder postData = this.getPostData();
        byte[] postDataBytes = postData.toString().getBytes("UTF-8");
        String token_https_url = "https://" + this.host + "/api/token";
        URL url = new URL(token_https_url);
        HttpsURLConnection httpsConnection = (HttpsURLConnection)url.openConnection();
        String userCredentials = this.user + ":" + this.password;
        String basicAuth = "Basic " + new String(Base64.getEncoder().encodeToString(userCredentials.getBytes()));
        httpsConnection.addRequestProperty("Authorization", basicAuth);
        httpsConnection.setRequestMethod("POST");
        this.setConnectionDefaultProperities(httpsConnection);
        OutputStream wr = httpsConnection.getOutputStream();
        wr.write(postDataBytes);
        wr.flush();
        wr.close();
        String responseString = this.retriveServerResponse(httpsConnection);
        JSONObject responseJsonObject = new JSONObject(responseString);
        this.token = (String)responseJsonObject.get("access_token");
        this.token_type = (String)responseJsonObject.get("token_type");
    }

    private void setConnectionDefaultProperities(HttpsURLConnection httpsConnection) throws Throwable {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(this){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        };
        httpsConnection.setHostnameVerifier(hostnameVerifier);
        SSLSocketFactoryImpl sf = new SSLSocketFactoryImpl();
        httpsConnection.setSSLSocketFactory(sf);
        httpsConnection.addRequestProperty("Accept", "application/json");
        httpsConnection.setDoOutput(true);
        httpsConnection.setDoInput(true);
    }

    private StringBuilder getPostData() throws UnsupportedEncodingException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put("grant_type", "password");
        StringBuilder postData = new StringBuilder();
        for (Map.Entry param : params.entrySet()) {
            if (postData.length() != 0) {
                postData.append('&');
            }
            postData.append(URLEncoder.encode((String)param.getKey(), "UTF-8"));
            postData.append('=');
            postData.append(URLEncoder.encode(String.valueOf(param.getValue()), "UTF-8"));
        }
        return postData;
    }
}

