/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.common.xml.XmlWriter;
import com.bmc.ctmconvert.maybe.conditions.CtmDraftUpdater;
import com.bmc.ctmconvert.maybe.conditions.CtmEntityUpdater;
import com.bmc.ctmconvert.maybe.conditions.LoadMaybeCondList;
import com.bmc.ctmconvert.maybe.conditions.ReportStatusAndErrors;
import com.bmc.ctmconvert.maybe.conditions.UtilityStreamRepository;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UtilityRunner {
    private static final String CREATING_REPORT = "\nCreating report ...";
    private static final String UPDATING_CTM_DATA = "\nUpdating CtmData ...";
    private static final String PARSING_INPUT = "Parsing input file ...";

    public void run(UtilityStreamRepository streamRepository) throws IOException {
        Logger.getLogger().setOutputStream(streamRepository.getLogOutputStream());
        System.out.println(PARSING_INPUT);
        Map<String, List<CtmEntityUpdater>> jobActionsMap = new HashMap<String, List<CtmEntityUpdater>>();
        LoadMaybeCondList parser = new LoadMaybeCondList(jobActionsMap, "@-", "I-");
        jobActionsMap = parser.load(streamRepository.getMaybeInheritedCondStream());
        System.out.println(UPDATING_CTM_DATA);
        CtmDraftUpdater draftUpdater = new CtmDraftUpdater(jobActionsMap);
        XmlElement rootElement = XmlLoader.from((InputStream)streamRepository.getCtmDataInputStream());
        rootElement = draftUpdater.updateJobs(rootElement);
        XmlWriter xmlWriter = new XmlWriter(rootElement.getElement());
        PrintWriter printWriter = new PrintWriter(streamRepository.getCtmDataOutputStream());
        printWriter.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        xmlWriter.writeXml((Writer)printWriter);
        System.out.println(CREATING_REPORT);
        ReportStatusAndErrors reportStatusAndErrors = new ReportStatusAndErrors(jobActionsMap, streamRepository.getReportOutputStream());
        reportStatusAndErrors.collect();
    }
}

