/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.maybe.conditions;

import com.bmc.ctmconvert.common.log.Logger;

public class ConditionSpliter {
    private String sourceJobName;
    private String targetJobName;
    private String globalPrefix;
    private String sourceJobNamePrefix;
    private String targetJobNamePrefix;

    public ConditionSpliter(String fullConditionName) {
        String[] conditionNameComponents = fullConditionName.split("-");
        if (conditionNameComponents.length < 2) {
            Logger.getLogger().writeToLogOnly("Condition name has no dash: " + fullConditionName);
            this.sourceJobName = "s_err";
            this.targetJobName = "t_err";
            this.sourceJobNamePrefix = "Z";
            this.targetJobNamePrefix = "Z";
            this.globalPrefix = "";
        } else {
            this.sourceJobName = conditionNameComponents[conditionNameComponents.length - 2].substring(1);
            this.targetJobName = conditionNameComponents[conditionNameComponents.length - 1].substring(1);
            this.sourceJobNamePrefix = conditionNameComponents[conditionNameComponents.length - 2].substring(0, 1);
            this.targetJobNamePrefix = conditionNameComponents[conditionNameComponents.length - 1].substring(0, 1);
            this.globalPrefix = "";
            if (conditionNameComponents.length == 3) {
                this.globalPrefix = conditionNameComponents[0] + "-";
            } else if (conditionNameComponents.length == 4) {
                this.globalPrefix = conditionNameComponents[0] + "-" + conditionNameComponents[1] + "-";
            } else if (conditionNameComponents.length > 4) {
                this.globalPrefix = "ERROR-";
            }
        }
    }

    public String getGlobalPrefix() {
        return this.globalPrefix;
    }

    public String getSourceJob() {
        return this.sourceJobName;
    }

    public String getTargetJob() {
        return this.targetJobName;
    }

    public String getFullConNameWithInsertion(String prefix, String sourceJobPrefix, String targetJobPrefix) {
        return this.globalPrefix + prefix + sourceJobPrefix + this.sourceJobName + "-" + targetJobPrefix + this.targetJobName;
    }

    public String getFullConNameWithInsertion(String prefix) {
        return this.getFullConNameWithInsertion(prefix, this.sourceJobNamePrefix, this.targetJobNamePrefix);
    }

    public boolean compareCond(String otherSourceJob, String otherTargetJob) {
        return this.sourceJobName.equals(otherSourceJob) && this.targetJobName.equals(otherTargetJob);
    }

    public String getSourceJobPrefix() {
        return this.sourceJobNamePrefix;
    }

    public String getTargetJobPrefix() {
        return this.targetJobNamePrefix;
    }
}

