/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer.criticalpath;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.criticalpath.ReportConstants;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CriticalPathReportWriter {
    private XSSFWorkbook excelWorkBook;
    private Sheet criticalPathSheet;
    private XSSFCellStyle headerStyle;
    private XSSFFont font;
    private int criticalPathSheetIndex = 0;
    private int summarySheetIndex = 0;
    private int exceptionsSheetIndex = 0;
    private XSSFCellStyle recordStyle;
    private XSSFSheet summarySheet;
    private XSSFSheet exceptionsSheet;

    public CriticalPathReportWriter() {
        this.setUpReportConfig();
    }

    private void setUpReportConfig() {
        this.excelWorkBook = new XSSFWorkbook();
        this.summarySheet = this.excelWorkBook.createSheet("Summary");
        this.criticalPathSheet = this.excelWorkBook.createSheet("Critical Path");
        this.setColumnWidth(this.criticalPathSheet);
        this.setColumnWidth((Sheet)this.summarySheet);
        this.headerStyle = this.createStyle(true);
        this.recordStyle = this.createStyle(false);
        this.criticalPathSheet.createFreezePane(0, 1);
        this.criticalPathSheetIndex = this.createRow(this.criticalPathSheet, ReportConstants.CRITICAL_PATH_HEADERS, this.criticalPathSheetIndex, this.headerStyle);
        this.summarySheet.createFreezePane(0, 1);
        this.summarySheetIndex = this.createRow((Sheet)this.summarySheet, ReportConstants.SUMMARY_HEADERS, this.summarySheetIndex, this.headerStyle);
        this.font.setBold(false);
    }

    private XSSFCellStyle createStyle(Boolean isBold) {
        XSSFCellStyle cellStyle = this.excelWorkBook.createCellStyle();
        this.font = this.excelWorkBook.createFont();
        this.font.setBold(isBold.booleanValue());
        cellStyle.setFont((Font)this.font);
        cellStyle.setWrapText(true);
        HorizontalAlignment align = HorizontalAlignment.CENTER;
        cellStyle.setAlignment(align);
        return cellStyle;
    }

    public XSSFWorkbook addEntitiyDependenciesToReport(List<EntityNode> predecessorsList, List<EntityNode> successorsList, EntityNode criticalEntity) {
        System.out.println("[INFO] writing report for entity: " + criticalEntity.getPathAsString());
        predecessorsList.stream().forEach(predecessor -> this.writeRecord(criticalEntity, (EntityNode)predecessor, ReportConstants.DependencyType.Predecessor));
        successorsList.stream().forEach(succsessor -> this.writeRecord(criticalEntity, (EntityNode)succsessor, ReportConstants.DependencyType.Succsessor));
        this.writeEntitySummary(criticalEntity, predecessorsList.size(), successorsList.size());
        return this.excelWorkBook;
    }

    public XSSFWorkbook addExceptionsToReport(Map<String, String> exceptionEntity2cause) {
        if (!exceptionEntity2cause.isEmpty()) {
            this.setUpExceptionsSheet();
            exceptionEntity2cause.keySet().stream().forEach(entity -> {
                String[] record = new String[]{entity, (String)exceptionEntity2cause.get(entity)};
                this.exceptionsSheetIndex = this.createRow((Sheet)this.exceptionsSheet, record, this.exceptionsSheetIndex, this.recordStyle);
            });
        }
        return this.excelWorkBook;
    }

    private void setUpExceptionsSheet() {
        this.exceptionsSheet = this.excelWorkBook.createSheet("Exceptions");
        this.exceptionsSheet.createFreezePane(0, 1);
        this.setColumnWidth((Sheet)this.exceptionsSheet);
        this.exceptionsSheetIndex = this.createRow((Sheet)this.exceptionsSheet, ReportConstants.EXCEPTIONS_HEADERS, this.exceptionsSheetIndex, this.headerStyle);
    }

    private void writeEntitySummary(EntityNode criticalEntity, int predAmount, int succAmount) {
        String[] record = new String[]{criticalEntity.getPathAsString(), Integer.toString(predAmount), Integer.toString(succAmount), Integer.toString(predAmount + succAmount)};
        this.summarySheetIndex = this.createRow((Sheet)this.summarySheet, record, this.summarySheetIndex, this.recordStyle);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.excelWorkBook.write(outputStream);
    }

    private void writeRecord(EntityNode criticalEntity, EntityNode predecessor, ReportConstants.DependencyType dependencyType) {
        String[] record = new String[]{criticalEntity.getPathAsString(), dependencyType.toString(), predecessor.getPathAsString(), predecessor.getType()};
        this.criticalPathSheetIndex = this.createRow(this.criticalPathSheet, record, this.criticalPathSheetIndex, this.recordStyle);
    }

    private void setColumnWidth(Sheet sheet) {
        sheet.setColumnWidth(0, 5000);
        sheet.setColumnWidth(1, 5000);
        sheet.setColumnWidth(2, 5000);
        sheet.setColumnWidth(3, 5000);
    }

    private int createRow(Sheet sheet, String[] header, int index, XSSFCellStyle style) {
        Row row = sheet.createRow(index++);
        for (int i = 0; i < header.length; ++i) {
            Cell cell = row.createCell(i);
            cell.setCellValue(header[i]);
            cell.setCellStyle((CellStyle)style);
        }
        return index;
    }

    XSSFWorkbook getExcelObject() {
        return this.excelWorkBook;
    }
}

