/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.toolbox.compare.condition_compare.predicates.EndOfFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfJobPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfSmartFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.EndOfSubFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfFolderPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfJobPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfSmartPredicate;
import com.bmc.toolbox.compare.condition_compare.predicates.StartOfSubFolderPredicate;
import java.util.function.Predicate;
import javax.xml.stream.events.XMLEvent;

public class XmlPredicatorService {
    private static Predicate<XMLEvent> startOfFolderPredicate = new StartOfFolderPredicate();
    private static Predicate<XMLEvent> endOfFolderPredicate = new EndOfFolderPredicate();
    private static Predicate<XMLEvent> startOfSubFolderPredicate = new StartOfSubFolderPredicate();
    private static Predicate<XMLEvent> endOfSubFolderPredicate = new EndOfSubFolderPredicate();
    private static Predicate<XMLEvent> endOfJobPredicate = new EndOfJobPredicate();
    private static Predicate<XMLEvent> startOfJobPredicate = new StartOfJobPredicate();
    private static Predicate<XMLEvent> endOfSmartPredicate = new EndOfSmartFolderPredicate();
    private static Predicate<XMLEvent> startOfSmartPredicate = new StartOfSmartPredicate();

    public static boolean isStartOfFolder(XMLEvent event) {
        return startOfFolderPredicate.test(event);
    }

    public static boolean isEndOfFolder(XMLEvent event) {
        return endOfFolderPredicate.test(event);
    }

    public static boolean isStartOfSubFolder(XMLEvent event) {
        return startOfSubFolderPredicate.test(event);
    }

    public static boolean isEndOfSubFolder(XMLEvent event) {
        return endOfSubFolderPredicate.test(event);
    }

    public static boolean isEndOfJob(XMLEvent event) {
        return endOfJobPredicate.test(event);
    }

    public static boolean isStartOfJob(XMLEvent event) {
        return startOfJobPredicate.test(event);
    }

    public static boolean isEndOfSmartFolder(XMLEvent event) {
        return endOfSmartPredicate.test(event);
    }

    public static boolean isStartOfSmartFolder(XMLEvent event) {
        return startOfSmartPredicate.test(event);
    }

    public static Predicate<XMLEvent> getEndOfJobPredicate() {
        return endOfJobPredicate;
    }

    public static Predicate<XMLEvent> getEndOfSubFolderPredicate() {
        return endOfSubFolderPredicate;
    }

    public static Predicate<XMLEvent> getEndOfFolderPredicate() {
        return endOfFolderPredicate;
    }

    public static Predicate<XMLEvent> getEndOfSmartFolderPredicate() {
        return endOfSmartPredicate;
    }
}

