/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.draftanalyzer.ConditionHandler;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.EntityTree;
import com.bmc.ctmconvert.draftanalyzer.ReaderService;
import com.bmc.ctmconvert.draftanalyzer.XmlPredicatorService;
import com.bmc.toolbox.compare.condition_compare.ValueGetter;
import com.bmc.toolbox.compare.condition_compare.draftReader.DraftEntitiesReader;
import com.bmc.toolbox.compare.condition_compare.draftReader.ReaderFactory;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import java.util.List;
import java.util.function.Predicate;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ReaderHandler {
    private ConditionHandler conditionHandler;
    private ReaderFactory factory;
    private ReaderService readerService;

    public ReaderHandler(EntityTree entityTree) {
        this.conditionHandler = entityTree.getConditionHandler();
        this.factory = new ReaderFactory();
    }

    public void setReaderService(ReaderService readerService) {
        this.readerService = readerService;
    }

    public void setFolderOSType(EntityNode entityNode, List<MyAttribute> myAttributes) {
        String dsnString = this.getValueFromAttributeList("FOLDER_DSN", myAttributes);
        if (dsnString != null && !dsnString.isEmpty()) {
            entityNode.setOs("Mainframe");
        } else {
            entityNode.setOs("DS");
        }
    }

    public String getValueFromAttributeList(String value, List<MyAttribute> myAttributes) {
        ValueGetter nameGetter = new ValueGetter(value);
        return nameGetter.fromList(myAttributes);
    }

    private Predicate<XMLEvent> getEndOfEntityPredicate(EntityNode entity) {
        switch (entity.getType()) {
            case "Job": {
                return XmlPredicatorService.getEndOfJobPredicate();
            }
            case "Sub Folder": {
                return XmlPredicatorService.getEndOfSubFolderPredicate();
            }
            case "Smart Folder": {
                return XmlPredicatorService.getEndOfSmartFolderPredicate();
            }
            case "Folder": {
                return XmlPredicatorService.getEndOfFolderPredicate();
            }
        }
        throw this.createUnknownEntityError(entity);
    }

    private RuntimeException createUnknownEntityError(EntityNode entity) {
        String errorMessage = String.format("Unknown entity: %s", entity.getPathAsString());
        RuntimeException runtimeException = new RuntimeException(errorMessage);
        ExceptionHandler.writeToExceptionFile((Exception)runtimeException);
        return runtimeException;
    }

    public void readDescendants(XMLEventReader eventReader, EntityNode parentNode) throws XMLStreamException {
        List readers = this.factory.getReaders(parentNode.getDraftEntityImp());
        Predicate<XMLEvent> endEventPredicator = this.getEndOfEntityPredicate(parentNode);
        while (eventReader.hasNext()) {
            for (DraftEntitiesReader reader : readers) {
                reader.read(eventReader);
            }
            XMLEvent event = eventReader.peek();
            this.readerService.read(eventReader, parentNode);
            event = eventReader.nextEvent();
            if (endEventPredicator == null || !endEventPredicator.test(event)) continue;
            this.conditionHandler.readAllEntityConditions(parentNode);
            break;
        }
    }
}

