/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.ReaderHandler;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.draftReader.EntitesCreator;
import com.bmc.toolbox.compare.condition_compare.entitites.Job;
import com.bmc.toolbox.compare.condition_compare.entitites.MyAttribute;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class JobHandler {
    private List<MyAttribute> attributes;
    private EntitesCreator entitesCreator;
    private ReaderHandler readerHandler;

    public JobHandler(List<MyAttribute> attributes, ReaderHandler readerHandler, EntitesCreator entitesCreator) {
        this.attributes = attributes;
        this.entitesCreator = entitesCreator;
        this.readerHandler = readerHandler;
    }

    public Job getJob(XMLEvent jobEvent, DraftPath parent) throws XMLStreamException {
        String jobName = this.getNameJob();
        DraftPath jobPath = new DraftPath(jobName, parent);
        return this.entitesCreator.createJob(jobEvent, jobPath);
    }

    public void setJobOs(EntityNode jobNode) {
        if (this.isMainFrameJob()) {
            jobNode.setOs("Mainframe");
        } else {
            jobNode.setOs("DS");
        }
    }

    private String getNameJob() {
        String jobName = "";
        jobName = this.isMainFrameJob() ? this.readerHandler.getValueFromAttributeList("MEMNAME", this.attributes) : this.readerHandler.getValueFromAttributeList("JOBNAME", this.attributes);
        return jobName;
    }

    private boolean isStringNullOrEmpty(String jobName) {
        return jobName == null || jobName.isEmpty();
    }

    private boolean isMainFrameJob() {
        String jobName = this.readerHandler.getValueFromAttributeList("JOBNAME", this.attributes);
        return this.isStringNullOrEmpty(jobName);
    }
}

