/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GroupsListAssertable
extends ArrayList<Set<EntityNode>> {
    private static final long serialVersionUID = 1L;

    public GroupsListAssertable() {
    }

    public GroupsListAssertable(List<Set<EntityNode>> groupsList) {
        this.addAll(groupsList);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GroupsListAssertable)) {
            return false;
        }
        GroupsListAssertable anotherGroupList = (GroupsListAssertable)object;
        return this.compareGroupsList(anotherGroupList);
    }

    private boolean sameNumberOfGroups(GroupsListAssertable entityGroup) {
        return this.size() == entityGroup.size();
    }

    private boolean compareTwoSets(Set<EntityNode> group1, Set<EntityNode> group2) {
        boolean sameNode = false;
        if (group1.size() != group2.size()) {
            return false;
        }
        for (EntityNode entityNode1 : group1) {
            sameNode = false;
            for (EntityNode entityNode2 : group2) {
                if (!entityNode1.compareParameters(entityNode2)) continue;
                sameNode = true;
                break;
            }
            if (sameNode) continue;
            return false;
        }
        return true;
    }

    private boolean groupListContainsGroup(GroupsListAssertable groupList, Set<EntityNode> group) {
        for (int i = 0; i < groupList.size(); ++i) {
            Set anothergroup = (Set)groupList.get(i);
            if (!this.compareTwoSets(group, anothergroup)) continue;
            return true;
        }
        return false;
    }

    private boolean compareGroupsList(GroupsListAssertable anotherGroupList) {
        if (!this.sameNumberOfGroups(anotherGroupList)) {
            return false;
        }
        for (Set<EntityNode> myGroup : this.getSetList()) {
            if (this.groupListContainsGroup(anotherGroupList, myGroup)) continue;
            return false;
        }
        return true;
    }

    private ArrayList<Set<EntityNode>> getSetList() {
        return this;
    }
}

