/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.ConditionHandler;
import com.bmc.ctmconvert.draftanalyzer.DividorGlobals;
import com.bmc.ctmconvert.draftanalyzer.EntityNode;
import com.bmc.ctmconvert.draftanalyzer.GroupService;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class GroupHandler {
    private List<Set<EntityNode>> groupsList = new ArrayList<Set<EntityNode>>();
    private ConditionHandler conditionHandler;
    private GroupService groupService;

    public GroupHandler(ConditionHandler conditionHandler) {
        this.conditionHandler = conditionHandler;
        this.groupService = new GroupService();
    }

    public GroupService getGroupService() {
        return this.groupService;
    }

    public Set<Set<EntityNode>> getAllGroupsOfEntitiesHasConditionsWith(EntityNode entityNode) {
        return this.groupService.getAllEntitiesGroups(this.getAllCondsEntities(entityNode));
    }

    public List<Set<EntityNode>> getGroupsList() {
        return this.groupsList;
    }

    public Set<Set<EntityNode>> getGroupsSetOfRelatives(EntityNode entity) {
        Set<EntityNode> condGroupList = this.getAllCondsEntities(entity);
        return this.groupService.getGroupsSetOfRelatives(entity, condGroupList);
    }

    public void mergeGroups(Set<Set<EntityNode>> groupsToMerge) {
        HashSet<EntityNode> newGroup = new HashSet<EntityNode>();
        for (Set<EntityNode> group : groupsToMerge) {
            for (EntityNode entityNode : group) {
                entityNode.setGroup(newGroup);
            }
            this.groupsList.remove(group);
        }
        this.groupsList.add(newGroup);
    }

    public void addToGroup(Set<EntityNode> group, Set<EntityNode> entitySet) {
        if (group == null || entitySet == null) {
            return;
        }
        for (EntityNode entityNode : entitySet) {
            entityNode.setGroup(group);
        }
    }

    public void addEntityToGroup(Set<EntityNode> group, EntityNode entity) {
        if (group == null || entity == null) {
            return;
        }
        entity.setGroup(group);
        group.add(entity);
    }

    private void addAllCondtitionedEntitiesToSet(Set<EntityNode> condEntities, Set<String> entityConditions, HashMap<String, List<EntityNode>> draftConditionsMap) {
        for (String conditionName : entityConditions) {
            List<EntityNode> entityList = draftConditionsMap.get(conditionName);
            if (entityList == null) continue;
            condEntities.addAll(entityList);
        }
    }

    public Set<EntityNode> getAllCondsEntities(EntityNode entityNode) {
        HashSet<EntityNode> condsEntities = new HashSet<EntityNode>();
        HashMap<String, List<EntityNode>> draftInConditionsMap = this.conditionHandler.getInConditionMap();
        HashMap<String, List<EntityNode>> draftDoConditionsMap = this.conditionHandler.getOnDoConditionMap();
        HashMap<String, List<EntityNode>> draftOutConditionsMap = this.conditionHandler.getOutConditionMap();
        this.addAllCondtitionedEntitiesToSet(condsEntities, entityNode.getInConditionGroupName(), draftOutConditionsMap);
        this.addAllCondtitionedEntitiesToSet(condsEntities, entityNode.getInConditionGroupName(), draftDoConditionsMap);
        this.addAllCondtitionedEntitiesToSet(condsEntities, entityNode.getOutConditionGroupName(), draftInConditionsMap);
        this.addAllCondtitionedEntitiesToSet(condsEntities, entityNode.getOnDoConditionGroupName(), draftInConditionsMap);
        condsEntities.add(entityNode);
        return condsEntities;
    }

    public void createNewGroup(Set<EntityNode> entityList) {
        HashSet<EntityNode> newGroup = new HashSet<EntityNode>();
        for (EntityNode entityNode : entityList) {
            entityNode.setGroup(newGroup);
        }
        this.groupsList.add(newGroup);
    }

    public void createNewGroup(EntityNode entityNode) {
        HashSet<EntityNode> newGroup = new HashSet<EntityNode>();
        entityNode.setGroup(newGroup);
        this.groupsList.add(newGroup);
    }

    public boolean hasConditions(DraftEntityImp draftEntityImp) {
        return this.conditionHandler.hasConditions(draftEntityImp);
    }

    private Set<EntityNode> getAllRelativeEntities(EntityNode entityNode, Set<EntityNode> conditionedEntities) {
        HashSet<EntityNode> allRelativeEntities = new HashSet<EntityNode>();
        allRelativeEntities.addAll(conditionedEntities);
        allRelativeEntities.addAll(entityNode.getChildrenNodes());
        allRelativeEntities.add(entityNode);
        return allRelativeEntities;
    }

    public void handleEntityGroup(EntityNode entityNode) {
        Set<EntityNode> conditionedEntities = this.getAllCondsEntities(entityNode);
        Set<Set<EntityNode>> groupsContainer = this.groupService.getGroupsSetOfRelatives(entityNode, conditionedEntities);
        Set<EntityNode> relatives = this.getAllRelativeEntities(entityNode, conditionedEntities);
        DividorGlobals.AmountOfGroups amountOfGroups = this.groupService.howManyGroups(groupsContainer);
        switch (amountOfGroups) {
            case None: {
                this.createNewGroup(relatives);
                break;
            }
            case One: {
                for (Set<EntityNode> theOnlyGroup : groupsContainer) {
                    this.addToGroup(theOnlyGroup, relatives);
                }
                break;
            }
            case MoreThenOne: {
                groupsContainer.add(relatives);
                this.mergeGroups(groupsContainer);
            }
        }
    }
}

