/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.draftanalyzer;

import com.bmc.ctmconvert.draftanalyzer.GroupHandler;
import com.bmc.ctmconvert.draftanalyzer.StringService;
import com.bmc.toolbox.compare.condition_compare.DraftEntityImp;
import com.bmc.toolbox.compare.condition_compare.DraftPath;
import com.bmc.toolbox.compare.condition_compare.entitites.Folder;
import com.bmc.toolbox.compare.condition_compare.entitites.Job;
import com.bmc.toolbox.compare.condition_compare.entitites.SmartFolder;
import com.bmc.toolbox.compare.condition_compare.entitites.SubFolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class EntityNode
implements Comparable<EntityNode> {
    private DraftEntityImp draftEntityImp;
    private DraftPath draftPath;
    private List<EntityNode> childrenNodes;
    private EntityNode parentNode;
    private Set<EntityNode> nodeGroup;
    private String osType;
    private GroupHandler groupHandler;
    private String entityType;

    public EntityNode(DraftEntityImp draftEntityImp, EntityNode parentNode) {
        this.setup(draftEntityImp, parentNode);
    }

    public EntityNode(DraftEntityImp draftEntityImp) {
        this.setup(draftEntityImp, null);
    }

    public void setGroupHandler(GroupHandler groupHandler) {
        this.groupHandler = groupHandler;
        for (EntityNode entityNode : this.childrenNodes) {
            entityNode.setGroupHandler(groupHandler);
        }
    }

    public GroupHandler getGroupHandler() {
        return this.groupHandler;
    }

    public DraftPath getDraftPath() {
        return this.draftPath;
    }

    private void setup(DraftEntityImp draftEntityImp, EntityNode parentNode) {
        this.draftPath = draftEntityImp.getPath();
        this.parentNode = parentNode;
        this.nodeGroup = null;
        this.draftEntityImp = draftEntityImp;
        this.childrenNodes = new ArrayList<EntityNode>();
        this.setType();
        this.osType = this.parentNode != null ? parentNode.getOsType() : "DS";
    }

    public EntityNode getParentNode() {
        return this.parentNode;
    }

    public Set<String> getInConditionGroupName() {
        return this.draftEntityImp.getInConditionGroupName();
    }

    public Set<String> getOutConditionGroupName() {
        return this.draftEntityImp.getOutConditionGroupName();
    }

    public Set<String> getOnDoConditionGroupName() {
        return this.draftEntityImp.getOnDoConditionGroupName();
    }

    public void setOs(String osType) {
        this.osType = osType;
    }

    public void addChild(EntityNode childNode) {
        if (childNode != null) {
            this.childrenNodes.add(childNode);
        }
    }

    private boolean isParentOf(List<String> inputSplitPath) {
        if (!this.isSameBranch(inputSplitPath)) {
            return false;
        }
        int depth = this.draftPath.getDepth();
        ArrayList splitedPath = new ArrayList(this.draftPath.getPaths());
        return inputSplitPath.get(depth - 1).equals(splitedPath.get(depth - 1));
    }

    private boolean isSameBranch(List<String> inputSplitPath) {
        return this.draftPath.getDepth() < inputSplitPath.size();
    }

    public EntityNode getEntityByPath(String inputPath) {
        List<String> inputSplitPath = StringService.getPathAsList(inputPath);
        if (inputPath.equals(this.draftPath.getPath())) {
            return this;
        }
        if (this.isParentOf(inputSplitPath)) {
            for (EntityNode entityNode : this.childrenNodes) {
                EntityNode result = null;
                result = entityNode.getEntityByPath(inputPath);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public DraftEntityImp getDraftEntityImp() {
        return this.draftEntityImp;
    }

    public String getType() {
        return this.entityType;
    }

    public void setType() {
        if (this.draftEntityImp instanceof SmartFolder) {
            this.entityType = "Smart Folder";
            return;
        }
        if (this.draftEntityImp instanceof Job) {
            this.entityType = "Job";
            return;
        }
        if (this.draftEntityImp instanceof SubFolder) {
            this.entityType = "Sub Folder";
            return;
        }
        if (this.draftEntityImp instanceof Folder) {
            this.entityType = "Folder";
            return;
        }
        this.entityType = "Unknown";
    }

    public List<EntityNode> getChildrenNodes() {
        return this.childrenNodes;
    }

    public Set<EntityNode> getGroup() {
        return this.nodeGroup;
    }

    public void setGroup(Set<EntityNode> group) {
        if (group != null) {
            this.nodeGroup = group;
            group.add(this);
        }
    }

    private void divideChildren() {
        for (EntityNode entityNode : this.childrenNodes) {
            entityNode.divide();
        }
    }

    private Set<EntityNode> getParentGroup() {
        return this.groupHandler.getGroupService().getEntityGroup(this.parentNode);
    }

    public void divide() {
        boolean parentHasGroup;
        Set<EntityNode> parentGroup = this.getParentGroup();
        boolean isLeaf = this.isLeaf();
        boolean hasConditions = this.groupHandler.hasConditions(this.draftEntityImp);
        boolean bl = parentHasGroup = parentGroup != null;
        if (hasConditions) {
            this.groupHandler.handleEntityGroup(this);
            this.divideChildren();
            return;
        }
        if (isLeaf && parentHasGroup && !hasConditions) {
            this.setGroup(parentGroup);
            return;
        }
        if (!isLeaf && !hasConditions) {
            this.setGroup(parentGroup);
            this.divideChildren();
            return;
        }
        if (isLeaf && !parentHasGroup && !hasConditions) {
            this.groupHandler.createNewGroup(this);
            return;
        }
    }

    private boolean isLeaf() {
        return this.childrenNodes.isEmpty();
    }

    public int getDepth() {
        return this.draftPath.getDepth();
    }

    public String getPathAsString() {
        return this.draftPath.getPath();
    }

    public String getOsType() {
        return this.osType;
    }

    public boolean compareParameters(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof EntityNode)) {
            return false;
        }
        EntityNode entity = (EntityNode)object;
        return this.compareNode(entity);
    }

    private boolean innerComparison(EntityNode entity) {
        if (!this.draftPath.getPath().equals(entity.getPathAsString())) {
            return false;
        }
        if (!this.entityType.equals(entity.getType())) {
            return false;
        }
        return this.osType.equals(entity.getOsType());
    }

    private boolean compareNode(EntityNode entity) {
        EntityNode temp = null;
        if (!this.innerComparison(entity)) {
            return false;
        }
        if (this.childrenNodes.size() != entity.getChildrenNodes().size()) {
            return false;
        }
        for (EntityNode childNode : this.childrenNodes) {
            temp = null;
            temp = entity.getEntityByPath(childNode.getPathAsString());
            if (temp != null) {
                if (childNode.compareNode(temp)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "EntityNode [path=" + this.draftPath.getPath() + "]";
    }

    @Override
    public int compareTo(EntityNode o) {
        return this.equals(o) ? 0 : this.hashCode() - o.hashCode();
    }
}

