/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CalendarXmlElement;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CtmCalendarsHandler;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CtmDataParser;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CtmDataUpdater;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.CtmDataWriter;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcReportHandler;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.RbcUpdater;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UniqueCalendarsWriter;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UniqueRbcCollector;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UniqueRegularCalendarCollector;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UtilityStreamRepository;
import com.bmc.ctmconvert.common.log.Logger;
import com.bmc.ctmconvert.common.xml.XmlElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UtilityRunner {
    private static final String CREATING_REPORT = "\nCreating report ...";
    private static final String UPDATING_CTM_DATA = "\nUpdating CtmData ...";
    private static final String UPDATING_CALENDARS = "Updating Calendars ...";

    public void run(UtilityStreamRepository streamRepository) throws Exception {
        try {
            Logger.getLogger().setOutputStream(streamRepository.getLogOutputStream());
            System.out.println(UPDATING_CALENDARS);
            Map.Entry<Map<CalendarXmlElement, List<String>>, Map<XmlElement, List<String>>> uniqueCalendarsMap = this.updateCalendars(streamRepository);
            Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap = uniqueCalendarsMap.getKey();
            Map<XmlElement, List<String>> uniqueRegularCalendarsMap = uniqueCalendarsMap.getValue();
            System.out.println(UPDATING_CTM_DATA);
            this.updateCtmData(streamRepository, uniqueRuleBasedCalendarsMap, uniqueRegularCalendarsMap);
            System.out.println(CREATING_REPORT);
            this.createReport(streamRepository, uniqueRuleBasedCalendarsMap, uniqueRegularCalendarsMap);
            System.out.println(String.format("RBC's distribution report was created successfully in %s", streamRepository.getReportPath()));
        }
        catch (DuplicateRbcException e) {
            System.out.println(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            Logger.getLogger().writeToLog(e);
            throw e;
        }
        finally {
            streamRepository.closeStreams();
        }
    }

    private void createReport(UtilityStreamRepository streamRepository, Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap, Map<XmlElement, List<String>> uniqueRegularCalendarsMap) throws IOException {
        DuplicateRbcReportHandler duplicateRbcReoprtHandler = new DuplicateRbcReportHandler(uniqueRuleBasedCalendarsMap, uniqueRegularCalendarsMap);
        duplicateRbcReoprtHandler.writeReport(streamRepository.getReportOutputStream());
    }

    private void updateCtmData(UtilityStreamRepository streamRepository, Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap, Map<XmlElement, List<String>> uniqueRegularCalendarsMap) throws DuplicateRbcException, IOException {
        CtmDataParser ctmDataParser = new CtmDataParser();
        ctmDataParser.parse(streamRepository.getCtmDataInputStream());
        List<XmlElement> folders = ctmDataParser.getFolders();
        RbcUpdater rbcUpdater = new RbcUpdater(uniqueRuleBasedCalendarsMap, uniqueRegularCalendarsMap);
        CtmDataUpdater ctmDataRbcUpdater = new CtmDataUpdater(folders);
        List<XmlElement> updatedFolders = ctmDataRbcUpdater.update(rbcUpdater);
        CtmDataWriter ctmDataWriter = new CtmDataWriter();
        OutputStream xmlOutputStream = streamRepository.getCtmDataOutputStream();
        ctmDataWriter.writeCtmData(updatedFolders, ctmDataParser, xmlOutputStream);
        System.out.println(String.format("Updated CtmData file was created successfully in %s", streamRepository.getUpdatedCtmDataPath()));
    }

    private Map.Entry<Map<CalendarXmlElement, List<String>>, Map<XmlElement, List<String>>> updateCalendars(UtilityStreamRepository streamRepository) throws DuplicateRbcException, IOException {
        CtmCalendarsHandler ctmCalendarsHandler = new CtmCalendarsHandler();
        InputStream calendarInputStream = streamRepository.getCalendarInputStream();
        ctmCalendarsHandler.read(calendarInputStream);
        UniqueRbcCollector uniqueRbcCollector = ctmCalendarsHandler.getUniqueRbcCollector();
        Map<CalendarXmlElement, List<String>> uniqueRuleBasedCalendarsMap = uniqueRbcCollector.getUniqueCalendarsMap();
        UniqueRegularCalendarCollector uniqueRegularCalendarCollector = ctmCalendarsHandler.getUniqueRegularCalendarCollector();
        Map<XmlElement, List<String>> uniqueRegularCalendarsMap = uniqueRegularCalendarCollector.getUniqueCalendarsMap();
        ArrayList<XmlElement> regularCalendarList = new ArrayList<XmlElement>(uniqueRegularCalendarsMap.keySet());
        UniqueCalendarsWriter calendarsWriter = new UniqueCalendarsWriter();
        ArrayList<XmlElement> uniqueRbcList = new ArrayList<XmlElement>(uniqueRuleBasedCalendarsMap.keySet());
        calendarsWriter.writeUniqueCalendars(uniqueRbcList, ctmCalendarsHandler.getCalendarsParser(), streamRepository.getCalendersOutputStream(), regularCalendarList);
        System.out.println(String.format("Updated Calendars file was created successfully in %s", streamRepository.getUpdatedCalendersPath()));
        return Map.entry(uniqueRuleBasedCalendarsMap, uniqueRegularCalendarsMap);
    }
}

