/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.calendars.find.duplicate.rbcs;

import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.ArgumentParser;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.DuplicateRbcException;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UtilityRunner;
import com.bmc.ctmconvert.calendars.find.duplicate.rbcs.UtilityStreamRepository;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.ParseException;
import org.xml.sax.SAXException;

public class Main {
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        System.out.println("Running CalendarsDuplicatesRemoval ...\r\n");
        ArgumentParser argumentParser = new ArgumentParser();
        UtilityStreamRepository streamRepository = null;
        try {
            argumentParser.parse(args);
            streamRepository = new UtilityStreamRepository(argumentParser);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            System.out.println("The CalendarsDuplicatesRemoval utility uses Control-M calendar and data xml files as input files (created by the Conversion Tool or exported from Control-M),  \r\nremoves all identical Control-M Rule Based Calendars (RBCs), and updates the Control-M data, which references the remaining RBCs.\r\n\r\nWhen completed, the following files are created:\r\n-\tupdateCalendars.xml: Contains the remaining RBCs.\r\n-\tupdateCtmData.xml: Contains the updated Control-M data with new references to the remaining RBCs.\r\n-\tcalDuplicatesRemovalReport.xlsx: Contains a list of the names of the remaining RBCs and the names of the RBCs that have been removed.\r\n\r\nUsage: CalendarsDuplicatesRemoval\r\n        -calendarFile < Mandatory. Path to the Control-M calendar xml file >\r\n        -ctmData < Mandatory. Path to the Control-M data that contains the input calendars file references > \r\n        [ -outputDirectory <Optional. Path to the directory where CalendarsDuplicatesRemoval outputs will be created > ]\r\n");
            return;
        }
        catch (DuplicateRbcException e) {
            System.out.println(e.getMessage());
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String pathsUsedDescription = streamRepository.getPathsUsedDescription();
        System.out.println(pathsUsedDescription);
        UtilityRunner runner = new UtilityRunner();
        try {
            runner.run(streamRepository);
        }
        catch (Exception e) {
            String generalErrorMessage = String.format("Utility ended with errors, for more information, see %s", streamRepository.getLogFilePath());
            System.out.println(generalErrorMessage);
            return;
        }
        System.out.println("Utility ended successfully.");
    }
}

