/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.ConversionContext;
import com.bmc.ctmconvert.base.BaseProgressBar;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.convertor.Convertor;
import com.bmc.ctmconvert.getter.CtmEntityGetter;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.redwoodbpa.RedwoodBPAAssessmentReport;
import com.bmc.ctmconvert.redwoodbpa.RedwoodBPAEntityMapper;
import com.bmc.ctmconvert.redwoodbpa.convertor.InputXmlData;
import com.bmc.ctmconvert.redwoodbpa.convertor.InputXmlDataKt;
import com.bmc.ctmconvert.redwoodbpa.convertor.RedwoodBpaConvertor;
import com.bmc.ctmconvert.redwoodbpa.convertor.steps.ConversionStepsOrder;
import com.bmc.ctmconvert.redwoodbpa.dataimport.ImportedFiles;
import com.bmc.ctmconvert.redwoodbpa.dataimport.RedwoodBPADataImporter;
import com.bmc.ctmconvert.redwoodbpa.dataimport.cli.CliImporterRedwoodBPA;
import com.bmc.ctmconvert.redwoodbpa.dataimport.gui.GUIRedwoodBPADataImporter;
import com.bmc.ctmconvert.redwoodbpa.rules.RedwoodBPARulesProvider;
import com.bmc.ctmconvert.scriptelement.CtmWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.sourceDefinitions.GeneralSourceDefinitions;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007H\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\"\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0018\u001a\u00020\u001aJ\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R \u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006("}, d2={"Lcom/bmc/ctmconvert/AppData;", "Lcom/bmc/ctmconvert/interfaces/VendorData;", "fileSystem", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/nio/file/FileSystem;)V", "getName", "", "getDisplayName", "getVendorType", "Lcom/bmc/ctmconvert/interfaces/VendorData$VendorType;", "getDataImport", "Lcom/bmc/ctmconvert/redwoodbpa/dataimport/gui/GUIRedwoodBPADataImporter;", "getCLIImporter", "Lcom/bmc/ctmconvert/redwoodbpa/dataimport/cli/CliImporterRedwoodBPA;", "importer", "Lcom/bmc/ctmconvert/redwoodbpa/dataimport/RedwoodBPADataImporter;", "getImporter", "()Lcom/bmc/ctmconvert/redwoodbpa/dataimport/RedwoodBPADataImporter;", "importer$delegate", "Lkotlin/Lazy;", "getAssessmentReport", "Lcom/bmc/ctmconvert/redwoodbpa/RedwoodBPAAssessmentReport;", "path", "rulesProvider", "Lkotlin/Function0;", "Lcom/bmc/ctmconvert/redwoodbpa/rules/RedwoodBPARulesProvider;", "getRulesProvider", "()Lkotlin/jvm/functions/Function0;", "setRulesProvider", "(Lkotlin/jvm/functions/Function0;)V", "getSourceDefinition", "Lcom/bmc/ctmconvert/workspace/sourceDefinitions/GeneralSourceDefinitions;", "progressBar", "Lcom/bmc/ctmconvert/base/BaseProgressBar;", "createSourceDefinition", "importedFiles", "Lcom/bmc/ctmconvert/redwoodbpa/dataimport/ImportedFiles;", "getRulesResourceFile", "Ljava/io/InputStream;", "Scheduler-Redwood-BPA"})
public final class AppData
implements VendorData {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Lazy importer$delegate;
    @NotNull
    private Function0<RedwoodBPARulesProvider> rulesProvider;

    public AppData(@NotNull FileSystem fileSystem) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        this.fileSystem = fileSystem;
        this.importer$delegate = LazyKt.lazy(AppData::importer_delegate$lambda$0);
        this.rulesProvider = AppData::rulesProvider$lambda$1;
    }

    public /* synthetic */ AppData(FileSystem fileSystem, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fileSystem = FileSystems.getDefault();
        }
        this(fileSystem);
    }

    @NotNull
    public String getName() {
        return "Redwood_BPA";
    }

    @NotNull
    public String getDisplayName() {
        return "Redwood";
    }

    @NotNull
    public VendorData.VendorType getVendorType() {
        return VendorData.VendorType.Schedulers;
    }

    @NotNull
    public GUIRedwoodBPADataImporter getDataImport() {
        return GUIRedwoodBPADataImporter.Companion.create$default(GUIRedwoodBPADataImporter.Companion, null, null, 3, null);
    }

    @NotNull
    public CliImporterRedwoodBPA getCLIImporter() {
        return new CliImporterRedwoodBPA(null, 1, null);
    }

    private final RedwoodBPADataImporter getImporter() {
        Lazy lazy = this.importer$delegate;
        return (RedwoodBPADataImporter)lazy.getValue();
    }

    @NotNull
    public RedwoodBPAAssessmentReport getAssessmentReport(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new RedwoodBPAAssessmentReport(path, this.getImporter());
    }

    @NotNull
    public final Function0<RedwoodBPARulesProvider> getRulesProvider() {
        return this.rulesProvider;
    }

    public final void setRulesProvider(@NotNull Function0<RedwoodBPARulesProvider> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.rulesProvider = function0;
    }

    @NotNull
    public GeneralSourceDefinitions getSourceDefinition(@Nullable BaseProgressBar progressBar) {
        RedwoodBPADataImporter redwoodBPADataImporter = this.getImporter();
        Path path = this.fileSystem.getPath(Params.instance().getDatasourcePath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        return this.createSourceDefinition(redwoodBPADataImporter.readFolders(path), progressBar, (RedwoodBPARulesProvider)this.rulesProvider.invoke());
    }

    @NotNull
    public final GeneralSourceDefinitions createSourceDefinition(@NotNull ImportedFiles importedFiles, @Nullable BaseProgressBar progressBar, @NotNull RedwoodBPARulesProvider rulesProvider) {
        Intrinsics.checkNotNullParameter((Object)importedFiles, (String)"importedFiles");
        Intrinsics.checkNotNullParameter((Object)rulesProvider, (String)"rulesProvider");
        CtmWorkspace ctmWorkspace = new CtmWorkspace(new Workspace(), (CtmEntityGetter)new RedwoodBPAEntityMapper());
        InputXmlData inputXmlData = InputXmlDataKt.asXmlElements(importedFiles);
        Optional<BaseProgressBar> optional = Optional.ofNullable(progressBar);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        ConversionContext conversionContext = new ConversionContext(ctmWorkspace, inputXmlData, optional, rulesProvider, null, null, null, 112, null);
        RedwoodBpaConvertor convertor = new RedwoodBpaConvertor(conversionContext, ConversionStepsOrder.Companion.getConversionSteps());
        return new GeneralSourceDefinitions((Convertor)convertor, (IWorkspace)conversionContext.getWorkspace().getWorkspace());
    }

    public static /* synthetic */ GeneralSourceDefinitions createSourceDefinition$default(AppData appData, ImportedFiles importedFiles, BaseProgressBar baseProgressBar, RedwoodBPARulesProvider redwoodBPARulesProvider, int n, Object object) {
        if ((n & 2) != 0) {
            baseProgressBar = null;
        }
        return appData.createSourceDefinition(importedFiles, baseProgressBar, redwoodBPARulesProvider);
    }

    @NotNull
    public InputStream getRulesResourceFile() {
        InputStream inputStream = this.getClass().getResourceAsStream("/rules.xml");
        Intrinsics.checkNotNull((Object)inputStream);
        return inputStream;
    }

    private static final RedwoodBPADataImporter importer_delegate$lambda$0() {
        return new RedwoodBPADataImporter(null, 1, null);
    }

    private static final RedwoodBPARulesProvider rulesProvider$lambda$1() {
        return new RedwoodBPARulesProvider(null, 1, null);
    }

    public AppData() {
        this(null, 1, null);
    }
}

