/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.scripts;

import com.bmc.ctmconvert.uc4.IUC4Job;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.scripts.ActionHandler;
import com.bmc.ctmconvert.uc4.scripts.IScriptActionGetter;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;

public class ScriptHandler
implements IScriptHandler {
    private final IScriptActionGetter actionGetter;

    public ScriptHandler(IScriptActionGetter uc4PreScriptGetter) {
        this.actionGetter = uc4PreScriptGetter;
    }

    @Override
    public void handleScript(IUC4Job uc4Job, String script) {
        ActionHandler handler = this.handler(uc4Job, script);
        if (handler != null) {
            handler.convert(uc4Job, script);
        } else {
            ActionHandler defaultAction = this.actionGetter.getDefaultAction();
            defaultAction.convert(uc4Job, script);
        }
    }

    @Override
    public boolean hasHandler(IUC4Job uc4Job, String script) {
        ActionHandler handler = this.handler(uc4Job, script);
        return handler != null && handler.getClass() != this.actionGetter.getDefaultAction().getClass();
    }

    private ActionHandler handler(IUC4Job uc4Job, String script) {
        UC4Globals.OS_TYPE osType = uc4Job.isDSJob() ? UC4Globals.OS_TYPE.OS_TYPE_DS : UC4Globals.OS_TYPE.OS_TYPE_MF;
        return this.actionGetter.get(script, osType, uc4Job.getObj().getFullType());
    }
}

