/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.uc4.research.KeyWordGetter;
import com.bmc.ctmconvert.uc4.research.handlers.KeyWord;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SetPattern
implements KeyWordGetter {
    private static final String functionGroup = "functionGroup";
    static String keyWordGruop = "keyword";
    private static String var = "&.*#?";
    Pattern functionPattern = Pattern.compile("^\\s*:\\s*(?<" + keyWordGruop + ">.*?)\\s+" + var + "=\\s*(?<functionGroup>.*?)\\(.*\\)\\s*.*");
    Pattern simpleSetPattern = Pattern.compile("^\\s*:\\s*(?<" + keyWordGruop + ">.*?)\\s+" + var + "=\\s*'.*'");
    Pattern singlePattern = Pattern.compile("^\\s*:\\s*(?<" + keyWordGruop + ">.*?)((\\s+.*)$|$)");

    @Override
    public Optional<KeyWord> getKeyWord(String keyWordLine) {
        Matcher simpleMatcher = this.simpleSetPattern.matcher(keyWordLine);
        if (simpleMatcher.find()) {
            String keyWordName = simpleMatcher.group(keyWordGruop);
            keyWordName = keyWordName.toLowerCase();
            KeyWord ret = new KeyWord(keyWordName);
            return Optional.of(ret);
        }
        Matcher functionMatcher = this.functionPattern.matcher(keyWordLine);
        if (functionMatcher.find()) {
            String keyWordName = functionMatcher.group(keyWordGruop);
            String function = functionMatcher.group(functionGroup).toLowerCase();
            keyWordName = keyWordName.toLowerCase();
            KeyWord ret = new KeyWord(keyWordName + "-" + function);
            return Optional.of(ret);
        }
        Matcher singleMatcher = this.singlePattern.matcher(keyWordLine);
        if (singleMatcher.find()) {
            String keyWordName = singleMatcher.group(keyWordGruop);
            keyWordName = keyWordName.toLowerCase();
            KeyWord ret = new KeyWord(keyWordName);
            return Optional.of(ret);
        }
        return Optional.empty();
    }

    public boolean hasMatch(String line) {
        Matcher matcher = this.functionPattern.matcher(line);
        return matcher.find();
    }
}

