/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.research.KeyWordPattern;
import com.bmc.ctmconvert.uc4.research.ScriptDetails;
import com.bmc.ctmconvert.uc4.research.group_key_words.PatternKeyWordFinder;
import com.bmc.ctmconvert.uc4.xmlJobs.XmlElementHandler;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Stream;

public class ScriptReader
implements XmlElementHandler {
    private static final String MSCRI = "MSCRI";
    private final PatternKeyWordFinder scriptHandler;
    List<String> unsupportedPluginTypes = Stream.of(UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_OS400, UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_SQL, UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_MVS, UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_PS, UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_R3, UC4Globals.SUPPORTED_JOBS_TYPES.JOBS_CIT).map(Object::toString).toList();

    public ScriptReader(PatternKeyWordFinder scriptHandler) {
        this.scriptHandler = scriptHandler;
    }

    @Override
    public void handleElement(XmlElement jobsElement) {
        String jobType = jobsElement.getTagName();
        String jobName = jobsElement.getAttribute("name");
        if (this.unsupportedPluginTypes.contains(jobType)) {
            return;
        }
        List scripts = jobsElement.getAllDecnedElementByName(MSCRI);
        for (XmlElement script : scripts) {
            String scriptValue = script.getCData();
            ScriptDetails scriptDetails = ScriptDetails.of(jobName, jobType, scriptValue);
            this.scriptHandler.handleScript(scriptDetails);
        }
    }

    public void forEachScript(BiConsumer<KeyWordPattern, List<ScriptDetails>> multiConsumer) {
        this.scriptHandler.forEachScript(multiConsumer);
    }
}

