/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.research;

import com.bmc.ctmconvert.uc4.research.handlers.KeyWord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class KeyWordPattern {
    private List<KeyWord> keyWords;

    public KeyWordPattern(List<KeyWord> keyWords) {
        this.keyWords = keyWords;
    }

    public String toString() {
        return "KeyWordPattern [keyWords=" + String.valueOf(this.keyWords) + "]";
    }

    public List<String> getKeyWords() {
        List<String> ret = new ArrayList<KeyWord>(this.keyWords).stream().map(keyword -> keyword.getKeyWordName()).collect(Collectors.toList());
        return ret;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyWords == null ? 0 : this.keyWords.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyWordPattern other = (KeyWordPattern)obj;
        return !(this.keyWords == null ? other.keyWords != null : !this.keyWords.equals(other.keyWords));
    }

    public static KeyWordPattern createPattern(List<String> asList) {
        return new KeyWordPattern(asList.stream().map(str -> new KeyWord((String)str)).collect(Collectors.toList()));
    }

    public static KeyWordPattern from(String ... keyWord) {
        return KeyWordPattern.createPattern(Arrays.asList(keyWord));
    }
}

