/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.jobTypes;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.entities.Attribute;
import com.bmc.ctmconvert.uc4.CmConvertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.jobTypes.MVSConvertorFactory;
import com.bmc.ctmconvert.uc4.jobTypes.MvsAttributes;
import com.bmc.ctmconvert.uc4.jobTypes.MvsFileName;
import java.util.List;
import java.util.Optional;

public class MemeberMvsConvertor
implements CmConvertor {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        RealConvertor convertor = new RealConvertor(this, uc4Job);
        convertor.convertMvsAttributes();
        convertor.convertMemNameAndMemLib();
    }

    public static boolean isMemeberMvs(XmlElement mvsAttrElement) {
        boolean isMemeberMvs = MVSConvertorFactory.isMvsType(mvsAttrElement, "MVS_TypeMVS");
        return isMemeberMvs;
    }

    public class RealConvertor {
        private UC4Job uc4Job;
        private XmlElement mvsAttrElement;

        public RealConvertor(MemeberMvsConvertor this$0, UC4Job uc4Job) {
            this.uc4Job = uc4Job;
            XmlElement jobElement = uc4Job.getJobXmlElement();
            this.mvsAttrElement = jobElement.getFirstChildElementByName("ATTR_MVS");
        }

        public void convertMvsAttributes() {
            XmlElement jobXmlElement = this.uc4Job.getJobXmlElement();
            MvsAttributes mvsAttributes = new MvsAttributes(jobXmlElement, this.uc4Job);
            List<Attribute> attributes = mvsAttributes.getAttributes();
            this.uc4Job.addAllAttrubtes(attributes);
            for (Attribute attribute : attributes) {
                this.uc4Job.addAttribute(attribute);
            }
        }

        public void convertMemNameAndMemLib() {
            String libName;
            String mvsFileNameStr = this.mvsAttrElement.getValueOfFirstChildElementByName("MVS_FileName");
            MvsFileName mvsFileName = new MvsFileName();
            String fileName = mvsFileName.getFileName(mvsFileNameStr).orElse(mvsFileName.removeQuotes(mvsFileNameStr));
            Optional<String> library = mvsFileName.getLibrary(mvsFileNameStr);
            String string = libName = library.isPresent() ? library.get() : "GENERAL";
            if (!library.isPresent()) {
                String originalJobName = this.uc4Job.getOriginalJobName();
                String jobName = this.uc4Job.getJobName();
                this.uc4Job.addMessage("WRN8049", originalJobName, jobName);
            }
            Attribute memLib = new Attribute("MEMLIB", libName);
            Attribute memName = new Attribute("MEMNAME", fileName);
            this.uc4Job.addAttribute(memLib);
            this.uc4Job.addAttribute(memName);
        }
    }
}

