/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.cm.cit;

import com.bmc.ctmconvert.uc4.CITConvertor;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.handlers.variables.PromptsetVariablesResolver;
import java.util.Map;
import java.util.Optional;

public class CITOEBSConvertor
implements CITConvertor {
    @Override
    public void convertToCm(UC4Job uc4Job) {
        RealConvertor convertor = new RealConvertor(this, uc4Job);
        convertor.addOEBSAttributes();
        convertor.addOEBSVariables();
        this.addConvertedtoDummyMessage(uc4Job);
    }

    private void addConvertedtoDummyMessage(UC4Job uc4Job) {
        String originalJobName = uc4Job.getOriginalJobName();
        String jobName = uc4Job.getJobName();
        uc4Job.addMessage("WRN8061", originalJobName, jobName);
    }

    private class RealConvertor {
        private UC4Job uc4Job;
        private PromptsetVariablesResolver prompsetVariablesResolver;
        private Map<String, String> citComponentXmlName2Value;

        public RealConvertor(CITOEBSConvertor cITOEBSConvertor, UC4Job uc4Job) {
            this.uc4Job = uc4Job;
            this.prompsetVariablesResolver = uc4Job.getPrompsetVariablesResolver();
            this.citComponentXmlName2Value = cITOEBSConvertor.getCitXmlElementMap(uc4Job);
        }

        public void addOEBSAttributes() {
            this.uc4Job.addAttribute("APPL_TYPE", "OEBS");
            this.uc4Job.addAttribute("APPL_VER", "9.0.00.000");
            this.uc4Job.addAttribute("APPL_FORM", "OEBS");
            this.uc4Job.addAttribute("CM_VER", "9.0.00.000");
            this.uc4Job.addAttribute("TASKTYPE", "Job");
        }

        public void addOEBSVariables() {
            String program = this.getValueOrEmpty("program");
            String programName = this.getXmlValue(program);
            this.uc4Job.addVariable("%%OAP-PROGNAME", programName);
            String childWait = this.getValueOrEmpty("childWait");
            childWait = childWait.equals("true") ? "Y" : "N";
            this.uc4Job.addVariable("%%OAP-WAITCHILD", childWait);
            String operatingUnit = this.getValueOrEmpty("operatingUnit");
            if (operatingUnit.isEmpty()) {
                this.uc4Job.addVariable("%%OAP-HAS_OPERATING_UNIT", "N");
            } else {
                this.uc4Job.addVariable("%%OAP-HAS_OPERATING_UNIT", "Y");
            }
            this.uc4Job.addVariable("%%OAP-OPERATING_UNIT", operatingUnit);
            String appShortName = this.getValueOrEmpty("appShortName");
            this.uc4Job.addVariable("%%OAP-APPNAME", appShortName);
            String programDesc = this.getValueOrEmpty("programDesc");
            this.uc4Job.addVariable("%%OAP-PROGDESP", programDesc);
            String responsibility = this.getValueOrEmpty("responsibility");
            this.uc4Job.addVariable("%%OAP-RESPNAME", responsibility);
            this.uc4Job.addVariable("%%OAP-RESPAPP", "SYSADMIN");
            String saveOutput = this.getValueOrEmpty("saveOutput");
            this.uc4Job.addVariable("%%OAP-DISPLAY_LOGFILE", saveOutput);
            this.uc4Job.addVariable("%%OAP-DISPLAY_OUTPUT", saveOutput);
            String securityGroup = this.getValueOrEmpty("securityGroup");
            if (securityGroup.isEmpty()) {
                this.uc4Job.addVariable("%%OAP-SECURITY_GROUPNAME", "Standard");
            }
            String username = this.getValueOrEmpty("userName");
            this.uc4Job.addVariable("%%OAP-USERNAME", username);
            String warningEndOk = this.getValueOrEmpty("warningEndOk");
            warningEndOk = warningEndOk.equals("true") ? "Y" : "N";
            this.uc4Job.addVariable("%%OAP-CONVERT_WARNING2OK", warningEndOk);
            String xmlLanguage = this.getValueOrEmpty("xmlLanguage");
            this.uc4Job.addVariable("%%OAP-LOUT-P001-LANG", xmlLanguage);
            String xmlOutputFormat = this.getValueOrEmpty("xmlOutputFormat");
            this.uc4Job.addVariable("%%OAP-LOUT-P001-TYPE", xmlOutputFormat);
            String xmlTemplate = this.getValueOrEmpty("xmlTemplate");
            this.uc4Job.addVariable("%%OAP-LOUT-P001-NAME", xmlTemplate);
            String language = this.getValueOrEmpty("language");
            this.uc4Job.addVariable("%%OAP-LANGUAGE", language);
            String copies = this.getValueOrEmpty("copies");
            this.uc4Job.addVariable("%%OAP-PRINTERS-P001-VALUE", copies);
            String printer = this.getValueOrEmpty("printer");
            this.uc4Job.addVariable("%%OAP-PRINTERS-P001-NAME", printer);
            String printerStyle = this.getValueOrEmpty("printerStyle");
            this.uc4Job.addVariable("%%OAP-PRINTSTYLE", printerStyle);
            this.uc4Job.addVariable("%%OAP-PARAM_VALIDATION", "Y");
            this.uc4Job.addVariable("%%OAP-TASKTYPE", "REQUEST");
            this.uc4Job.addVariable("%%OAP-INSTANCE", "OEBS_CONNECTION_PROFILE");
        }

        private String getXmlValue(String varValue) {
            Optional<String> optThreads;
            if (this.prompsetVariablesResolver.isVariableName(varValue) && (optThreads = this.prompsetVariablesResolver.getVariableValue(varValue)).isPresent()) {
                varValue = optThreads.get();
            }
            return varValue;
        }

        private String getValueOrEmpty(String key) {
            String value = this.citComponentXmlName2Value.get(key);
            if (value == null) {
                value = "";
            }
            return value;
        }
    }
}

