/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4.XML;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLStructureNode {
    private String entityName;
    private final String name;
    private final List<String> attributes = new ArrayList<String>();
    private final List<XMLStructureNode> childs = new ArrayList<XMLStructureNode>();
    private boolean isMulti = false;
    private String multiName = null;
    private String multiIdAttr = null;
    private final List<String> multiIdAttrList = new ArrayList<String>();
    private boolean hasMultiId = false;
    private boolean needMultiId = false;
    private String multiIdName = null;
    private final Map<String, String> multiIdNames = new HashMap<String, String>();
    private String rootNameAttribute = null;
    private String csvName = null;
    private boolean checkForChildren = false;
    private String checkForChildrenAttrName;
    public static final String ROOT_NODE_NAME = "root";
    public static final String FILE_NAME = "FileName";
    public static final String ATTRIBUTES_HEADER_NAME_FORMAT = "%s_%s";
    public static final String COLLECTION_NAME_FORMAT = "%s_%s";

    public XMLStructureNode(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void addAttribute(String attribute) {
        this.attributes.add(attribute);
    }

    public List<String> getAttributes() {
        return this.attributes;
    }

    public void addChild(XMLStructureNode node) {
        this.childs.add(node);
    }

    public List<XMLStructureNode> getChilds() {
        return this.childs;
    }

    public boolean hasChild() {
        return !this.childs.isEmpty();
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public void setIsMulti(boolean isMulti) {
        this.isMulti = isMulti;
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public void setCheckForChildrenAttrName(String checkForChildrenAttrName) {
        this.checkForChildrenAttrName = checkForChildrenAttrName;
    }

    public String getCheckForChildrenAttrName() {
        return this.checkForChildrenAttrName;
    }

    public void setCheckForChildren(boolean checkForChildren) {
        this.checkForChildren = checkForChildren;
    }

    public boolean checkForChildren() {
        return this.checkForChildren;
    }

    public String getRootAttribute() {
        return this.rootNameAttribute;
    }

    public String getMultiName() {
        return this.multiName != null ? this.multiName : this.name;
    }

    public void setMultiName(String multiName) {
        this.multiName = multiName;
    }

    public String getMultiIdAttr() {
        return this.multiIdAttr != null ? this.multiIdAttr : "";
    }

    public void setMultiIdAttr(String multiIdAttr) {
        this.multiIdAttr = multiIdAttr;
    }

    public List<String> getMultiIdAttrList() {
        return this.multiIdAttrList;
    }

    public void addMultiIdAttr(String multiIdAttr) {
        this.multiIdAttrList.add(multiIdAttr);
    }

    public boolean hasMultiId() {
        return this.hasMultiId;
    }

    public void setHasMultiId(boolean hasMultiId) {
        this.hasMultiId = hasMultiId;
    }

    public boolean needMultiId() {
        return this.needMultiId;
    }

    public void setNeedMultiId(boolean needMultiId) {
        this.needMultiId = needMultiId;
    }

    public String getMultiIdName() {
        return this.multiIdName != null ? this.multiIdName : this.getMultiName();
    }

    public void setMultiIdName(String multiIdName) {
        this.multiIdName = multiIdName;
    }

    public String getMultiIdNames(String idName) {
        return this.multiIdNames.get(idName);
    }

    public Map<String, String> getMultiIdNamesHash() {
        return this.multiIdNames;
    }

    public void addMultiIdNames(String multiIdName, String multiIdCsvName) {
        this.multiIdNames.put(multiIdName, multiIdCsvName);
    }

    public void setRootAttribute(String attr) {
        this.rootNameAttribute = attr;
    }

    public boolean hasCsvName() {
        return this.csvName != null;
    }

    public void setCsvName(String name) {
        this.csvName = name;
    }

    public String getCsvName() {
        return this.csvName;
    }

    public static ArrayList<String> getHeaders(XMLStructureNode node, boolean ignoreMulti) {
        ArrayList<String> tmp = XMLStructureNode.getHeadersRecursive(node, ignoreMulti);
        tmp.add(0, ROOT_NODE_NAME);
        if (!node.isMulti()) {
            tmp.add(FILE_NAME);
        }
        return tmp;
    }

    public static ArrayList<String> getMultiHeaders(XMLStructureNode node, String multiName) {
        return XMLStructureNode.getHeaders(XMLStructureNode.getMultiStructure(node, multiName), false);
    }

    public static XMLStructureNode getMultiStructure(XMLStructureNode node, String multiName) {
        if (node.getName().equalsIgnoreCase(multiName)) {
            return node;
        }
        if (node.hasChild()) {
            for (XMLStructureNode currNode : node.getChilds()) {
                XMLStructureNode tmpNode = XMLStructureNode.getMultiStructure(currNode, multiName);
                if (tmpNode == null) continue;
                return tmpNode;
            }
        }
        return null;
    }

    private static ArrayList<String> getHeadersRecursive(XMLStructureNode node, boolean ignoreMulti) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (ignoreMulti && node.isMulti()) {
            return tmp;
        }
        if (!node.hasChild()) {
            if (node.hasCsvName()) {
                tmp.add(node.getCsvName());
            } else {
                tmp.add(node.getName());
            }
        }
        if (node.hasAttributes()) {
            for (String attr : node.getAttributes()) {
                tmp.add(String.format("%s_%s", node.getName(), attr));
            }
        }
        if (node.needMultiId()) {
            for (String multiIdCsvName : node.getMultiIdNamesHash().values()) {
                if (multiIdCsvName.equalsIgnoreCase(node.getMultiName())) continue;
                tmp.add(multiIdCsvName);
            }
        }
        if (node.hasChild()) {
            for (XMLStructureNode currNode : node.getChilds()) {
                if (currNode.isMulti() && ignoreMulti) {
                    tmp.add(currNode.getMultiName());
                }
                for (String str : XMLStructureNode.getHeadersRecursive(currNode, true)) {
                    tmp.add(str);
                }
            }
        }
        if (node.checkForChildren()) {
            tmp.add(node.getCheckForChildrenAttrName());
        }
        return tmp;
    }

    public static ArrayList<String> getMultiNames(XMLStructureNode node) {
        return XMLStructureNode.getMultiNamesRecursive(node, node.getEntityName());
    }

    private static ArrayList<String> getMultiNamesRecursive(XMLStructureNode node, String rootNodeName) {
        ArrayList<String> tmp = new ArrayList<String>();
        if (node.isMulti()) {
            tmp.add(String.format("%s_%s", rootNodeName, node.getMultiName()));
        }
        if (node.hasChild()) {
            for (XMLStructureNode currNode : node.getChilds()) {
                for (String str : XMLStructureNode.getMultiNamesRecursive(currNode, rootNodeName)) {
                    tmp.add(str);
                }
            }
        }
        return tmp;
    }
}

