/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.uc4.ScriptAnalayzer.uc4_script;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import org.antlr.runtime.RecognitionException;

public class UC4ScriptAnalyzer {
    protected String m_Script = null;
    protected String m_ScriptFormalized = null;
    private LinkedHashMap<String, Integer> m_variables = null;
    private LinkedHashMap<String, Integer> m_literals = null;
    private LinkedHashMap<String, Integer> m_functions = null;
    private LinkedHashMap<String, Integer> m_full_functions = null;
    private List<String> m_errors = null;
    private List<String> m_embedded = null;
    private List<Integer[]> m_embedded_lines = new ArrayList<Integer[]>();
    private static boolean m_firstTime = true;
    private static boolean m_debug = false;

    public UC4ScriptAnalyzer(String script) {
        this.m_Script = script;
        this.m_ScriptFormalized = this.FormalizeScript(script);
        if (m_firstTime) {
            m_firstTime = false;
            String debug = System.getenv("UC4ScriptAnalyzerDebug");
            if (debug != null && debug.equals("1")) {
                m_debug = true;
            }
        }
        if (m_debug) {
            System.out.println("================ Start of Script =================\n");
            System.out.println(this.m_ScriptFormalized);
            System.out.println("================ End   of Script =================\n\n");
        }
    }

    public String FormalizeScript(String script) {
        Object formalizedScript = new String();
        boolean osScriptStarted = false;
        Integer[] start_end_lines = null;
        Integer lineIndex = 0;
        String[] lines = script.split("\n");
        lineIndex = 0;
        while (lineIndex < lines.length) {
            if (lines[lineIndex].trim().isEmpty()) {
                formalizedScript = (String)formalizedScript + lines[lineIndex] + "\n";
            } else if (lines[lineIndex].startsWith(":")) {
                if (osScriptStarted) {
                    formalizedScript = (String)formalizedScript + ":}\n";
                    osScriptStarted = false;
                    start_end_lines[1] = lineIndex;
                    this.m_embedded_lines.add(start_end_lines);
                }
                formalizedScript = (String)formalizedScript + lines[lineIndex] + "\n";
            } else {
                if (!osScriptStarted) {
                    formalizedScript = (String)formalizedScript + ":{\n";
                    osScriptStarted = true;
                    start_end_lines = new Integer[2];
                    start_end_lines[0] = lineIndex + 1;
                }
                formalizedScript = (String)formalizedScript + lines[lineIndex] + "\n";
            }
            Integer n = lineIndex;
            lineIndex = lineIndex + 1;
        }
        if (osScriptStarted) {
            formalizedScript = (String)formalizedScript + ":}\n";
            start_end_lines[1] = lineIndex;
            this.m_embedded_lines.add(start_end_lines);
        }
        return formalizedScript;
    }

    public void doAnalyze() {
        uc4_script uc4script = new uc4_script();
        try {
            uc4script.init(this.m_ScriptFormalized);
        }
        catch (IOException e) {
            this.handleException(e);
        }
        catch (RecognitionException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (OutOfMemoryError e) {
            this.handleException(e);
            throw e;
        }
        catch (Throwable e) {
            this.handleException((Exception)e);
        }
        this.m_variables = this.sortMap(uc4script.get_variables());
        this.m_literals = this.sortMap(uc4script.get_literals());
        this.m_functions = this.sortMap(uc4script.get_functions());
        this.m_full_functions = this.sortMap(uc4script.get_full_functions());
        this.m_embedded = uc4script.get_full_embedded();
        if (this.m_errors == null) {
            this.m_errors = uc4script.get_errors();
        } else {
            this.m_errors.addAll(uc4script.get_errors());
        }
        if (m_debug && !this.m_errors.isEmpty()) {
            System.out.println("*** The following errors were found in the above listed script:\n");
            Integer errorsCounter = 0;
            while (errorsCounter < this.m_errors.size()) {
                System.out.println(this.m_errors.get(errorsCounter) + "\n\n");
                Integer n = errorsCounter;
                errorsCounter = errorsCounter + 1;
            }
            System.out.println("*** End of Errors listing for script\n\n");
        }
    }

    private void handleException(Exception e) {
        String exMessage = e.getClass().toString() + " occurred at the following script:\n";
        exMessage = exMessage + this.m_ScriptFormalized + "\n\n";
        if (e.getMessage() != null) {
            exMessage = exMessage + "\nException message: " + e.getMessage();
        }
        if (e.getCause() != null) {
            exMessage = exMessage + "\nException cause: " + String.valueOf(e.getCause());
        }
        ExceptionHandler.writeToExceptionFile((String)exMessage);
        if (this.m_errors == null) {
            this.m_errors = new ArrayList<String>();
        }
        this.m_errors.add(e.getClass().toString() + " occurred while analyzing the script");
    }

    private void handleException(OutOfMemoryError e) {
        e.printStackTrace();
        String exMessage = e.getClass().toString() + " occurred at the following script:\n";
        exMessage = exMessage + this.m_ScriptFormalized + "\n\n";
        if (e.getMessage() != null) {
            exMessage = exMessage + "\nException message: " + e.getMessage();
        }
        if (e.getCause() != null) {
            exMessage = exMessage + "\nException cause: " + String.valueOf(e.getCause());
        }
        exMessage = exMessage + "\nStack of exception:\n";
        StackTraceElement[] ste = e.getStackTrace();
        for (int i = 0; i < ste.length; ++i) {
            exMessage = exMessage + "   " + ste[i].toString() + "\n";
        }
        ExceptionHandler.writeToExceptionFile((String)exMessage);
        if (this.m_errors == null) {
            this.m_errors = new ArrayList<String>();
        }
        this.m_errors.add(e.getClass().toString() + " occurred while analyzing the script");
    }

    private LinkedHashMap<String, Integer> sortMap(HashMap<String, Integer> inMap) {
        IgnoreCaseComparator comp = new IgnoreCaseComparator(this);
        TreeMap<String, Integer> sortedMap = new TreeMap<String, Integer>(comp);
        sortedMap.putAll(inMap);
        LinkedHashMap<String, Integer> sortedHashMap = new LinkedHashMap<String, Integer>();
        sortedHashMap.putAll(sortedMap);
        return sortedHashMap;
    }

    public String getScript() {
        return this.m_Script;
    }

    public String getFormalizedScript() {
        return this.m_ScriptFormalized;
    }

    public LinkedHashMap<String, Integer> getElementByType(String elementType) {
        if (elementType.equals("Variable")) {
            return this.getVariables();
        }
        if (elementType.equals("Literal")) {
            return this.getLiterals();
        }
        if (elementType.equals("Function")) {
            return this.getFunctions();
        }
        return null;
    }

    public LinkedHashMap<String, Integer> getVariables() {
        return this.m_variables;
    }

    public LinkedHashMap<String, Integer> getLiterals() {
        return this.m_literals;
    }

    public LinkedHashMap<String, Integer> getFunctions() {
        return this.m_functions;
    }

    public LinkedHashMap<String, Integer> getFullFunctions() {
        return this.m_full_functions;
    }

    public List<String> getErrors() {
        return this.m_errors;
    }

    public List<String> getEmbedded() {
        return this.m_embedded;
    }

    public List<Integer[]> getEmbeddedLines() {
        return this.m_embedded_lines;
    }

    class IgnoreCaseComparator
    implements Comparator<String> {
        IgnoreCaseComparator(UC4ScriptAnalyzer this$0) {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.compareToIgnoreCase(s2);
        }
    }
}

