/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.UC4ReferencedEntitiesHandler;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.uc4.MFJobsHandler;
import com.bmc.ctmconvert.uc4.ScriptsHandlerGetter;
import com.bmc.ctmconvert.uc4.UC4CaleConvertor;
import com.bmc.ctmconvert.uc4.UC4ConnectionsHelper;
import com.bmc.ctmconvert.uc4.UC4Globals;
import com.bmc.ctmconvert.uc4.UC4Job;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4Object;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectLogin;
import com.bmc.ctmconvert.uc4.UC4Objects.UC4ObjectTablesMap;
import com.bmc.ctmconvert.uc4.UC4SapR3JobAnalysis;
import com.bmc.ctmconvert.uc4.UC4ScriptingAnalysis;
import com.bmc.ctmconvert.uc4.UC4TimeZone;
import com.bmc.ctmconvert.uc4.UC4VariablesHelper;
import com.bmc.ctmconvert.uc4.UC4XMLStructure;
import com.bmc.ctmconvert.uc4.Uc4EntitesWalker;
import com.bmc.ctmconvert.uc4.handlers.Uc4UnscheduledJobsAsDummyReporter;
import com.bmc.ctmconvert.uc4.scripts.IScriptHandler;
import com.bmc.ctmconvert.uc4.scripts.IScriptRecord;
import com.bmc.ctmconvert.uc4.scripts.ScriptsPatternsRecord;
import com.bmc.ctmconvert.uc4.scripts.Uc4ScriptsMapCreator;
import com.bmc.ctmconvert.utils.UniqueConditionNameGenerator;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class UC4Defs
implements SourceDefinitions {
    private AttrHolderList top_level_parents;
    private RulesDataSet rules = null;
    private Boolean isIncludeType = null;
    private Boolean isOrCond = null;
    private boolean includeUnautomatedEntities = false;
    private Boolean isToDummy = null;
    private final UC4ObjectTablesMap uc4Object;
    private final Map<String, XmlElement> mapJobNametoXmlElement;
    private final MFJobsHandler mfJobsHandler;
    private UniqueValueGenerator uniquValue;
    private final UC4CaleConvertor uc4CaleConvertor;
    private IScriptHandler postScriptHandler;
    private IScriptHandler preScriptHandler;
    private UniqueConditionNameGenerator uniqueConditionNameGenerator;
    private final UC4SapR3JobAnalysis sapR3JobAnalysis;
    private Map<String, Long> objectNameToNumberOfUsages;
    private Map<String, ScriptsPatternsRecord> scriptRecordCollectorMap = new HashMap<String, ScriptsPatternsRecord>();
    private AttrHolderList syncObjects;

    public UC4Defs(RulesDataSet rulesDataSet, UC4ObjectTablesMap uc4Object, Map<String, XmlElement> mapJobNametoXmlElement, UC4CaleConvertor uc4CaleConvertor, ScriptsHandlerGetter getter, Uc4ScriptsMapCreator scriptsMapCreator) {
        this.rules = rulesDataSet;
        this.sapR3JobAnalysis = new UC4SapR3JobAnalysis();
        this.includeUnautomatedEntities = this.rules.getBooleanRule("UC4 rules", new String[]{"CONVERT_UNAUTOMATED"});
        this.mfJobsHandler = new MFJobsHandler();
        this.uc4Object = uc4Object;
        this.uniquValue = new UniqueValueGenerator();
        this.mapJobNametoXmlElement = mapJobNametoXmlElement;
        this.uc4CaleConvertor = uc4CaleConvertor;
        this.uniqueConditionNameGenerator = new UniqueConditionNameGenerator("-");
        Params.instance().setFirstDayOfTheWeek(this.rules.getStringRule("UC4 rules", new String[]{"FIRST_DAY_OF_WEEK"}));
        this.init(getter);
        this.objectNameToNumberOfUsages = this.getEntitiesUsagesNumber();
        try {
            List<IScriptRecord> scripts_analysis_records = scriptsMapCreator.fillScriptsMapByReadingExcelFile();
            if (scripts_analysis_records != null) {
                this.scriptRecordCollectorMap = new HashMap<String, ScriptsPatternsRecord>(scripts_analysis_records.size());
                scripts_analysis_records.forEach(record -> {
                    ScriptsPatternsRecord record1 = (ScriptsPatternsRecord)record;
                    if (record1.getJobName().isEmpty()) {
                        return;
                    }
                    this.scriptRecordCollectorMap.put(record1.getJobName(), record1);
                });
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ScriptsPatternsRecord getScriptsPatternsRecord(String jobName) {
        return this.scriptRecordCollectorMap.get(jobName);
    }

    protected void init(ScriptsHandlerGetter getter) {
        this.postScriptHandler = getter.getPostScriptHandler();
        this.preScriptHandler = getter.getPreScriptHandler();
    }

    public boolean getIncludeUnautomatedEntities() {
        return this.includeUnautomatedEntities;
    }

    public boolean isObjectUsedMoreThanOne(String uc4ObjName) {
        return this.getEntitiesUsagesNumber().containsKey(uc4ObjName) && this.getEntitiesUsagesNumber().get(uc4ObjName) > 1L;
    }

    public Map<String, Long> getEntitiesUsagesNumber() {
        if (this.objectNameToNumberOfUsages == null && this.getUC4ObjectTablesMap() != null) {
            HashMap<String, UC4Object> topLevelList = this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.JSCH);
            ArrayList<String> entitiesNames = new ArrayList<String>();
            for (UC4Object obj : topLevelList.values()) {
                entitiesNames.addAll(this.getDescendentsNames(obj));
            }
            return entitiesNames.stream().collect(Collectors.groupingBy(name -> name, Collectors.counting()));
        }
        return this.objectNameToNumberOfUsages;
    }

    private List<String> getDescendentsNames(UC4Object obj) {
        List childrenNames = Optional.ofNullable(obj.getChildrenNames()).orElse(new ArrayList());
        if (!childrenNames.isEmpty()) {
            AttrHolderList children = this.getUC4ObjectTablesMap().getTriggeredJobsHandler().getChildrenWithTriggeredJobs(obj);
            for (IAttrHolder childAttr : children) {
                UC4Object child = this.getUC4ObjectTablesMap().getChild(childAttr);
                if (child == null || this.isCyclicSubFoldersRuleEnabled() && this.isUsedByCyclicEvent(child)) continue;
                childrenNames.addAll(this.getDescendentsNames(child));
            }
        }
        return childrenNames;
    }

    private boolean isUsedByCyclicEvent(UC4Object child) {
        List<UC4Object> eventsForJob = this.getEventsForJob(child.getName());
        if (eventsForJob == null || eventsForJob.isEmpty()) {
            return false;
        }
        return eventsForJob.stream().anyMatch(it -> it.isTimeEvent() && it.isCyclicEvent());
    }

    private void generateSyncObjects() {
        this.syncObjects = new AttrHolderList();
        HashMap<String, UC4Object> syncList = this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.SYNC);
        for (String name : syncList.keySet()) {
            this.syncObjects.add((Object)syncList.get(name).getAttributes());
        }
    }

    public IAttrHolder getSyncAttributes(String syncName) {
        if (this.syncObjects == null) {
            this.generateSyncObjects();
        }
        return this.syncObjects.stream().filter(it -> it.getAttr("SYNC_name").equals(syncName)).findFirst().orElse(null);
    }

    public UC4Object getSyncObject(String syncName) {
        IAttrHolder syncAttributes = this.getSyncAttributes(syncName);
        if (syncAttributes == null) {
            return null;
        }
        String syncEntityId = this.getEntityId(syncAttributes, UC4Globals.UC4_TYPES.SYNC);
        return this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.SYNC).get(syncEntityId);
    }

    public AttrHolderList getTopLevelEntities() {
        if (this.top_level_parents == null) {
            this.top_level_parents = new AttrHolderList();
            if (this.isConvertTemplatesRuleEnabled()) {
                this.addEntityTemplatesForReference();
            }
            HashMap<String, UC4Object> topLevelList = this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.JSCH);
            for (String name : topLevelList.keySet()) {
                this.top_level_parents.add((Object)topLevelList.get(name).getAttributes());
            }
            this.addJobpWithMultipleTimeEventsToTopLevelParents();
            AttrHolderList mfToopLevelEntities = this.getMFTopLevelEntites(this.top_level_parents);
            if (!mfToopLevelEntities.isEmpty()) {
                this.top_level_parents.addAll((Collection)mfToopLevelEntities);
            }
        }
        this.uniqueConditionNameGenerator = new UniqueConditionNameGenerator("-");
        return this.top_level_parents;
    }

    private void addJobpWithMultipleTimeEventsToTopLevelParents() {
        ArrayList<IAttrHolder> newEntries = new ArrayList<IAttrHolder>();
        ArrayList<IAttrHolder> entriesToRemove = new ArrayList<IAttrHolder>();
        for (IAttrHolder toplevel : this.top_level_parents) {
            this.processTopLevelParent(toplevel, newEntries, entriesToRemove);
        }
        this.top_level_parents.removeAll(entriesToRemove);
        this.top_level_parents.addAll(newEntries);
    }

    void processTopLevelParent(IAttrHolder toplevel, List<IAttrHolder> newEntries, List<IAttrHolder> entriesToRemove) {
        List<UC4Object> triggeringTimeEvents;
        String jobpName = toplevel.getAttr("JOBP_name");
        if (jobpName != null && UC4Defs.hasMultipleEvents(triggeringTimeEvents = this.getTimeEventsForJob(jobpName))) {
            entriesToRemove.add(toplevel);
            this.duplicateJobpForTimeEvents(toplevel, triggeringTimeEvents, newEntries);
        }
    }

    public List<UC4Object> getTimeEventsForJob(String jobpName) {
        List<UC4Object> triggeringEvents = this.getEventsForJob(jobpName);
        if (UC4Defs.hasMultipleEvents(triggeringEvents)) {
            return triggeringEvents.stream().filter(UC4Object::isTimeEvent).toList();
        }
        return new ArrayList<UC4Object>();
    }

    void duplicateJobpForTimeEvents(IAttrHolder toplevel, List<UC4Object> timeEvents, List<IAttrHolder> newEntries) {
        for (UC4Object uc4Object : timeEvents) {
            AttrHolder newToplevel = ((AttrHolder)toplevel).clone();
            newToplevel.appendAttr("timeEventForJobP", uc4Object.getName());
            newEntries.add((IAttrHolder)newToplevel);
        }
    }

    private static boolean hasMultipleEvents(List<UC4Object> triggeringEvents) {
        return triggeringEvents != null && triggeringEvents.size() > 1;
    }

    public List<UC4Object> getEventsForJob(String jobpName) {
        return this.getUC4ObjectTablesMap().getTriggeredJobsHandler().getEventforJob(jobpName);
    }

    private void addEntityTemplatesForReference() {
        UC4ReferencedEntitiesHandler uC4ReferencedEntitiesHandler = new UC4ReferencedEntitiesHandler(this.getUC4ObjectTablesMap(), this.getEntitiesUsagesNumber());
        uC4ReferencedEntitiesHandler.createTemplatesFolderAttr();
        AttrHolderList jobpAttrHolders = uC4ReferencedEntitiesHandler.getAllJobpEntitiesAttributes();
        this.top_level_parents.addAll((Collection)jobpAttrHolders);
    }

    public boolean isConvertTemplatesRuleEnabled() {
        boolean convertTemplatesRuleExist = this.getRules().isRuleExist("UC4 rules", new String[]{"UC4_CONVERTING_TEMPLATE_JOBS_TO_CONTROLM_REFERENCED_JOBS"});
        return convertTemplatesRuleExist && this.getRules().getBooleanRule("UC4 rules", new String[]{"UC4_CONVERTING_TEMPLATE_JOBS_TO_CONTROLM_REFERENCED_JOBS"}) != false;
    }

    public boolean isDeleteConditionsRuleEnabled() {
        boolean convertTemplatesRuleExist = this.getRules().isRuleExist("UC4 rules", new String[]{"UC4_DELETE_CONDITIONS"});
        return convertTemplatesRuleExist && this.getRules().getBooleanRule("UC4 rules", new String[]{"UC4_DELETE_CONDITIONS"}) != false;
    }

    public boolean isCyclicSubFoldersRuleEnabled() {
        boolean cyclicSubFoldersRuleExist = this.getRules().isRuleExist("UC4 rules", new String[]{"UC4_MOVING_CYCLIC_ATTRIBUTES_FROM_SUB_FOLDER_TO_JOB_LEVEL"});
        return cyclicSubFoldersRuleExist && this.getRules().getBooleanRule("UC4 rules", new String[]{"UC4_MOVING_CYCLIC_ATTRIBUTES_FROM_SUB_FOLDER_TO_JOB_LEVEL"}) != false;
    }

    private AttrHolderList getMFTopLevelEntites(AttrHolderList top_level_parents) {
        Uc4EntitesWalker walker = new Uc4EntitesWalker(this);
        walker.walk(top_level_parents, this.mfJobsHandler::handle);
        AttrHolderList mfAtributes = this.mfJobsHandler.getMFSmartFoldersAttrHolder();
        this.uniquValue = new UniqueValueGenerator();
        return mfAtributes;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
        UC4TimeZone.destroy();
        UC4Job.uniqueNumber = 0;
        UC4ObjectTablesMap.destroy();
        UC4ScriptingAnalysis.instance().writeAllContentToCsv();
        this.sapR3JobAnalysis.writeAllContentToCsv();
        UC4Job.uniqueNumber = 0;
    }

    public void init() throws ConvertorCancelClickException {
        this.objectNameToNumberOfUsages = this.getEntitiesUsagesNumber();
        this.getTopLevelEntities();
        this.applyFilter("0");
        UC4ConnectionsHelper.saveConnections(this.uc4Object);
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        if (this.mfJobsHandler.isMfAttr(attributes)) {
            return this.mfJobsHandler.getSmartFolder((MFJobsHandler.Uc4MfAttr)attributes);
        }
        UC4Globals.UC4_TYPES uc4Type = this.getEntityType(attributes);
        String id = this.getEntityId(attributes, uc4Type);
        UC4Object uc4Obj = this.getUC4ObjectTablesMap().getObj(uc4Type).get(id);
        if (attributes.isFieldExist("timeEventForJobP")) {
            String eventName = attributes.getAttr("timeEventForJobP");
            uc4Obj.setEventNameToUse(eventName);
        }
        return new UC4Job(this, uc4Type, uc4Obj);
    }

    private String getEntityId(IAttrHolder attributes, UC4Globals.UC4_TYPES uc4Type) {
        return attributes.getAttr(UC4XMLStructure.getIdFieldName(uc4Type));
    }

    @NotNull
    private UC4Globals.UC4_TYPES getEntityType(IAttrHolder attributes) {
        UC4Globals.UC4_TYPES uc4Type = UC4Globals.UC4_TYPES.JSCH;
        if (attributes.isFieldExist(UC4XMLStructure.getIdFieldName(UC4Globals.UC4_TYPES.JOBP))) {
            uc4Type = UC4Globals.UC4_TYPES.JOBP;
        }
        return uc4Type;
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return UC4XMLStructure.getIdFieldName(UC4Globals.UC4_TYPES.JSCH);
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return true;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
        AttrHolderList filteredList = new AttrHolderList();
        if (this.top_level_parents == null) {
            return;
        }
        for (int i = 0; i < this.top_level_parents.size(); ++i) {
            IAttrHolder parent = (IAttrHolder)this.top_level_parents.get(i);
            if (!this.isFilter(parent)) continue;
            filteredList.add((Object)parent);
        }
        this.top_level_parents = null;
        this.top_level_parents = filteredList;
    }

    private boolean isFilter(IAttrHolder record) {
        boolean rc = true;
        boolean funcRC = false;
        boolean isInclude = this.getIncludeType();
        boolean isOrCondition = this.getOrCondition();
        ArrayList configurationCondition = this.rules.getFilterHandler().getConditions();
        for (Map.Entry entry : configurationCondition) {
            String field = (String)entry.getKey();
            String regVal = (String)entry.getValue();
            String recordVal = "";
            if (field.equalsIgnoreCase("Schedule Name")) {
                recordVal = record.getAttr(UC4XMLStructure.getIdFieldName(UC4Globals.UC4_TYPES.JSCH));
            } else if (field.equalsIgnoreCase("Client Number")) {
                recordVal = record.getAttr(String.format("%s_%s", UC4Globals.UC4_TYPES.JSCH.getTagName(), "client"));
            }
            funcRC = this.matchWildcard(recordVal, regVal);
            if (funcRC) {
                rc = true;
                if (!isOrCondition) continue;
                break;
            }
            rc = false;
            if (isOrCondition) continue;
        }
        return isInclude ? rc : !rc;
    }

    private boolean getIncludeType() {
        if (this.isIncludeType == null) {
            this.isIncludeType = this.rules.getFilterHandler().isInclude();
        }
        return this.isIncludeType;
    }

    private boolean getOrCondition() {
        if (this.isOrCond == null) {
            this.isOrCond = this.rules.getFilterHandler().isOr();
        }
        return this.isOrCond;
    }

    private boolean matchWildcard(String value, String expr) {
        String regExp = expr.replaceAll("\\*", ".*");
        regExp = regExp.replaceAll("\\?", ".");
        return value.matches(regExp);
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return false;
    }

    public ArrayList<String> getGeneralMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        Uc4UnscheduledJobsAsDummyReporter uc4UnscheduledJobsAsDummyReporter = new Uc4UnscheduledJobsAsDummyReporter(this.rules, (msgId, params) -> Reporter.addMessage((List)messages, (String)msgId, (String)"General", (String[])params));
        uc4UnscheduledJobsAsDummyReporter.report();
        return messages;
    }

    public void postActions() {
        this.uc4CaleConvertor.saveUsedCalendars();
        new UC4VariablesHelper().saveVariables(this.uc4Object.getObj(UC4Globals.UC4_TYPES.VARA));
    }

    public UC4Object getUc4Object(UC4Globals.UC4_TYPES type, String id) {
        return this.getUC4ObjectTablesMap().getObj(type).get(id);
    }

    public UC4ObjectTablesMap getUC4ObjectTablesMap() {
        return this.uc4Object;
    }

    public boolean isToDummy() {
        if (this.isToDummy == null) {
            this.isToDummy = this.rules.getTaskTypeHandler().isToDummy();
        }
        return this.isToDummy;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }

    public UC4Object getHostG(String hostName) {
        return this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.HOSTG).get(hostName);
    }

    public UC4Object getObjById(String id) {
        return this.getUC4ObjectTablesMap().getObjById(id);
    }

    public UC4ObjectLogin getLogin(String login) {
        return (UC4ObjectLogin)this.getUC4ObjectTablesMap().getObj(UC4Globals.UC4_TYPES.LOGIN).get(login);
    }

    public String getTimeZoneName(UC4Job uc4Job, String timeZone) {
        return UC4TimeZone.instance().getTimeZoneName(uc4Job, timeZone);
    }

    public XmlElement getElement(String jobName) {
        return this.mapJobNametoXmlElement.get(jobName);
    }

    public UniqueValueGenerator getUniqueValueGenerator() {
        return this.uniquValue;
    }

    public UC4CaleConvertor getUC4CaleConvertor() {
        return this.uc4CaleConvertor;
    }

    public IScriptHandler getPreScriptHandler() {
        return this.preScriptHandler;
    }

    public IScriptHandler getPostScriptHandler() {
        return this.postScriptHandler;
    }

    public String getUniqueOutConditionName(String condName) {
        return this.uniqueConditionNameGenerator.getUniqueOutConditionName(condName);
    }

    public String getUniqueInConditionName(String condName) {
        return this.uniqueConditionNameGenerator.getUniqueInConditionName(condName);
    }

    public UC4SapR3JobAnalysis getSapR3JobAnalysis() {
        return this.sapR3JobAnalysis;
    }
}

