/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.uc4;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.utils.Pair;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UC4CaleConvertor {
    public static final int RBCNameMaxLengh = 19;
    public static final int calendarNameMaxLengh = 30;
    private final Map<String, HashMap<String, Set<Properties>>> cale2rbc = new HashMap<String, HashMap<String, Set<Properties>>>();
    private final CalendarsCollector calendarsCollector = new CalendarsCollector();
    private final HashMap<String, HashMap<String, List<String[]>>> caleKeyWord2Messages = new HashMap();
    private final int firstDayOfTheWeek;
    private final UniqueValueGenerator uniqueValue = new UniqueValueGenerator();
    private final String messageKeyFormat = "%s.%s";
    private final String startDayOfTheWeek;
    private static final String[] WEEK_DAYS = new String[]{"SU", "MO", "TU", "WE", "TH", "FR", "SA"};
    private static final Pattern NUMBERS = Pattern.compile("[0-9]+");
    private static final Predicate<String> IS_EMPTY_OR_NUMBERS = s -> s.isEmpty() || NUMBERS.matcher((CharSequence)s).matches();
    private static final int CURRENT_YEAR = Calendar.getInstance().get(1);
    private static final String CURRENT_YEAR_STR = String.valueOf(CURRENT_YEAR);

    private Comparator<Node> calendarComperator() {
        List<Character> calendarTypeOrder = Arrays.asList(Character.valueOf('Y'), Character.valueOf('M'), Character.valueOf('W'), Character.valueOf('S'), Character.valueOf('R'), Character.valueOf('G'));
        return (left, right) -> {
            char leftCalendarType = this.getCalendarType((Node)left);
            char rightCalendarType = this.getCalendarType((Node)right);
            int indexOfLeft = calendarTypeOrder.indexOf(Character.valueOf(leftCalendarType));
            int indexOfRight = calendarTypeOrder.indexOf(Character.valueOf(rightCalendarType));
            return Integer.compare(indexOfLeft, indexOfRight);
        };
    }

    public UC4CaleConvertor(Path path, String startDayOfTheWeek) {
        this.startDayOfTheWeek = startDayOfTheWeek;
        this.firstDayOfTheWeek = this.getStartDay();
        try (DirectoryStream<Path> is = Files.newDirectoryStream(path);){
            is.forEach(this.parseCaleFiles());
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException("Unable to parse cale files", e);
        }
    }

    CalendarsCollector getCalendarsCollector() {
        return this.calendarsCollector;
    }

    private Consumer<Path> parseCaleFiles() {
        return file -> {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder parser = factory.newDocumentBuilder();
                String fileName = file.getFileName().toString();
                if (fileName.matches("CALE_\\d+\\.xml")) {
                    InputStream fileInputstream = Files.newInputStream(file, new OpenOption[0]);
                    Document doc = parser.parse(fileInputstream);
                    doc.getDocumentElement().normalize();
                    Node node = doc.getFirstChild();
                    for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (!node.getNodeName().equals("CALE")) continue;
                        this.convertCale(node);
                    }
                }
            }
            catch (IOException | ParserConfigurationException | SAXException e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        };
    }

    private void convertCale(Node node) {
        String caleName = this.getNodeName(node);
        Node keyWords = this.findChildNodeByName(node, "keyWords");
        List<Node> keywords = this.getAllChildNodesByName(keyWords, "Keyword");
        keywords.sort(this.calendarComperator());
        for (Node keyword : keywords) {
            this.convertKeyWord(keyword, caleName);
        }
    }

    private int getStartDay() {
        for (int i = 0; i < Globs.WEEKDAYS_ARRAY.length; ++i) {
            if (!this.startDayOfTheWeek.equals(Globs.WEEKDAYS_ARRAY[i])) continue;
            return i - 1;
        }
        return 0;
    }

    public Map<String, List<String[]>> getkeyWordMessages(String caleName, String keyWordName) {
        String messageKey = String.format("%s.%s", caleName, keyWordName);
        return this.caleKeyWord2Messages.get(messageKey);
    }

    private void convertKeyWord(Node keyWord, String caleName) {
        char keyWordType = this.getCalendarType(keyWord);
        switch (keyWordType) {
            case 'S': {
                this.convertStatic(keyWord, caleName);
                break;
            }
            case 'Y': {
                this.convertYearly(keyWord, caleName);
                break;
            }
            case 'M': {
                this.convertMonthly(keyWord, caleName);
                break;
            }
            case 'W': {
                this.convertWeekly(keyWord, caleName);
                break;
            }
            case 'R': {
                this.convertRoll(keyWord, caleName);
                break;
            }
            case 'G': {
                this.convertGroup(keyWord, caleName);
                break;
            }
            default: {
                ConversionLogger.getLogger().warning(String.format("Unknown calendar keyword type: %s for keword %s in cale %s", Character.valueOf(keyWordType), this.getNodeName(keyWord), caleName));
            }
        }
    }

    private void convertWeekly(Node keyWord, String caleName) {
        Node daysValueNode;
        NamedNodeMap attribs = this.findChildNodeByName(keyWord, "Dynamic").getAttributes();
        String firstWeekStr = attribs.getNamedItem("PeriodStart").getNodeValue();
        String lastWeekStr = attribs.getNamedItem("PeriodEnd").getNodeValue();
        String weeklyIntervalStr = attribs.getNamedItem("Period").getNodeValue();
        CtmCalendar cal = null;
        if (IS_EMPTY_OR_NUMBERS.test(firstWeekStr) && IS_EMPTY_OR_NUMBERS.test(lastWeekStr) && IS_EMPTY_OR_NUMBERS.test(weeklyIntervalStr)) {
            int firstWeek;
            int weeklyInterval = weeklyIntervalStr.isEmpty() ? 1 : Integer.parseInt(weeklyIntervalStr);
            int lastWeek = lastWeekStr.isEmpty() ? 1 : Integer.parseInt(lastWeekStr);
            int n = firstWeek = firstWeekStr.isEmpty() ? 53 : Integer.parseInt(firstWeekStr);
            if (firstWeek != 1 || lastWeek != 53 || weeklyInterval != 1) {
                GregorianCalendar tmpCal = new GregorianCalendar();
                tmpCal.set(5, 1);
                tmpCal.set(2, 0);
                int lastYear = tmpCal.get(1) + 5;
                String weeksCal = this.generateCalName(CalendarType.Regular, caleName, this.getNodeName(keyWord));
                cal = new CtmCalendar(weeksCal, Params.instance().getDatacenterName());
                while (tmpCal.get(1) <= lastYear) {
                    if (tmpCal.get(3) >= firstWeek && tmpCal.get(3) <= lastWeek && (tmpCal.get(3) - firstWeek) % weeklyInterval == 0) {
                        cal.addDay(tmpCal.get(1), tmpCal.get(2) + 1, tmpCal.get(5));
                    }
                    tmpCal.add(5, 1);
                }
            }
        }
        String uc4weekDays = "";
        Node defDaysNode = this.findChildNodeByName(keyWord, "DefDays");
        if (defDaysNode != null && (daysValueNode = defDaysNode.getFirstChild()) != null) {
            uc4weekDays = daysValueNode.getNodeValue().toUpperCase();
        }
        StringBuilder ctmWeekDays = new StringBuilder();
        for (int i = 0; i < WEEK_DAYS.length; ++i) {
            if (!uc4weekDays.contains(WEEK_DAYS[i])) continue;
            if (!ctmWeekDays.isEmpty()) {
                ctmWeekDays.append(',');
            }
            ctmWeekDays.append((i - this.firstDayOfTheWeek + 7) % 7);
        }
        Properties rbc = new Properties();
        rbc.setProperty("WEEKDAYS", ctmWeekDays.toString());
        if (cal != null) {
            rbc.setProperty("WEEKSCAL", cal.getName());
        }
        this.saveRbcCtmCalendar(caleName, keyWord, rbc, cal);
    }

    private char getCalendarType(Node keyWord) {
        return keyWord.getAttributes().getNamedItem("CType").getNodeValue().toUpperCase().charAt(0);
    }

    private void convertRoll(Node keyWord, String caleName) {
        Node rollNode = this.findChildNodeByName(keyWord, "Roll");
        if (rollNode != null) {
            String keyWordName = this.getNodeName(keyWord);
            String newCalendarName = this.generateCalName(CalendarType.RBC, caleName, keyWordName);
            String[] messageParams = new String[]{newCalendarName, keyWordName, caleName};
            String messageKey = String.format("%s.%s", caleName, this.getNodeName(keyWord));
            this.addMessage(messageKey, "WRN8029", messageParams);
            Properties rbc = new Properties();
            rbc.setProperty("NAME", newCalendarName);
            this.saveRbc(caleName, keyWordName, rbc);
        }
    }

    private String getNodeName(Node node) {
        return node.getAttributes().getNamedItem("name").getNodeValue();
    }

    private void saveRbcCtmCalendar(String caleName, Node keyWord, Properties rbc, CtmCalendar cal) {
        String keyWordName = this.getNodeName(keyWord);
        this.calendarsCollector.addCtmCalendar(caleName, keyWordName, cal);
        rbc.setProperty("NAME", this.generateCalName(CalendarType.RBC, caleName, keyWordName));
        rbc.setProperty("DAYS_AND_OR", "OR");
        GlobalFunctions.setAllMonth((Properties)rbc, (String)"1");
        this.setActiveRange(rbc, keyWord);
        this.saveRbc(caleName, keyWordName, rbc);
    }

    private void saveRbcPeriodic(String caleName, String keyWordName, Properties rbc, List<Properties> periodicCal, String periodicCalName) {
        this.calendarsCollector.addPeriodical(caleName, keyWordName, periodicCal, periodicCalName);
        rbc.setProperty("DAYS_AND_OR", "OR");
        this.saveRbc(caleName, keyWordName, rbc);
    }

    private void saveRbc(String caleName, String keyWordName, Properties rbc) {
        rbc.setProperty("DATACENTER", Params.instance().getDatacenterName());
        this.calendarsCollector.addRbc(caleName, keyWordName, rbc);
        Properties prop = new Properties(2);
        prop.put("NAME", rbc.get("NAME"));
        prop.put("LEVEL", "Y");
        this.addRbc(caleName, keyWordName, prop);
    }

    private void addRbc(String caleName, String keyWordName, Properties rbc) {
        if (!this.cale2rbc.containsKey(caleName)) {
            this.cale2rbc.put(caleName, new HashMap());
        }
        if (!this.cale2rbc.get(caleName).containsKey(keyWordName)) {
            this.cale2rbc.get(caleName).put(keyWordName, new HashSet());
        }
        this.cale2rbc.get(caleName).get(keyWordName).add(rbc);
    }

    private void convertGroup(Node keyword, String calendarName) {
        String keywordName = this.getNodeName(keyword);
        List<Node> activeGroups = this.getActiveGroups(keyword);
        Map<String, List<String>> calendarsByRelationType = this.extractCalendarsByRelationType(activeGroups);
        String newCalendarName = this.generateCalName(CalendarType.RBC, calendarName, keywordName);
        Properties rbc = new Properties();
        rbc.setProperty("NAME", newCalendarName);
        this.saveRbc(calendarName, keywordName, rbc);
        String messageKey = String.format("%s.%s", calendarName, keywordName);
        String description = UC4CaleConvertor.buildDescription(calendarsByRelationType);
        String[] messageParams = new String[]{newCalendarName, keywordName, calendarName, description};
        this.addMessage(messageKey, "WRN8074", messageParams);
    }

    private Map<String, List<String>> extractCalendarsByRelationType(List<Node> activeGroups) {
        return activeGroups.stream().map(group -> {
            List<String> keyWordNames = this.collectAllKeywords(this.getAllChildNodesByName((Node)group, "row"));
            String relation = group.getNodeName();
            return Pair.of((Object)relation, keyWordNames);
        }).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    @NotNull
    private static String buildDescription(Map<String, List<String>> calendarsByRelationType) {
        StringJoiner desc = new StringJoiner("; ");
        calendarsByRelationType.forEach((relation, keyWordNames) -> {
            switch (relation) {
                case "A": {
                    desc.add("Include days that are in ALL of: " + String.join((CharSequence)", ", keyWordNames));
                    break;
                }
                case "O": {
                    desc.add("Include days that are in ANY of: " + String.join((CharSequence)", ", keyWordNames));
                    break;
                }
                case "N": {
                    desc.add("Exclude days from: " + String.join((CharSequence)", ", keyWordNames));
                }
            }
        });
        return desc.toString();
    }

    private List<Node> getActiveGroups(Node keyWord) {
        String[] groupTypes = new String[]{"A", "O", "N"};
        return Arrays.stream(groupTypes).map(groupType -> this.findChildNodeByName(keyWord, (String)groupType)).filter(Objects::nonNull).filter(grp -> grp.getAttributes().getNamedItem("flag").getNodeValue().equals("1")).collect(Collectors.toList());
    }

    private List<String> collectAllKeywords(List<Node> rows) {
        return rows.stream().filter(row -> row.getAttributes() != null).map(row -> this.getAttributeValueWithName((Node)row, "CaleKeyName")).toList();
    }

    private List<String> mergeLists(List<String> left, List<String> right) {
        return Stream.concat(left.stream(), right.stream()).collect(Collectors.toList());
    }

    private String getAttributeValueWithName(Node node, String name) {
        return node.getAttributes().getNamedItem(name).getNodeValue();
    }

    private void convertMonthly(Node keyWord, String caleName) {
        Node defDaysNode = this.findChildNodeByName(keyWord, "DefDays");
        Properties rbc = new Properties();
        NamedNodeMap dynamicAttributes = this.findChildNodeByName(keyWord, "Dynamic").getAttributes();
        boolean fromMonthStart = dynamicAttributes.getNamedItem("Direction").getNodeValue().equals("B");
        int firstDay = this.getValueOrDefault(dynamicAttributes, "IntervalStart", 1);
        int lastDay = this.getValueOrDefault(dynamicAttributes, "IntervalEnd", 31);
        int dailyInterval = this.getValueOrDefault(dynamicAttributes, "Interval", 1);
        dailyInterval = dailyInterval == 0 ? 1 : dailyInterval;
        this.setRbcMonths(rbc, dynamicAttributes);
        if (!fromMonthStart) {
            rbc.setProperty("DAYSCAL", "ALLDAYS");
        }
        StringBuilder daysList = new StringBuilder();
        if (defDaysNode != null && (defDaysNode.getFirstChild() == null || defDaysNode.getFirstChild().getNodeValue().isEmpty())) {
            if (fromMonthStart) {
                for (int i = firstDay; i < lastDay; i += dailyInterval) {
                    if (!daysList.isEmpty()) {
                        daysList.append(',');
                    }
                    daysList.append(i);
                }
            } else {
                for (int i = lastDay; i > firstDay; i -= dailyInterval) {
                    if (!daysList.isEmpty()) {
                        daysList.append(',');
                    }
                    daysList.append('D');
                    daysList.append(i);
                }
            }
        } else {
            String[] daysArr;
            for (String day : daysArr = defDaysNode.getFirstChild().getNodeValue().split("\\D+")) {
                if (!daysList.isEmpty()) {
                    daysList.append(',');
                }
                if (!fromMonthStart) {
                    daysList.append('L');
                }
                daysList.append(day);
            }
        }
        rbc.setProperty("DAYS", daysList.toString());
        rbc.setProperty("NAME", this.generateCalName(CalendarType.RBC, caleName, this.getNodeName(keyWord)));
        rbc.setProperty("DAYS_AND_OR", "OR");
        this.setActiveRange(rbc, keyWord);
        this.saveRbc(caleName, this.getNodeName(keyWord), rbc);
    }

    private void convertYearly(Node keyWord, String caleName) {
        Node defDays = this.findChildNodeByName(keyWord, "DefDays");
        String keywordName = this.getNodeName(keyWord);
        if (defDays.getFirstChild() == null || defDays.getFirstChild().getNodeValue().isEmpty()) {
            ArrayList<Properties> fullCal = new ArrayList<Properties>();
            Node dynnamic = this.findChildNodeByName(keyWord, "Dynamic");
            boolean fromStart = dynnamic.getAttributes().getNamedItem("Direction").getNodeValue().equals("B");
            String firstYearStr = dynnamic.getAttributes().getNamedItem("PeriodStart").getNodeValue();
            int interval = Integer.parseInt(dynnamic.getAttributes().getNamedItem("Interval").getNodeValue());
            int yearlyInterval = 1;
            if (!firstYearStr.isEmpty() && IS_EMPTY_OR_NUMBERS.test(firstYearStr)) {
                yearlyInterval = Integer.parseInt(dynnamic.getAttributes().getNamedItem("Period").getNodeValue());
            } else {
                firstYearStr = CURRENT_YEAR_STR;
            }
            int startDay = 1;
            int startMonth = 1;
            int endDay = 31;
            int endMonth = 12;
            String startDate = dynnamic.getAttributes().getNamedItem("IntervalStart").getNodeValue();
            String endDate = dynnamic.getAttributes().getNamedItem("IntervalEnd").getNodeValue();
            if (startDate != null && !startDate.isEmpty() && startDate.matches("[0-9]+")) {
                startDay = Integer.parseInt(startDate.substring(0, 2));
                startMonth = Integer.parseInt(startDate.substring(2));
            }
            if (endDate != null && !endDate.isEmpty() && endDate.matches("[0-9]+")) {
                endDay = Integer.parseInt(endDate.substring(0, 2));
                endMonth = Integer.parseInt(endDate.substring(2));
            }
            int firstYearInt = Integer.parseInt(firstYearStr);
            Integer currYear = firstYearInt;
            while (currYear < firstYearInt + yearlyInterval * 5) {
                Properties yearPerCal = new Properties();
                fullCal.add(yearPerCal);
                yearPerCal.setProperty("NAME", currYear.toString());
                GregorianCalendar tmpCalendar = new GregorianCalendar(currYear, 0, 1);
                StringBuilder periods = new StringBuilder(366);
                while (tmpCalendar.get(2) + 1 < startMonth) {
                    periods.append('X');
                    tmpCalendar.add(5, 1);
                }
                while (tmpCalendar.get(5) < startDay) {
                    periods.append('X');
                    tmpCalendar.add(5, 1);
                }
                while (tmpCalendar.get(2) + 1 < endMonth) {
                    periods.append(' ');
                    tmpCalendar.add(5, 1);
                }
                while (tmpCalendar.get(5) < endDay) {
                    periods.append(' ');
                    tmpCalendar.add(5, 1);
                }
                while (tmpCalendar.get(1) == currYear.intValue()) {
                    periods.append('Z');
                    tmpCalendar.add(5, 1);
                }
                tmpCalendar.set(currYear, startMonth - 1, startDay);
                int firstDay = tmpCalendar.get(6);
                tmpCalendar.set(currYear, endMonth - 1, endDay);
                int lastDay = tmpCalendar.get(6);
                if (interval > 0) {
                    if (fromStart) {
                        for (i = firstDay; i < lastDay; i += interval) {
                            periods.setCharAt(i - 1, 'A');
                        }
                    } else {
                        for (i = lastDay; i > firstDay; i -= interval) {
                            periods.setCharAt(i - 1, 'A');
                        }
                    }
                }
                yearPerCal.setProperty("DAYS", periods.toString());
                currYear = currYear + yearlyInterval;
            }
            String perCalName = this.generateCalName(CalendarType.Periodic, caleName, keywordName);
            Properties staticRbc = new Properties();
            staticRbc.setProperty("NAME", this.generateCalName(CalendarType.RBC, caleName, keywordName));
            staticRbc.setProperty("DAYSCAL", perCalName);
            this.setActiveRange(staticRbc, keyWord);
            GlobalFunctions.setAllMonth((Properties)staticRbc, (String)"1");
            this.saveRbcPeriodic(caleName, keywordName, staticRbc, fullCal, perCalName);
        } else {
            String[] days = defDays.getFirstChild().getNodeValue().split(";");
            CtmCalendar cal = new CtmCalendar(this.generateCalName(CalendarType.Regular, caleName, keywordName), Params.instance().getDatacenterName());
            for (int year = CURRENT_YEAR; year < CURRENT_YEAR + 5; ++year) {
                for (String s : days) {
                    if (!s.matches("^[0-9]+\\.[0-9]+$")) continue;
                    int day = Integer.parseInt(s.substring(0, s.indexOf(46)));
                    int month = Integer.parseInt(s.substring(s.indexOf(46) + 1));
                    cal.addDay(year, month, day);
                }
            }
            Properties staticRbc = new Properties();
            staticRbc.setProperty("DAYSCAL", cal.getName());
            this.saveRbcCtmCalendar(caleName, keyWord, staticRbc, cal);
        }
    }

    private int getValueOrDefault(NamedNodeMap attributes, String key, int defaultValue) {
        String value = attributes.getNamedItem(key).getNodeValue();
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    private void setRbcMonths(Properties rbc, NamedNodeMap dynamicAttributes) {
        String[] months;
        int firstMonth = this.getValueOrDefault(dynamicAttributes, "PeriodStart", 1);
        int lastMonth = this.getValueOrDefault(dynamicAttributes, "PeriodEnd", 12);
        int monthlyInterval = this.getValueOrDefault(dynamicAttributes, "Period", 1);
        for (String month : months = GlobalFunctions.getMonthsArray()) {
            rbc.setProperty(month, "0");
        }
        for (int i = firstMonth - 1; i < lastMonth && i < months.length; i += monthlyInterval) {
            rbc.setProperty(months[i], "1");
        }
    }

    public CtmCalendar generateAllDaysCalendar() {
        CtmCalendar allDaysCalendar = new CtmCalendar("ALLDAYS", Params.instance().getDatacenterName());
        GregorianCalendar tmpCalendar = new GregorianCalendar();
        tmpCalendar.set(2, 0);
        tmpCalendar.set(5, 1);
        int lastYear = tmpCalendar.get(1) + 5;
        while (tmpCalendar.get(1) <= lastYear) {
            allDaysCalendar.addDay(tmpCalendar.get(1), tmpCalendar.get(2) + 1, tmpCalendar.get(5));
            tmpCalendar.add(5, 1);
        }
        return allDaysCalendar;
    }

    public void saveUsedCalendars() {
        String dataCenter = Params.instance().getDatacenterName();
        try (DefCalFile calOutFile = this.createOutPutFile();){
            calOutFile.write(this.generateAllDaysCalendar(), false);
            for (String key : this.calendarsCollector.usages) {
                Pair<List<Properties>, String> periodical;
                if (this.calendarsCollector.ctmCalendar.containsKey(key)) {
                    calOutFile.write(this.calendarsCollector.ctmCalendar.get(key), false);
                }
                if ((periodical = this.calendarsCollector.periodical.get(key)) != null) {
                    calOutFile.writePeriodic((List)periodical.getKey(), dataCenter, (String)periodical.getValue());
                }
                if (!this.calendarsCollector.rbc.containsKey(key)) continue;
                calOutFile.writeRBC(this.calendarsCollector.rbc.get(key));
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
            throw new RuntimeException("Unable to create calendars.xml file", e);
        }
    }

    private DefCalFile createOutPutFile() throws IOException {
        Path evaluationDir;
        Path tmpDir = Paths.get(Globs.TEMP_DIR, new String[0]);
        if (!Files.exists(tmpDir, new LinkOption[0])) {
            Files.createDirectory(tmpDir, new FileAttribute[0]);
        }
        if (!Files.exists(evaluationDir = Paths.get(Globs.TEMP_EVALUATION_DIR, new String[0]), new LinkOption[0])) {
            Files.createDirectory(evaluationDir, new FileAttribute[0]);
        }
        return DefCalFile.createDefCalFile();
    }

    private void convertStatic(Node keyWord, String caleName) {
        String keywordName = this.getNodeName(keyWord);
        CtmCalendar cal = new CtmCalendar(this.generateCalName(CalendarType.Regular, caleName, keywordName), Params.instance().getDatacenterName());
        for (Node monthNode = this.findChildNodeByName(keyWord, "month"); monthNode != null; monthNode = monthNode.getNextSibling()) {
            this.addMonthNodeToCtmCal(monthNode, cal);
        }
        Properties staticRbc = new Properties();
        staticRbc.setProperty("DAYSCAL", cal.getName());
        this.saveRbcCtmCalendar(caleName, keyWord, staticRbc, cal);
    }

    private void addMonthNodeToCtmCal(Node monthNode, CtmCalendar cal) {
        if (!monthNode.getNodeName().equalsIgnoreCase("month")) {
            return;
        }
        Node firstChild = monthNode.getFirstChild();
        if (firstChild == null) {
            return;
        }
        String[] daysArr = firstChild.getNodeValue().split("\\s*,\\s*");
        String month = monthNode.getAttributes().getNamedItem("mm").getNodeValue();
        String year = monthNode.getAttributes().getNamedItem("yyyy").getNodeValue();
        for (String day : daysArr) {
            if (!day.matches("[0-9]+") || !month.matches("[0-9]+") || !year.matches("[0-9]+")) continue;
            cal.addDay(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
    }

    protected String generateCalName(CalendarType type, String caleName, String keywordName) {
        int maxLength = this.getCalendarMaxLength(type);
        String nameValidationString = this.getNameForValidation(type);
        String newCalendarName = this.uniqueValue.getUniqueValue("Calendar", keywordName, maxLength);
        newCalendarName = FieldValidation.instance().validateAndReturnFixedValue(nameValidationString, newCalendarName);
        if (type == CalendarType.RBC && !newCalendarName.equals(keywordName)) {
            String messageKey = String.format("%s.%s", caleName, keywordName);
            String[] messageParams = new String[]{keywordName, newCalendarName, caleName};
            this.addMessage(messageKey, "INF8004", messageParams);
        }
        return newCalendarName;
    }

    private int getCalendarMaxLength(CalendarType type) {
        int maxLength = 30;
        if (type == CalendarType.RBC) {
            maxLength = 19;
        }
        return maxLength;
    }

    private String getNameForValidation(CalendarType type) {
        String nameValidationString = "CAL_NAME";
        if (type == CalendarType.RBC) {
            nameValidationString = "TAG_NAME";
        }
        return nameValidationString;
    }

    public Set<Properties> getRbcs(String cale, String keyWord) {
        if (this.cale2rbc.containsKey(cale) && this.cale2rbc.get(cale).containsKey(keyWord)) {
            this.calendarsCollector.setUsage(cale, keyWord);
            return this.cale2rbc.get(cale).get(keyWord);
        }
        return new HashSet<Properties>();
    }

    private Node findChildNodeByName(Node node, String name) {
        if (node.getNodeName().equalsIgnoreCase(name)) {
            return node;
        }
        if (!node.hasChildNodes()) {
            return null;
        }
        for (Node toTest = node.getFirstChild(); toTest != null; toTest = toTest.getNextSibling()) {
            Node tmpNode = this.findChildNodeByName(toTest, name);
            if (tmpNode == null) continue;
            return tmpNode;
        }
        return null;
    }

    private List<Node> getAllChildNodesByName(Node node, String name) {
        NodeList children = node.getChildNodes();
        return this.nodeListToStream(children).filter(n -> n.getNodeName().equals(name)).collect(Collectors.toList());
    }

    private Stream<Node> nodeListToStream(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
    }

    private void setActiveRange(Properties rbc, Node keyword) {
        String from = "";
        String until = "";
        NamedNodeMap keywordAttributes = keyword.getAttributes();
        Node validFromNode = keywordAttributes.getNamedItem("ValidFrom");
        Node validToNode = keywordAttributes.getNamedItem("ValidTo");
        if (validFromNode != null) {
            from = validFromNode.getNodeValue();
            from = from.substring(0, 10).replace("-", "");
        }
        if (validToNode != null) {
            until = validToNode.getNodeValue();
            until = until.substring(0, 10).replace("-", "");
        }
        if (rbc != null) {
            rbc.setProperty("ACTIVE_FROM", from);
            rbc.setProperty("ACTIVE_TILL", until);
        }
    }

    private void addMessage(String key, String messageID, String[] message) {
        if (!this.caleKeyWord2Messages.containsKey(key)) {
            this.caleKeyWord2Messages.put(key, new HashMap());
        }
        if (!this.caleKeyWord2Messages.get(key).containsKey(messageID)) {
            this.caleKeyWord2Messages.get(key).put(messageID, new ArrayList());
        }
        this.caleKeyWord2Messages.get(key).get(messageID).add(message);
    }

    static class CalendarsCollector {
        final Map<String, Properties> rbc = new HashMap<String, Properties>();
        final Map<String, CtmCalendar> ctmCalendar = new HashMap<String, CtmCalendar>();
        final Map<String, Pair<List<Properties>, String>> periodical = new HashMap<String, Pair<List<Properties>, String>>();
        final Set<String> usages = new HashSet<String>();

        CalendarsCollector() {
        }

        private String key(String caleName, String keyWordName) {
            return caleName + "," + keyWordName;
        }

        void addRbc(String caleName, String keyWordName, Properties prop) {
            String key = this.key(caleName, keyWordName);
            this.rbc.put(key, prop);
        }

        void addCtmCalendar(String caleName, String keyWordName, CtmCalendar prop) {
            if (prop != null) {
                this.ctmCalendar.put(this.key(caleName, keyWordName), prop);
            }
        }

        void addPeriodical(String caleName, String keyWordName, List<Properties> periodicCal, String periodicCalName) {
            this.periodical.put(this.key(caleName, keyWordName), (Pair<List<Properties>, String>)new Pair(periodicCal, (Object)periodicCalName));
        }

        void setUsage(String caleName, String keyWordName) {
            this.usages.add(this.key(caleName, keyWordName));
        }
    }

    protected static enum CalendarType {
        RBC,
        Periodic,
        Regular;

    }
}

